﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pinpoint-sms-voice-v2/PinpointSMSVoiceV2_EXPORTS.h>
#include <aws/pinpoint-sms-voice-v2/model/MessageType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PinpointSMSVoiceV2 {
namespace Model {
class ReleaseSenderIdResult {
 public:
  AWS_PINPOINTSMSVOICEV2_API ReleaseSenderIdResult() = default;
  AWS_PINPOINTSMSVOICEV2_API ReleaseSenderIdResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PINPOINTSMSVOICEV2_API ReleaseSenderIdResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) associated with the SenderId.</p>
   */
  inline const Aws::String& GetSenderIdArn() const { return m_senderIdArn; }
  template <typename SenderIdArnT = Aws::String>
  void SetSenderIdArn(SenderIdArnT&& value) {
    m_senderIdArnHasBeenSet = true;
    m_senderIdArn = std::forward<SenderIdArnT>(value);
  }
  template <typename SenderIdArnT = Aws::String>
  ReleaseSenderIdResult& WithSenderIdArn(SenderIdArnT&& value) {
    SetSenderIdArn(std::forward<SenderIdArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The sender ID that was released.</p>
   */
  inline const Aws::String& GetSenderId() const { return m_senderId; }
  template <typename SenderIdT = Aws::String>
  void SetSenderId(SenderIdT&& value) {
    m_senderIdHasBeenSet = true;
    m_senderId = std::forward<SenderIdT>(value);
  }
  template <typename SenderIdT = Aws::String>
  ReleaseSenderIdResult& WithSenderId(SenderIdT&& value) {
    SetSenderId(std::forward<SenderIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The two-character code, in ISO 3166-1 alpha-2 format, for the country or
   * region.</p>
   */
  inline const Aws::String& GetIsoCountryCode() const { return m_isoCountryCode; }
  template <typename IsoCountryCodeT = Aws::String>
  void SetIsoCountryCode(IsoCountryCodeT&& value) {
    m_isoCountryCodeHasBeenSet = true;
    m_isoCountryCode = std::forward<IsoCountryCodeT>(value);
  }
  template <typename IsoCountryCodeT = Aws::String>
  ReleaseSenderIdResult& WithIsoCountryCode(IsoCountryCodeT&& value) {
    SetIsoCountryCode(std::forward<IsoCountryCodeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of message. Valid values are TRANSACTIONAL for messages that are
   * critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
   * time-sensitive.</p>
   */
  inline const Aws::Vector<MessageType>& GetMessageTypes() const { return m_messageTypes; }
  template <typename MessageTypesT = Aws::Vector<MessageType>>
  void SetMessageTypes(MessageTypesT&& value) {
    m_messageTypesHasBeenSet = true;
    m_messageTypes = std::forward<MessageTypesT>(value);
  }
  template <typename MessageTypesT = Aws::Vector<MessageType>>
  ReleaseSenderIdResult& WithMessageTypes(MessageTypesT&& value) {
    SetMessageTypes(std::forward<MessageTypesT>(value));
    return *this;
  }
  inline ReleaseSenderIdResult& AddMessageTypes(MessageType value) {
    m_messageTypesHasBeenSet = true;
    m_messageTypes.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The monthly price, in US dollars, to lease the sender ID.</p>
   */
  inline const Aws::String& GetMonthlyLeasingPrice() const { return m_monthlyLeasingPrice; }
  template <typename MonthlyLeasingPriceT = Aws::String>
  void SetMonthlyLeasingPrice(MonthlyLeasingPriceT&& value) {
    m_monthlyLeasingPriceHasBeenSet = true;
    m_monthlyLeasingPrice = std::forward<MonthlyLeasingPriceT>(value);
  }
  template <typename MonthlyLeasingPriceT = Aws::String>
  ReleaseSenderIdResult& WithMonthlyLeasingPrice(MonthlyLeasingPriceT&& value) {
    SetMonthlyLeasingPrice(std::forward<MonthlyLeasingPriceT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>True if the sender ID is registered.</p>
   */
  inline bool GetRegistered() const { return m_registered; }
  inline void SetRegistered(bool value) {
    m_registeredHasBeenSet = true;
    m_registered = value;
  }
  inline ReleaseSenderIdResult& WithRegistered(bool value) {
    SetRegistered(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier for the registration.</p>
   */
  inline const Aws::String& GetRegistrationId() const { return m_registrationId; }
  template <typename RegistrationIdT = Aws::String>
  void SetRegistrationId(RegistrationIdT&& value) {
    m_registrationIdHasBeenSet = true;
    m_registrationId = std::forward<RegistrationIdT>(value);
  }
  template <typename RegistrationIdT = Aws::String>
  ReleaseSenderIdResult& WithRegistrationId(RegistrationIdT&& value) {
    SetRegistrationId(std::forward<RegistrationIdT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ReleaseSenderIdResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_senderIdArn;

  Aws::String m_senderId;

  Aws::String m_isoCountryCode;

  Aws::Vector<MessageType> m_messageTypes;

  Aws::String m_monthlyLeasingPrice;

  bool m_registered{false};

  Aws::String m_registrationId;

  Aws::String m_requestId;
  bool m_senderIdArnHasBeenSet = false;
  bool m_senderIdHasBeenSet = false;
  bool m_isoCountryCodeHasBeenSet = false;
  bool m_messageTypesHasBeenSet = false;
  bool m_monthlyLeasingPriceHasBeenSet = false;
  bool m_registeredHasBeenSet = false;
  bool m_registrationIdHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PinpointSMSVoiceV2
}  // namespace Aws
