﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/voice-id/VoiceID_EXPORTS.h>
#include <aws/voice-id/model/Fraudster.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace VoiceID {
namespace Model {
class AssociateFraudsterResult {
 public:
  AWS_VOICEID_API AssociateFraudsterResult() = default;
  AWS_VOICEID_API AssociateFraudsterResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_VOICEID_API AssociateFraudsterResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{

  inline const Fraudster& GetFraudster() const { return m_fraudster; }
  template <typename FraudsterT = Fraudster>
  void SetFraudster(FraudsterT&& value) {
    m_fraudsterHasBeenSet = true;
    m_fraudster = std::forward<FraudsterT>(value);
  }
  template <typename FraudsterT = Fraudster>
  AssociateFraudsterResult& WithFraudster(FraudsterT&& value) {
    SetFraudster(std::forward<FraudsterT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  AssociateFraudsterResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Fraudster m_fraudster;

  Aws::String m_requestId;
  bool m_fraudsterHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace VoiceID
}  // namespace Aws
