﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/odb/Odb_EXPORTS.h>
#include <aws/odb/model/DbServerSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace odb {
namespace Model {
class ListDbServersResult {
 public:
  AWS_ODB_API ListDbServersResult() = default;
  AWS_ODB_API ListDbServersResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ODB_API ListDbServersResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The token to include in another request to get the next page of items. This
   * value is <code>null</code> when there are no more items to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListDbServersResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of database servers along with their properties.</p>
   */
  inline const Aws::Vector<DbServerSummary>& GetDbServers() const { return m_dbServers; }
  template <typename DbServersT = Aws::Vector<DbServerSummary>>
  void SetDbServers(DbServersT&& value) {
    m_dbServersHasBeenSet = true;
    m_dbServers = std::forward<DbServersT>(value);
  }
  template <typename DbServersT = Aws::Vector<DbServerSummary>>
  ListDbServersResult& WithDbServers(DbServersT&& value) {
    SetDbServers(std::forward<DbServersT>(value));
    return *this;
  }
  template <typename DbServersT = DbServerSummary>
  ListDbServersResult& AddDbServers(DbServersT&& value) {
    m_dbServersHasBeenSet = true;
    m_dbServers.emplace_back(std::forward<DbServersT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListDbServersResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<DbServerSummary> m_dbServers;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_dbServersHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace odb
}  // namespace Aws
