/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.utils;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public class GsonDateAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    public static final GsonDateAdapter INSTANCE = new GsonDateAdapter();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMddHHmm[Z]");

    private GsonDateAdapter() {
    }

    public Date deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
        TemporalAccessor accessor = FORMATTER.parseBest(element.getAsString(), ZonedDateTime::from, LocalDateTime::from);
        if (accessor instanceof ZonedDateTime) {
            return Date.from(((ZonedDateTime)accessor).toInstant());
        }
        return Date.from(((LocalDateTime)accessor).atZone(ZoneId.systemDefault()).toInstant());
    }

    public JsonElement serialize(Date date, Type type, JsonSerializationContext context) {
        return new JsonPrimitive(FORMATTER.format(date.toInstant().atZone(ZoneId.systemDefault())));
    }
}

