/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.object.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.TableColumnSortListener;
import org.jkiss.dbeaver.ui.editors.object.internal.ObjectEditorMessages;
import org.jkiss.dbeaver.ui.editors.object.struct.BaseObjectEditPage;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public abstract class AttributesSelectorPage<T_OBJECT extends DBSObject, T_ATTRIBUTE extends DBSAttributeBase & DBSObject>
extends BaseObjectEditPage {
    protected T_OBJECT object;
    protected Table columnsTable;
    protected List<AttributeInfo<T_ATTRIBUTE>> attributes = new ArrayList<AttributeInfo<T_ATTRIBUTE>>();
    protected Button toggleButton;
    protected Composite columnsGroup;

    protected AttributesSelectorPage(String title, T_OBJECT object) {
        super(NLS.bind((String)ObjectEditorMessages.dialog_struct_columns_select_title, (Object)title, (Object)DBUtils.getObjectFullName(object, (DBPEvaluationContext)DBPEvaluationContext.UI)));
        this.object = object;
    }

    protected AttributesSelectorPage() {
        super(null);
        this.object = null;
    }

    public Map<String, Object> getAttributeProperties(T_ATTRIBUTE attr) {
        for (AttributeInfo<T_ATTRIBUTE> attrInfo : this.attributes) {
            if (attrInfo.attribute != attr) continue;
            return attrInfo.properties;
        }
        return Collections.emptyMap();
    }

    public Object getAttributeProperty(T_ATTRIBUTE attr, String propName) {
        for (AttributeInfo<T_ATTRIBUTE> attrInfo : this.attributes) {
            if (attrInfo.attribute != attr) continue;
            return attrInfo.properties.get(propName);
        }
        return null;
    }

    protected Composite createPageContents(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout(1, false));
        panel.setLayoutData((Object)new GridData(1808));
        Composite tableGroup = this.createTableNameInput(panel);
        this.createContentsBeforeColumns(tableGroup);
        this.createColumnsGroup(panel);
        this.createContentsAfterColumns(panel);
        this.fillAttributes(this.object);
        return panel;
    }

    protected void createColumnsGroup(Composite panel) {
        this.columnsGroup = UIUtils.createComposite((Composite)panel, (int)1);
        this.columnsGroup.setLayoutData((Object)new GridData(1808));
        UIUtils.createControlLabel((Composite)this.columnsGroup, (String)ObjectEditorMessages.dialog_struct_columns_select_group_columns);
        this.columnsTable = new Table(this.columnsGroup, 67620);
        this.columnsTable.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 150;
        this.columnsTable.setLayoutData((Object)gd);
        this.columnsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributesSelectorPage.this.handleItemSelect((TableItem)e.item, true);
                AttributesSelectorPage.this.validateProperties();
            }
        });
        this.createAttributeColumns(this.columnsTable);
        new CustomTableEditor(this.columnsTable){

            protected Control createEditor(Table table, int index, TableItem item) {
                return AttributesSelectorPage.this.createCellEditor(table, index, item, (AttributeInfo)item.getData());
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                AttributesSelectorPage.this.saveCellValue(control, index, item, (AttributeInfo)item.getData());
            }
        };
        this.toggleButton = new Button(this.columnsGroup, 8);
        this.toggleButton.setText(ObjectEditorMessages.selector_select_all_text);
        gd = new GridData(32);
        gd.widthHint = 120;
        this.toggleButton.setLayoutData((Object)gd);
        this.toggleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem[] items = AttributesSelectorPage.this.columnsTable.getItems();
                if (AttributesSelectorPage.this.hasCheckedColumns()) {
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        if (item.getChecked()) {
                            item.setChecked(false);
                            AttributesSelectorPage.this.handleItemSelect(item, true);
                        }
                        ++n2;
                    }
                } else {
                    TableItem[] tableItemArray = items;
                    int n = items.length;
                    int n3 = 0;
                    while (n3 < n) {
                        TableItem item = tableItemArray[n3];
                        if (!item.getChecked()) {
                            item.setChecked(true);
                            AttributesSelectorPage.this.handleItemSelect(item, true);
                        }
                        ++n3;
                    }
                }
                AttributesSelectorPage.this.validateProperties();
            }
        });
    }

    protected void createAttributeColumns(Table columnsTable) {
        TableColumn colName = UIUtils.createTableColumn((Table)columnsTable, (int)0, (String)ObjectEditorMessages.dialog_struct_columns_select_column);
        colName.addListener(13, (Listener)new TableColumnSortListener(columnsTable, 0));
        TableColumn colPosition = UIUtils.createTableColumn((Table)columnsTable, (int)0x1000000, (String)"#");
        colPosition.addListener(13, (Listener)new TableColumnSortListener(columnsTable, 1));
        TableColumn colType = UIUtils.createTableColumn((Table)columnsTable, (int)131072, (String)ObjectEditorMessages.dialog_struct_columns_type);
        colType.addListener(13, (Listener)new TableColumnSortListener(columnsTable, 2));
    }

    protected int fillAttributeColumns(T_ATTRIBUTE attribute, AttributeInfo<T_ATTRIBUTE> attributeInfo, TableItem columnItem) {
        columnItem.setText(0, attribute.getName());
        columnItem.setText(2, attribute.getFullTypeName());
        return 2;
    }

    protected Control createCellEditor(Table table, int index, TableItem item, AttributeInfo<T_ATTRIBUTE> data) {
        return null;
    }

    protected void saveCellValue(Control control, int index, TableItem item, AttributeInfo<T_ATTRIBUTE> data) {
    }

    protected void setObject(@Nullable T_OBJECT object) {
        this.object = object;
        this.attributes.clear();
        this.columnsTable.removeAll();
        this.fillAttributes(object);
    }

    @NotNull
    protected abstract List<? extends T_ATTRIBUTE> getAttributes(@NotNull DBRProgressMonitor var1, @NotNull T_OBJECT var2) throws DBException;

    private void fillAttributes(@Nullable T_OBJECT object) {
        if (object == null) {
            return;
        }
        final ArrayList attrList = new ArrayList();
        AbstractJob loadJob = new AbstractJob("Load entity attributes", (DBSObject)object, attrList){
            private final /* synthetic */ DBSObject val$object;
            private final /* synthetic */ List val$attrList;
            {
                this.val$object = dBSObject;
                this.val$attrList = list;
                super($anonymous0);
            }

            @NotNull
            protected IStatus run(@NotNull DBRProgressMonitor monitor) {
                monitor.beginTask("Load attributes", 1);
                try {
                    try {
                        for (DBSAttributeBase attr : AttributesSelectorPage.this.getAttributes(monitor, this.val$object)) {
                            DBSEntityAttribute ea;
                            if (!AttributesSelectorPage.this.isShowHiddenAttributes() && DBUtils.isHiddenObject((Object)attr) && (!(attr instanceof DBSEntityAttribute) || !DBUtils.isRowIdAttribute((DBSEntityAttribute)(ea = (DBSEntityAttribute)attr)))) continue;
                            this.val$attrList.add(attr);
                            DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(monitor, (DBSObject)attr, true);
                        }
                    }
                    catch (DBException e) {
                        IStatus iStatus = GeneralUtils.makeErrorStatus((String)"Error loading attributes", (Throwable)e);
                        monitor.done();
                        return iStatus;
                    }
                }
                finally {
                    monitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        loadJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                UIUtils.syncExec(() -> {
                    for (DBSAttributeBase attribute : attrList) {
                        TableItem columnItem = new TableItem(AttributesSelectorPage.this.columnsTable, 0);
                        AttributeInfo<DBSAttributeBase> col = new AttributeInfo<DBSAttributeBase>(attribute);
                        AttributesSelectorPage.this.attributes.add(col);
                        DBNDatabaseNode attributeNode = DBWorkbench.getPlatform().getNavigatorModel().findNode((DBSObject)attribute);
                        if (attributeNode != null) {
                            columnItem.setImage(0, DBeaverIcons.getImage((DBPImage)attributeNode.getNodeIcon()));
                        }
                        AttributesSelectorPage.this.fillAttributeColumns(attribute, col, columnItem);
                        columnItem.setData(col);
                    }
                    UIUtils.packColumns((Table)AttributesSelectorPage.this.columnsTable);
                    AttributesSelectorPage.this.updateColumnSelection();
                    AttributesSelectorPage.this.onAttributesLoad();
                    AttributesSelectorPage.this.preselectAttributes();
                });
            }
        });
        loadJob.schedule();
    }

    private void preselectAttributes() {
        IStructuredSelection selection = AttributesSelectorPage.getCurrentSelection();
        if (selection == null) {
            return;
        }
        block0: for (Object selItem : selection) {
            TableItem[] tableColumns;
            DBNNode selNode = (DBNNode)RuntimeUtils.getObjectAdapter(selItem, DBNNode.class);
            if (!(selNode instanceof DBNDatabaseNode)) continue;
            DBSObject dbsObject = ((DBNDatabaseNode)selNode).getObject();
            TableItem[] tableItemArray = tableColumns = this.columnsTable.getItems();
            int n = tableColumns.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem tableItem = tableItemArray[n2];
                Object data = tableItem.getData();
                if (data instanceof AttributeInfo) {
                    AttributeInfo attributeInfo = (AttributeInfo)data;
                    if (Objects.equals(dbsObject, attributeInfo.attribute)) {
                        tableItem.setChecked(true);
                        this.handleItemSelect(tableItem, true);
                        continue block0;
                    }
                }
                ++n2;
            }
        }
    }

    @Nullable
    private static IStructuredSelection getCurrentSelection() {
        IWorkbenchPart part = UIUtils.getActiveWorkbenchWindow().getActivePage().getActivePart();
        if (part == null) {
            return null;
        }
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return null;
        }
        ISelection selection = selectionProvider.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        return (IStructuredSelection)selection;
    }

    protected void onAttributesLoad() {
    }

    protected boolean isShowHiddenAttributes() {
        return false;
    }

    private Composite createTableNameInput(Composite panel) {
        Composite tableGroup = new Composite(panel, 0);
        tableGroup.setLayout((Layout)new GridLayout(2, false));
        tableGroup.setLayoutData((Object)new GridData(768));
        UIUtils.createLabelText((Composite)tableGroup, (String)ObjectEditorMessages.dialog_struct_columns_select_label_table, (String)DBUtils.getObjectFullName(this.object, (DBPEvaluationContext)DBPEvaluationContext.UI), (int)2056, (Object)new GridData(768));
        return tableGroup;
    }

    void handleItemSelect(TableItem item, boolean notify) {
        AttributeInfo col = (AttributeInfo)item.getData();
        if (item.getChecked() && col.position < 0) {
            col.position = 0;
            for (AttributeInfo<T_ATTRIBUTE> tmp : this.attributes) {
                if (tmp == col || tmp.position < col.position) continue;
                col.position = tmp.position + 1;
            }
            item.setText(1, String.valueOf(col.position + 1));
        } else if (!item.getChecked() && col.position >= 0) {
            item.setText(1, "");
            TableItem[] allItems = this.columnsTable.getItems();
            block1: for (AttributeInfo<T_ATTRIBUTE> tmp : this.attributes) {
                if (tmp == col || tmp.position < col.position) continue;
                --tmp.position;
                TableItem[] tableItemArray = allItems;
                int n = allItems.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ai = tableItemArray[n2];
                    if (ai.getData() == tmp) {
                        ai.setText(1, String.valueOf(tmp.position + 1));
                        continue block1;
                    }
                    ++n2;
                }
            }
            col.position = -1;
        }
        if (notify) {
            this.handleColumnsChange();
            this.updateToggleButton();
            this.updatePageState();
        }
    }

    private boolean hasCheckedColumns() {
        boolean hasCheckedColumns = false;
        for (AttributeInfo<T_ATTRIBUTE> tmp : this.attributes) {
            if (tmp.position < 0) continue;
            hasCheckedColumns = true;
            break;
        }
        return hasCheckedColumns;
    }

    private void updateToggleButton() {
        if (this.hasCheckedColumns()) {
            this.toggleButton.setText(ObjectEditorMessages.selector_clear_all_text);
        } else {
            this.toggleButton.setText(ObjectEditorMessages.selector_select_all_text);
        }
    }

    @NotNull
    public List<T_ATTRIBUTE> getSelectedAttributes() {
        return this.attributes.stream().filter(o -> o.position >= 0).sorted(Comparator.comparingInt(AttributeInfo::getPosition)).map(AttributeInfo::getAttribute).toList();
    }

    protected void createContentsBeforeColumns(Composite panel) {
    }

    protected void createContentsAfterColumns(Composite panel) {
    }

    protected boolean isColumnsRequired() {
        return true;
    }

    public void setSelectedColumns(@NotNull Collection<? extends DBSAttributeBase> attributes) {
        TableItem[] tableItemArray = this.columnsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getChecked()) {
                tableItem.setChecked(false);
                this.handleItemSelect(tableItem, false);
            }
            ++n2;
        }
        for (DBSAttributeBase dBSAttributeBase : attributes) {
            this.setColumnSelected(dBSAttributeBase, true);
        }
    }

    public void setColumnSelected(@NotNull DBSAttributeBase attribute, boolean selected) {
        TableItem[] tableItemArray = this.columnsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object object = item.getData();
            if (object instanceof AttributeInfo) {
                AttributeInfo info = (AttributeInfo)object;
                if (attribute.equals(info.attribute)) {
                    item.setChecked(selected);
                    this.handleItemSelect(item, false);
                    break;
                }
            }
            ++n2;
        }
        this.updateToggleButton();
    }

    private void updateColumnSelection(@NotNull Predicate<T_ATTRIBUTE> predicate) {
        TableItem[] tableItemArray = this.columnsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeInfo info;
            DBSAttributeBase attribute;
            TableItem item = tableItemArray[n2];
            item.setChecked(false);
            Object object = item.getData();
            if (object instanceof AttributeInfo && predicate.test(attribute = (DBSAttributeBase)(info = (AttributeInfo)object).getAttribute())) {
                item.setChecked(true);
            }
            this.handleItemSelect(item, false);
            ++n2;
        }
        this.updateToggleButton();
    }

    public void updateColumnSelection() {
        this.updateColumnSelection(T_ATTRIBUTE -> this.isColumnSelected(T_ATTRIBUTE));
    }

    public boolean isColumnSelected(T_ATTRIBUTE attribute) {
        return false;
    }

    protected void handleColumnsChange() {
    }

    @Override
    protected String getEditError() {
        if (this.isColumnsRequired() && !this.hasCheckedColumns()) {
            return "You must select at least one column";
        }
        return super.getEditError();
    }

    @Override
    public boolean isPageComplete() {
        TableItem[] tableItemArray = this.columnsTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected static class AttributeInfo<T extends DBSAttributeBase> {
        T attribute;
        int position;
        Map<String, Object> properties = new HashMap<String, Object>();

        public AttributeInfo(T attribute) {
            this.attribute = attribute;
            this.position = -1;
        }

        public T getAttribute() {
            return this.attribute;
        }

        public int getPosition() {
            return this.position;
        }

        public Object getProperty(String name) {
            return this.properties.get(name);
        }

        public void setProperty(String name, Object value) {
            if (value == null) {
                this.properties.remove(name);
            } else {
                this.properties.put(name, value);
            }
        }

        public String toString() {
            return this.attribute.getName();
        }
    }
}

