/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.openai;

import java.net.http.HttpRequest;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIClient;

public class OpenAIRequestFilter
implements OpenAIClient.HttpRequestFilter {
    private final String token;

    public OpenAIRequestFilter(String token) {
        this.token = token;
    }

    @Override
    @NotNull
    public HttpRequest filter(@NotNull HttpRequest request, boolean setContentType) {
        HttpRequest.Builder builder = HttpRequest.newBuilder(request.uri()).uri(request.uri()).method(request.method(), request.bodyPublisher().orElse(HttpRequest.BodyPublishers.noBody())).headers("Authorization", "Bearer " + this.token);
        for (Map.Entry<String, List<String>> headerEntry : request.headers().map().entrySet()) {
            for (String value : headerEntry.getValue()) {
                builder.header(headerEntry.getKey(), value);
            }
        }
        if (setContentType) {
            builder.header("Content-Type", "application/json");
        }
        return builder.build();
    }
}

