/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class PostgresUserPasswordManager
implements DBAUserPasswordManager {
    private PostgreDataSource dataSource;

    public PostgresUserPasswordManager(PostgreDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void changeUserPassword(@NotNull DBRProgressMonitor monitor, @NotNull String userName, @NotNull String newPassword, @NotNull String oldPassword) throws DBException {
        if (CommonUtils.isEmpty((String)newPassword)) {
            throw new DBException("Password change error for user: " + userName + ". New password can not be empty.");
        }
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Change user password");){
            session.enableLogging(false);
            JDBCUtils.executeSQL((Connection)session, (String)("ALTER USER " + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)userName) + " WITH PASSWORD " + SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)CommonUtils.notEmpty((String)newPassword))), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            throw new DBCException("Error changing user password", (Throwable)e);
        }
    }
}

