/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.model.plan;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.cubrid.model.plan.CubridPlanNode;
import org.jkiss.dbeaver.ext.cubrid.model.plan.CubridStatementProxy;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;
import org.jkiss.utils.CommonUtils;

public class CubridPlanAnalyser
extends AbstractExecutionPlan {
    private List<CubridPlanNode> rootNodes = new ArrayList<CubridPlanNode>();
    private String query;
    private String plan;

    public CubridPlanAnalyser(@NotNull JDBCSession session, @NotNull String query) throws DBCException {
        this.query = query;
        try {
            this.plan = CubridStatementProxy.getQueryplan(session.getOriginal().createStatement(), query);
            ArrayList<CubridPlanNode> tempNode = new ArrayList<CubridPlanNode>();
            CubridPlanNode parent = new CubridPlanNode();
            long totalCost = 0L;
            for (String fullText : this.plan.split("(?=Join graph segments)")) {
                if (!CommonUtils.isNotEmpty((String)fullText)) continue;
                CubridPlanNode node = new CubridPlanNode(fullText);
                totalCost += node.getCost();
                tempNode.add(node);
            }
            parent.setAllNestedNode(tempNode);
            parent.setCost(totalCost);
            this.rootNodes.add(parent);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
        }
    }

    @NotNull
    public List<? extends DBCPlanNode> getPlanNodes(@Nullable Map<String, Object> options) {
        return this.rootNodes;
    }

    @NotNull
    public String getQueryString() {
        return this.query;
    }

    @NotNull
    public String getPlanQueryString() {
        return this.plan;
    }
}

