/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformer;
import org.jkiss.dbeaver.model.data.DBDAttributeTransformerProvider;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLGroupingAttribute;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.Pair;

public class GroupingDataContainer
implements DBDAttributeTransformerProvider,
DBSDataContainer {
    private static final Log log = Log.getLog(GroupingDataContainer.class);
    private IResultSetController parentController;
    private String query;
    private SQLGroupingAttribute[] attributes;
    @Nullable
    private Pair<Integer, DBDAttributeTransformer> attributeBindingNumberToTransformer;

    public GroupingDataContainer(IResultSetController parentController) {
        this.parentController = parentController;
    }

    public DBSObject getParentObject() {
        return this.parentController.getDataContainer();
    }

    @NotNull
    public String getName() {
        if (ArrayUtils.isEmpty((Object[])this.attributes)) {
            return "Grouping";
        }
        return Arrays.stream(this.attributes).map(SQLGroupingAttribute::getDisplayName).collect(Collectors.joining(","));
    }

    public String getDescription() {
        return "Grouping data";
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.parentController.getDataContainer().getDataSource();
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.select", "data.filter"};
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBException {
        DBCStatistics statistics = new DBCStatistics();
        if (this.query == null) {
            statistics.addMessage("Empty query");
            return statistics;
        }
        boolean hasLimits = firstRow >= 0L && maxRows > 0L;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        StringBuilder sqlQuery = new StringBuilder(this.query);
        DBPDataSource dataSource = this.getDataSource();
        if (dataSource != null) {
            SQLUtils.appendQueryOrder((DBPDataSource)dataSource, (StringBuilder)sqlQuery, null, (DBDDataFilter)dataFilter);
        }
        Object sql = sqlQuery.toString();
        if (dataSource != null && dataFilter.hasConditions()) {
            sqlQuery.setLength(0);
            String gbAlias = "gbq_";
            try {
                SQLUtils.appendQueryConditions((DBPDataSource)dataSource, (StringBuilder)sqlQuery, (String)gbAlias, (DBDDataFilter)dataFilter);
            }
            catch (DBException e) {
                throw new DBCException("Can't generate query conditions", (Throwable)e, session.getExecutionContext());
            }
            sql = "SELECT * FROM (" + (String)sql + ") " + gbAlias + " " + String.valueOf(sqlQuery);
        }
        statistics.setQueryText((String)sql);
        statistics.addStatementsCount();
        monitor.subTask(ModelMessages.model_jdbc_fetch_table_data);
        try {
            DBCStatistics dBCStatistics;
            block27: {
                DBCStatement dbStat;
                block24: {
                    DBCStatistics e;
                    block25: {
                        dbStat = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (String)sql, (long)firstRow, (long)maxRows);
                        if (!monitor.isCanceled()) break block24;
                        e = statistics;
                        if (dbStat == null) break block25;
                        dbStat.close();
                    }
                    return e;
                }
                try {
                    long startTime = System.currentTimeMillis();
                    boolean executeResult = dbStat.executeStatement();
                    statistics.setExecuteTime(System.currentTimeMillis() - startTime);
                    if (executeResult) {
                        try (DBCResultSet dbResult = dbStat.openResultSet();){
                            long rowCount;
                            DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)dbResult, (long)firstRow, (long)maxRows);
                            startTime = System.currentTimeMillis();
                            for (rowCount = 0L; !(!dbResult.nextRow() || monitor.isCanceled() || hasLimits && rowCount >= maxRows); ++rowCount) {
                                dataReceiver.fetchRow(session, dbResult);
                            }
                            statistics.setFetchTime(System.currentTimeMillis() - startTime);
                            statistics.setRowsFetched(rowCount);
                        }
                    }
                    dBCStatistics = statistics;
                    if (dbStat == null) break block27;
                }
                catch (Throwable throwable) {
                    if (dbStat != null) {
                        try {
                            dbStat.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dbStat.close();
            }
            return dBCStatistics;
        }
        finally {
            dataReceiver.close();
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        return 0L;
    }

    public boolean isPersisted() {
        return false;
    }

    public void setGroupingQuery(String sql) {
        this.query = sql;
    }

    public void setGroupingAttributes(@Nullable SQLGroupingAttribute[] attributes) {
        this.attributes = attributes;
    }

    @NotNull
    public List<DBDAttributeTransformer> findTransformerForBinding(@NotNull DBDAttributeBinding attributeBinding) {
        DBDAttributeTransformer transformer = this.attributeBindingNumberToTransformer != null && ((Integer)this.attributeBindingNumberToTransformer.getFirst()).equals(attributeBinding.getOrdinalPosition()) ? (DBDAttributeTransformer)this.attributeBindingNumberToTransformer.getSecond() : null;
        return transformer != null ? Collections.singletonList(transformer) : Collections.emptyList();
    }

    public void setAttributeTransformer(int attributeIndex, @NotNull DBDAttributeTransformer transformer) {
        this.attributeBindingNumberToTransformer = Pair.of((Object)attributeIndex, (Object)transformer);
    }

    public void removeAttributeTransformer() {
        this.attributeBindingNumberToTransformer = null;
    }

    @Nullable
    public SQLGroupingAttribute[] getGroupingAttributes() {
        return this.attributes;
    }

    public String toString() {
        return this.getName();
    }
}

