/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;

public class HCS12ConventionAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "HCS12 Calling Convention";
    private static final String DESCRIPTION = "Analyzes HCS12 programs with paged memory access  to identify a calling convention for each function.  This analyzer looks at the type of return used for the function to identify the calling convention.";
    Register xgate = null;

    public HCS12ConventionAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPriority(AnalysisPriority.FUNCTION_ANALYSIS);
        this.setDefaultEnablement(true);
    }

    public boolean canAnalyze(Program program) {
        Processor processor = program.getLanguage().getProcessor();
        boolean canDo = processor.equals((Object)Processor.findOrPossiblyCreateProcessor((String)"HCS12"));
        if (canDo) {
            this.xgate = program.getRegister("XGATE");
        }
        return canDo;
    }

    void checkReturn(Program program, Instruction instr) {
        String mnemonic = instr.getMnemonicString().toLowerCase();
        if (instr == null || !instr.getFlowType().isTerminal()) {
            return;
        }
        RegisterValue xgateValue = program.getProgramContext().getRegisterValue(this.xgate, instr.getMinAddress());
        if (xgateValue != null && xgateValue.hasValue() && xgateValue.getUnsignedValue().equals(BigInteger.ONE)) {
            this.setPrototypeModel(program, instr, "__asm_xgate");
            return;
        }
        if (mnemonic.equals("rtc")) {
            this.setPrototypeModel(program, instr, "__asmA_longcall");
            return;
        }
        if (mnemonic.equals("rts")) {
            this.setPrototypeModel(program, instr, "__asmA");
            return;
        }
    }

    private void setPrototypeModel(Program program, Instruction instr, String convention) {
        if (convention == null) {
            return;
        }
        Function func = program.getFunctionManager().getFunctionContaining(instr.getMinAddress());
        if (func == null) {
            return;
        }
        if (func.getSignatureSource() != SourceType.DEFAULT) {
            return;
        }
        try {
            func.setCallingConvention(convention);
        }
        catch (InvalidInputException e) {
            Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }

    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        FunctionIterator functions = program.getFunctionManager().getFunctions(set, true);
        for (Function function : functions) {
            AddressSetView body = function.getBody();
            InstructionIterator instructions = program.getListing().getInstructions(body, true);
            for (Instruction instr : instructions) {
                if (!instr.getFlowType().isTerminal()) continue;
                this.checkReturn(program, instr);
            }
        }
        return true;
    }
}

