/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.util;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.MappedTableColumn;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.table.MappedProgramLocationTableColumn;
import ghidra.util.table.ProgramLocationTableRowMapper;
import ghidra.util.table.field.ProgramLocationTableColumn;

public class VTMarkupItemSourceAddressToAddressTableRowMapper
extends ProgramLocationTableRowMapper<VTMarkupItem, Address> {
    public <COLUMN_TYPE> DynamicTableColumn<VTMarkupItem, COLUMN_TYPE, Program> createMappedTableColumn(DynamicTableColumn<Address, COLUMN_TYPE, Program> SourceColumn) {
        if (SourceColumn instanceof ProgramLocationTableColumn) {
            ProgramLocationTableColumn programColumn = (ProgramLocationTableColumn)SourceColumn;
            return new VTMarkupItemSourceWrappedMappedProgramLocationTableColumn(this, this, programColumn);
        }
        return new VTMarkupItemSourceWrappedMappedTableColumn<COLUMN_TYPE>(this, this, SourceColumn);
    }

    public Address map(VTMarkupItem rowObject, Program program, ServiceProvider serviceProvider) {
        return rowObject.getSourceAddress();
    }

    private class VTMarkupItemSourceWrappedMappedProgramLocationTableColumn<COLUMN_TYPE>
    extends MappedProgramLocationTableColumn<VTMarkupItem, Address, COLUMN_TYPE> {
        public VTMarkupItemSourceWrappedMappedProgramLocationTableColumn(VTMarkupItemSourceAddressToAddressTableRowMapper vTMarkupItemSourceAddressToAddressTableRowMapper, ProgramLocationTableRowMapper<VTMarkupItem, Address> mapper, ProgramLocationTableColumn<Address, COLUMN_TYPE> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's Source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }

    private class VTMarkupItemSourceWrappedMappedTableColumn<COLUMN_TYPE>
    extends MappedTableColumn<VTMarkupItem, Address, COLUMN_TYPE, Program> {
        public VTMarkupItemSourceWrappedMappedTableColumn(VTMarkupItemSourceAddressToAddressTableRowMapper vTMarkupItemSourceAddressToAddressTableRowMapper, ProgramLocationTableRowMapper<VTMarkupItem, Address> mapper, DynamicTableColumn<Address, COLUMN_TYPE, Program> tableColumn) {
            super(mapper, tableColumn, "VTMarkupItemSource." + tableColumn.getUniqueIdentifier());
        }

        public String getColumnDisplayName(Settings settings) {
            return "Source " + super.getColumnDisplayName(settings);
        }

        public String getColumnDescription() {
            return super.getColumnName() + " (for a markup items's Source address)";
        }

        public String getColumnName() {
            return "Source " + super.getColumnName();
        }
    }
}

