/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.Disposable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;

class MapTablePanel<K, V>
extends JPanel
implements Disposable {
    private String name;
    private Map<K, V> map;
    private String keyColumnName;
    private String valueColumnName;
    private int keyColumnWidth;
    private boolean showValueColumn;
    private Plugin plugin;
    private GFilterTable<Map.Entry<K, V>> table;

    MapTablePanel(String name, Map<K, V> map, String keyColumnName, String valueName, int keyColumnWidth, boolean showValueColumn, Plugin plugin) {
        this.name = name;
        this.map = map;
        this.keyColumnName = keyColumnName;
        this.valueColumnName = valueName;
        this.keyColumnWidth = keyColumnWidth;
        this.showValueColumn = showValueColumn;
        this.plugin = plugin;
        this.table = new GFilterTable((RowObjectTableModel)new MapModel());
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "Center");
    }

    public void dispose() {
        this.table.dispose();
    }

    private class MapModel
    extends GDynamicColumnTableModel<Map.Entry<K, V>, List<Map.Entry<K, V>>> {
        private List<Map.Entry<K, V>> entries;

        public MapModel() {
            super((ServiceProvider)MapTablePanel.this.plugin.getTool());
            this.entries = new ArrayList(MapTablePanel.this.map.entrySet());
        }

        public String getName() {
            return MapTablePanel.this.name;
        }

        public List<Map.Entry<K, V>> getModelData() {
            return this.entries;
        }

        protected TableColumnDescriptor<Map.Entry<K, V>> createTableColumnDescriptor() {
            TableColumnDescriptor columnDescriptor = new TableColumnDescriptor();
            columnDescriptor.addVisibleColumn((DynamicTableColumn)new KeyColumn());
            if (MapTablePanel.this.showValueColumn) {
                columnDescriptor.addVisibleColumn((DynamicTableColumn)new ValueColumn());
            } else {
                columnDescriptor.addHiddenColumn((DynamicTableColumn)new ValueColumn());
            }
            return columnDescriptor;
        }

        public List<Map.Entry<K, V>> getDataSource() {
            return this.entries;
        }

        private class KeyColumn
        extends AbstractDynamicTableColumn<Map.Entry<K, V>, K, List<Map.Entry<K, V>>> {
            private KeyColumn() {
            }

            public String getColumnName() {
                return MapTablePanel.this.keyColumnName;
            }

            public K getValue(Map.Entry<K, V> entry, Settings settings, List<Map.Entry<K, V>> data, ServiceProvider services) throws IllegalArgumentException {
                return entry.getKey();
            }

            public int getColumnPreferredWidth() {
                return MapTablePanel.this.keyColumnWidth;
            }
        }

        private class ValueColumn
        extends AbstractDynamicTableColumn<Map.Entry<K, V>, V, List<Map.Entry<K, V>>> {
            private ValueColumn() {
            }

            public String getColumnName() {
                return MapTablePanel.this.valueColumnName;
            }

            public V getValue(Map.Entry<K, V> entry, Settings settings, List<Map.Entry<K, V>> data, ServiceProvider services) throws IllegalArgumentException {
                return entry.getValue();
            }
        }
    }
}

