/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.ContextField;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.SymbolTable;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.pcode.utils.SlaFormat;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;

public class ContextSymbol
extends ValueSymbol {
    private VarnodeSymbol vn;
    private int low;
    private int high;
    private boolean flow = true;

    public VarnodeSymbol getVarnode() {
        return this.vn;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public int getInternalLow() {
        return ((ContextField)this.patval).getStartBit();
    }

    public int getInternalHigh() {
        return ((ContextField)this.patval).getEndBit();
    }

    public boolean followsFlow() {
        return this.flow;
    }

    @Override
    public void decode(Decoder decoder, SleighLanguage sleigh) throws DecoderException {
        this.flow = false;
        int id = (int)decoder.readUnsignedInteger(SlaFormat.ATTRIB_VARNODE);
        SymbolTable symtab = sleigh.getSymbolTable();
        this.vn = (VarnodeSymbol)symtab.findSymbol(id);
        int attrib = decoder.getNextAttributeId();
        boolean lowMissing = true;
        boolean highMissing = true;
        while (attrib != 0) {
            if (attrib == SlaFormat.ATTRIB_LOW.id()) {
                this.low = (int)decoder.readSignedInteger();
                lowMissing = false;
            } else if (attrib == SlaFormat.ATTRIB_HIGH.id()) {
                this.high = (int)decoder.readSignedInteger();
                highMissing = false;
            } else if (attrib == SlaFormat.ATTRIB_FLOW.id()) {
                this.flow = decoder.readBool();
            }
            attrib = decoder.getNextAttributeId();
        }
        if (lowMissing || highMissing) {
            throw new DecoderException("Missing high/low attributes");
        }
        this.patval = (PatternValue)PatternExpression.decodeExpression(decoder, sleigh);
        decoder.closeElement(SlaFormat.ELEM_CONTEXT_SYM.id());
    }
}

