/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import java.io.IOException;
import java.io.Reader;

public class BoundedBufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit = 0;
    private boolean skipLF = false;
    private boolean markedSkipLF = false;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BoundedBufferedReader(Reader in, int sz) {
        super((Object)in);
        if (sz <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = in;
        this.cb = new char[sz];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BoundedBufferedReader(Reader in) {
        this(in, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int dst;
        if (this.markedChar <= -1) {
            dst = 0;
        } else {
            int delta = this.nextChar - this.markedChar;
            if (delta >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                dst = 0;
            } else {
                if (this.readAheadLimit <= this.cb.length) {
                    System.arraycopy(this.cb, this.markedChar, this.cb, 0, delta);
                    this.markedChar = 0;
                    dst = delta;
                } else {
                    char[] ncb = new char[this.readAheadLimit];
                    System.arraycopy(this.cb, this.markedChar, ncb, 0, delta);
                    this.cb = ncb;
                    this.markedChar = 0;
                    dst = delta;
                }
                this.nextChar = this.nChars = delta;
            }
        }
        while ((n = this.in.read(this.cb, dst, this.cb.length - dst)) == 0) {
        }
        if (n > 0) {
            this.nChars = dst + n;
            this.nextChar = dst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            while (true) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                    if (this.nextChar >= this.nChars) {
                        return -1;
                    }
                }
                if (!this.skipLF) break;
                this.skipLF = false;
                if (this.cb[this.nextChar] != '\n') break;
                ++this.nextChar;
            }
            return this.cb[this.nextChar++];
        }
    }

    private int read1(char[] cbuf, int off, int len) throws IOException {
        if (this.nextChar >= this.nChars) {
            if (len >= this.cb.length && this.markedChar <= -1 && !this.skipLF) {
                return this.in.read(cbuf, off, len);
            }
            this.fill();
        }
        if (this.nextChar >= this.nChars) {
            return -1;
        }
        if (this.skipLF) {
            this.skipLF = false;
            if (this.cb[this.nextChar] == '\n') {
                ++this.nextChar;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    return -1;
                }
            }
        }
        int n = Math.min(len, this.nChars - this.nextChar);
        System.arraycopy(this.cb, this.nextChar, cbuf, off, n);
        this.nextChar += n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int n1;
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int n = this.read1(cbuf, off, len);
            if (n <= 0) {
                return n;
            }
            while (n < len && this.in.ready() && (n1 = this.read1(cbuf, off + n, len - n)) > 0) {
                n += n1;
            }
            return n;
        }
    }

    String readLine(boolean ignoreLF) throws IOException {
        StringBuffer s = null;
        Object object = this.lock;
        synchronized (object) {
            boolean omitLF;
            this.ensureOpen();
            boolean bl = omitLF = ignoreLF || this.skipLF;
            do {
                int i;
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (s != null && s.length() > 0) {
                        return s.toString();
                    }
                    return null;
                }
                boolean eol = false;
                char c = '\u0000';
                if (!omitLF || this.cb[this.nextChar] == '\n') {
                    // empty if block
                }
                this.skipLF = false;
                omitLF = false;
                for (i = ++this.nextChar; i < this.nChars; ++i) {
                    c = this.cb[i];
                    if (c != '\n' && c != '\r') continue;
                    eol = true;
                    break;
                }
                int startChar = this.nextChar;
                this.nextChar = i;
                if (eol) {
                    String str;
                    if (s == null) {
                        str = new String(this.cb, startChar, i - startChar);
                    } else {
                        s.append(this.cb, startChar, i - startChar);
                        str = s.toString();
                    }
                    ++this.nextChar;
                    if (c == '\r') {
                        this.skipLF = true;
                    }
                    return str;
                }
                if (s == null) {
                    s = new StringBuffer(defaultExpectedLineLength);
                }
                s.append(this.cb, startChar, i - startChar);
            } while (this.cb.length <= 4096);
            return "";
        }
    }

    public String readLine() throws IOException {
        return this.readLine(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            long r;
            long d;
            this.ensureOpen();
            for (r = n; r > 0L; r -= d) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                if (this.skipLF) {
                    this.skipLF = false;
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                }
                if (r <= (d = (long)(this.nChars - this.nextChar))) {
                    this.nextChar = (int)((long)this.nextChar + r);
                    r = 0L;
                    break;
                }
                this.nextChar = this.nChars;
            }
            return n - r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.skipLF) {
                if (this.nextChar >= this.nChars && this.in.ready()) {
                    this.fill();
                }
                if (this.nextChar < this.nChars) {
                    if (this.cb[this.nextChar] == '\n') {
                        ++this.nextChar;
                    }
                    this.skipLF = false;
                }
            }
            return this.nextChar < this.nChars || this.in.ready();
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            this.readAheadLimit = readAheadLimit;
            this.markedChar = this.nextChar;
            this.markedSkipLF = this.skipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
            this.skipLF = this.markedSkipLF;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
        }
    }
}

