/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import docking.widgets.table.DisplayStringProvider;
import ghidra.program.model.symbol.Symbol;

public class DisplayableLabel
implements DisplayStringProvider,
Comparable<DisplayableLabel> {
    protected final Symbol symbol;

    public DisplayableLabel(Symbol symbol) {
        this.symbol = symbol;
    }

    public Symbol getSymbol() {
        return this.symbol;
    }

    public String getDisplayString() {
        if (this.symbol == null) {
            return "<No Symbol>";
        }
        return this.symbol.getName();
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(DisplayableLabel otherDisplayableLabel) {
        if (otherDisplayableLabel == null) {
            return 1;
        }
        Symbol otherSymbol = otherDisplayableLabel.getSymbol();
        if (this.symbol == null) {
            return otherSymbol == null ? 0 : -1;
        }
        if (otherSymbol == null) {
            return 1;
        }
        return this.symbol.getName().compareToIgnoreCase(otherSymbol.getName());
    }
}

