/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.modules;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.target.iface.TraceObjectInterface;
import ghidra.trace.model.target.info.TraceObjectInfo;
import ghidra.util.exception.DuplicateNameException;

@TraceObjectInfo(schemaName="Section", shortName="section", attributes={"_module", "_range"}, fixedKeys={"_display", "_range"})
public interface TraceSection
extends TraceUniqueObject,
TraceObjectInterface {
    public static final String KEY_MODULE = "_module";
    public static final String KEY_RANGE = "_range";

    public Trace getTrace();

    public TraceModule getModule();

    public String getPath();

    public void setName(Lifespan var1, String var2);

    public void setName(long var1, String var3) throws DuplicateNameException;

    public String getName(long var1);

    public void setRange(Lifespan var1, AddressRange var2);

    public AddressRange getRange(long var1);

    default public Address getStart(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMinAddress();
    }

    default public Address getEnd(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMaxAddress();
    }

    public void delete();

    public void remove(long var1);

    public boolean isValid(long var1);
}

