/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.DialogComponentProvider;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.OptionDialog;
import generic.theme.GIcon;
import ghidra.framework.client.ClientUtil;
import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatable.ProjectTreeAction;
import ghidra.framework.main.datatree.FindCheckoutsDialog;
import ghidra.framework.main.datatree.FrontEndProjectTreeContext;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.LinkFileInfo;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.Plugin;
import ghidra.util.HelpLocation;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;

public class FindCheckoutsAction
extends ProjectTreeAction {
    private static final Icon FIND_ICON = new GIcon("icon.projectdata.find.checkouts.search");
    private Plugin plugin;

    public FindCheckoutsAction(String owner, Plugin plugin) {
        super("Find Checkouts", owner);
        this.plugin = plugin;
        String group = "Repository";
        this.setToolBarData(new ToolBarData(FIND_ICON, group));
        this.setPopupMenuData(new MenuData(new String[]{"Find Checkouts..."}, FIND_ICON, "Repository"));
        this.setDescription("Find my checkouts recursively");
        this.setHelpLocation(new HelpLocation("VersionControl", "Find_Checkouts"));
        this.setEnabled(false);
    }

    @Override
    protected void actionPerformed(FrontEndProjectTreeContext context) {
        DomainFile domainFile;
        LinkFileInfo linkInfo;
        DomainFolder domainFolder = null;
        if (context.getFolderCount() == 1) {
            domainFolder = context.getSelectedFolders().get(0);
        } else if (context.getFileCount() == 1 && (linkInfo = (domainFile = context.getSelectedFiles().get(0)).getLinkInfo()) != null && linkInfo.isFolderLink() && !linkInfo.isExternalLink()) {
            domainFolder = linkInfo.getLinkedFolder();
        }
        if (domainFolder == null) {
            return;
        }
        ProjectData projectData = domainFolder.getProjectData();
        RepositoryAdapter repository = projectData.getRepository();
        if (repository != null && !repository.isConnected()) {
            if (1 != OptionDialog.showOptionDialogWithCancelAsDefaultButton(null, (String)"Find Checkouts...", (String)"Action requires connection to repository.\nWould you like to connect now?", (String)"Connect", (int)3)) {
                return;
            }
            try {
                repository.connect();
            }
            catch (NotConnectedException e) {
                return;
            }
            catch (IOException e) {
                ClientUtil.handleException((RepositoryAdapter)repository, (Exception)e, (String)"Find Checkouts", null);
                return;
            }
        }
        this.findCheckouts(domainFolder, (Component)((Object)context.getTree()));
    }

    @Override
    protected boolean isEnabledForContext(FrontEndProjectTreeContext context) {
        if (context.isReadOnlyProject() || !context.hasExactlyOneFileOrFolder()) {
            return false;
        }
        if (context.getFolderCount() == 1) {
            return true;
        }
        DomainFile file = context.getSelectedFiles().get(0);
        LinkFileInfo linkInfo = file.getLinkInfo();
        return linkInfo != null && linkInfo.isFolderLink() && !linkInfo.isExternalLink();
    }

    private void findCheckouts(DomainFolder folder, Component comp) {
        FindCheckoutsDialog dialog = new FindCheckoutsDialog(this.plugin, folder);
        this.plugin.getTool().showDialog((DialogComponentProvider)dialog, comp);
    }
}

