/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.FunctionTypeKindSubstitutor;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeKindServiceKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u001a \u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u000b\u001a\u00020\f*\u00020\u00012\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"prepareCapturedType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "argumentType", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "getExpectedType", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "captureFromTypeParameterUpperBoundIfNeeded", "expectedType", "hasSupertypeWithGivenClassId", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "context", "Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "resolve"})
@SourceDebugExtension(value={"SMAP\nArgumentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentUtils.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n669#2,11:112\n*S KotlinDebug\n*F\n+ 1 ArgumentUtils.kt\norg/jetbrains/kotlin/fir/resolve/calls/ArgumentUtilsKt\n*L\n93#1:112,11\n*E\n"})
public final class ArgumentUtilsKt {
    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull ConeKotlinType argumentType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(session, "session");
        if (org.jetbrains.kotlin.fir.types.TypeUtilsKt.isRaw(argumentType)) {
            return argumentType;
        }
        ConeKotlinType coneKotlinType = (ConeKotlinType)TypeComponentsKt.getTypeContext(session).captureFromExpression(TypeExpansionUtilsKt.fullyExpandedType$default(argumentType, session, null, 2, null));
        if (coneKotlinType == null) {
            coneKotlinType = argumentType;
        }
        return coneKotlinType;
    }

    @NotNull
    public static final ConeKotlinType getExpectedType(@NotNull FirExpression $this$getExpectedType, @NotNull FirSession session, @NotNull FirValueParameter parameter) {
        ConeKotlinType expectedType;
        Intrinsics.checkNotNullParameter($this$getExpectedType, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        FirExpression firExpression = $this$getExpectedType;
        boolean shouldUnwrapVarargType = firExpression instanceof FirSpreadArgumentExpression || firExpression instanceof FirNamedArgumentExpression ? false : parameter.isVararg();
        ConeKotlinType coneKotlinType = expectedType = shouldUnwrapVarargType ? ArrayUtilsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
        if (!FirFunctionTypeKindServiceKt.getFunctionTypeService(session).hasExtensionKinds()) {
            return expectedType;
        }
        return new FunctionTypeKindSubstitutor(session).substituteOrSelf(expectedType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Object v2;
        ConeInferenceContext context2;
        block8: {
            void $this$singleOrNull$iv;
            Intrinsics.checkNotNullParameter(argumentType, "argumentType");
            Intrinsics.checkNotNullParameter(expectedType, "expectedType");
            Intrinsics.checkNotNullParameter(session, "session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypeUtilsKt.upperBoundIfFlexible(expectedType));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeRigidType coneRigidType = ConeTypeUtilsKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType = coneRigidType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneRigidType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            context2 = TypeComponentsKt.getTypeContext(session);
            Iterable iterable = TypeUtilsKt.collectUpperBounds(simplifiedArgumentType);
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeClassLikeType it = (ConeClassLikeType)element$iv;
                boolean bl = false;
                if (!ArgumentUtilsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v2 = null;
                    break block8;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        ConeClassLikeType coneClassLikeType = v2;
        if (coneClassLikeType == null) {
            return argumentType;
        }
        ConeClassLikeType chosenSupertype = coneClassLikeType;
        ConeKotlinType coneKotlinType2 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType2 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType2;
        if (argumentType instanceof ConeDefinitelyNotNullType) {
            ConeDefinitelyNotNullType coneDefinitelyNotNullType = org.jetbrains.kotlin.fir.types.TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, TypeComponentsKt.getTypeContext(session), false, 4, null);
            coneKotlinType = coneDefinitelyNotNullType != null ? (ConeKotlinType)coneDefinitelyNotNullType : capturedType;
        } else {
            coneKotlinType = capturedType;
        }
        return coneKotlinType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context2) {
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u242 = context2;
        boolean bl = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u242.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, arg_0 -> ArgumentUtilsKt.hasSupertypeWithGivenClassId$lambda$2$lambda$1($this$hasSupertypeWithGivenClassId_u24lambda_u242, classId, arg_0));
    }

    private static final boolean hasSupertypeWithGivenClassId$lambda$2$lambda$1(TypeSystemCommonSuperTypesContext $this_with, ClassId $classId, RigidTypeMarker it) {
        Intrinsics.checkNotNullParameter(it, "it");
        TypeConstructorMarker typeConstructor2 = $this_with.typeConstructor(it);
        return typeConstructor2 instanceof ConeClassLikeLookupTag && Intrinsics.areEqual(((ConeClassLikeLookupTag)typeConstructor2).getClassId(), $classId);
    }
}

