/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.data;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.base.util.InlineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.base.util.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.base.util.evaluate.DefaultExecutionContext;
import org.jetbrains.kotlin.idea.debugger.core.DebuggerUtil;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.ContinuationVariableValueDescriptorImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItemsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.DefaultCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.ContinuationHolderKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.FieldVariable;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010\u0082\u0001\u0003\u001c\u001d\u001e\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "location", "Lcom/sun/jdi/Location;", "spilledVariables", "", "Lcom/intellij/debugger/engine/JavaValue;", "<init>", "(Lcom/sun/jdi/Location;Ljava/util/List;)V", "getLocation", "()Lcom/sun/jdi/Location;", "getSpilledVariables", "()Ljava/util/List;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "createFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "uniqueId", "", "Companion", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CreationCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/DefaultCoroutineStackFrameItem;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "kotlin.jvm-debugger.coroutines"})
public abstract class CoroutineStackFrameItem
extends StackFrameItem {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Location location;
    @NotNull
    private final List<JavaValue> spilledVariables;
    @NotNull
    private final ReadOnlyProperty log$delegate;

    private CoroutineStackFrameItem(Location location, List<? extends JavaValue> spilledVariables) {
        super(location, spilledVariables);
        this.location = location;
        this.spilledVariables = spilledVariables;
        this.log$delegate = ProvidersKt.getLogger();
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    @NotNull
    public final List<JavaValue> getSpilledVariables() {
        return this.spilledVariables;
    }

    @NotNull
    public final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public XStackFrame createFrame(@NotNull DebugProcessImpl debugProcess, @Nullable SourcePosition sourcePosition) {
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        DebuggerManagerThreadImpl.Companion.assertIsManagerThread();
        StackFrameProxyImpl stackFrameProxyImpl = CoroutineStackFrameItemsKt.findFirstFrame(debugProcess);
        if (stackFrameProxyImpl == null) {
            return null;
        }
        StackFrameProxyImpl frame = stackFrameProxyImpl;
        XSourcePosition position = CoroutineUtilsKt.toXSourcePosition(sourcePosition);
        return (XStackFrame)new CoroutineStackFrame(frame, position, this.spilledVariables, false, this.location);
    }

    @NotNull
    public final String uniqueId() {
        return SafeUtilKt.safeSourceName(this.location) + ":" + SafeUtilKt.safeMethod(this.location) + ":" + SafeUtilKt.safeLineNumber(this.location) + ":" + SafeUtilKt.safeKotlinPreferredLineNumber(this.location);
    }

    public /* synthetic */ CoroutineStackFrameItem(Location location, List spilledVariables, DefaultConstructorMarker $constructor_marker) {
        this(location, spilledVariables);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CoroutineStackFrameItem.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t*\b\u0012\u0004\u0012\u00020\n0\tH\u0002J\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "stackTraceElement", "Ljava/lang/StackTraceElement;", "fieldVariables", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/mirror/FieldVariable;", "continuation", "Lcom/sun/jdi/ObjectReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/base/util/evaluate/DefaultExecutionContext;", "filterOutSyntheticLocalVariables", "toJavaValue", "Lcom/intellij/debugger/engine/JavaValue;", "kotlin.jvm-debugger.coroutines"})
    @SourceDebugExtension(value={"SMAP\ncoroutineStackFrameItems.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineStackFrameItems.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1563#2:134\n1634#2,3:135\n827#2:138\n855#2,2:139\n*S KotlinDebug\n*F\n+ 1 coroutineStackFrameItems.kt\norg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem$Companion\n*L\n105#1:134\n105#1:135,3\n110#1:138\n110#1:139,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final CoroutineStackFrameItem create(@Nullable StackTraceElement stackTraceElement, @NotNull List<FieldVariable> fieldVariables, @NotNull ObjectReference continuation2, @NotNull DefaultExecutionContext context) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(fieldVariables, (String)"fieldVariables");
            Intrinsics.checkNotNullParameter((Object)continuation2, (String)"continuation");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (stackTraceElement == null) {
                return null;
            }
            Location generatedLocation = ContinuationHolderKt.findOrCreateLocation(context, stackTraceElement);
            Iterable $this$map$iv = this.filterOutSyntheticLocalVariables(fieldVariables);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FieldVariable fieldVariable = (FieldVariable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.toJavaValue((FieldVariable)it, continuation2, context));
            }
            List spilledVariables = (List)destination$iv$iv;
            return new DefaultCoroutineStackFrameItem(generatedLocation, spilledVariables);
        }

        /*
         * WARNING - void declaration
         */
        private final List<FieldVariable> filterOutSyntheticLocalVariables(List<FieldVariable> $this$filterOutSyntheticLocalVariables) {
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv = $this$filterOutSyntheticLocalVariables;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                FieldVariable it = (FieldVariable)element$iv$iv;
                boolean bl = false;
                if (DebuggerUtil.isInlineFunctionMarkerVariableName(it.getVariableName()) || DebuggerUtil.isInlineLambdaMarkerVariableName(it.getVariableName())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final JavaValue toJavaValue(FieldVariable $this$toJavaValue, ObjectReference continuation2, DefaultExecutionContext context) {
            ContinuationVariableValueDescriptorImpl valueDescriptor = new ContinuationVariableValueDescriptorImpl(context, continuation2, $this$toJavaValue.getFieldName(), InlineUtilsKt.dropInlineSuffix($this$toJavaValue.getVariableName()));
            ValueDescriptorImpl valueDescriptorImpl = valueDescriptor;
            EvaluationContextImpl evaluationContextImpl = context.getEvaluationContext();
            JavaDebugProcess javaDebugProcess = context.getDebugProcess().getXdebugProcess();
            Intrinsics.checkNotNull((Object)javaDebugProcess);
            JavaValue javaValue = JavaValue.create(null, (ValueDescriptorImpl)valueDescriptorImpl, (EvaluationContextImpl)evaluationContextImpl, (NodeManagerImpl)javaDebugProcess.getNodeManager(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)javaValue, (String)"create(...)");
            return javaValue;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

