/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.console;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleViewPlace;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.editor.actions.ToggleUseSoftWrapsToolbarAction;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.vcs.console.VcsConsoleFolding;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/console/VcsConsoleView;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getPlace", "Lcom/intellij/execution/ui/ConsoleViewPlace;", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "updateFoldings", "", "startLine", "", "endLine", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsConsoleView.kt\ncom/intellij/vcs/console/VcsConsoleView\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,70:1\n13#2:71\n*S KotlinDebug\n*F\n+ 1 VcsConsoleView.kt\ncom/intellij/vcs/console/VcsConsoleView\n*L\n20#1:71\n*E\n"})
public final class VcsConsoleView
extends ConsoleViewImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    @JvmField
    @NotNull
    public static final ConsoleViewPlace CONSOLE_PLACE;

    public VcsConsoleView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
    }

    @NotNull
    public ConsoleViewPlace getPlace() {
        return CONSOLE_PLACE;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        ToggleUseSoftWrapsToolbarAction switchSoftWrapsAction = new ToggleUseSoftWrapsToolbarAction(SoftWrapAppliancePlaces.CONSOLE);
        ScrollToTheEndToolbarAction scrollToTheEndToolbarAction = new ScrollToTheEndToolbarAction(this.getEditor());
        AnAction[] anActionArray = new AnAction[]{switchSoftWrapsAction, scrollToTheEndToolbarAction, this.clearThisConsoleAction()};
        return anActionArray;
    }

    protected void updateFoldings(int startLine, int endLine) {
        super.updateFoldings(startLine, endLine);
        Editor editor = this.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        editor.getFoldingModel().runBatchFoldingOperation(() -> VcsConsoleView.updateFoldings$lambda$0(this, startLine, endLine));
    }

    private static final void updateFoldings$lambda$0(VcsConsoleView this$0, int $startLine, int $endLine) {
        Editor editor = this$0.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int line = $startLine;
        if (line <= $endLine) {
            while (true) {
                int oStart = document2.getLineStartOffset(line);
                int oEnd = document2.getLineEndOffset(line);
                Intrinsics.checkNotNullExpressionValue((Object)EditorHyperlinkSupport.getLineText((Document)document2, (int)line, (boolean)false), (String)"getLineText(...)");
                for (VcsConsoleFolding provider : (VcsConsoleFolding[])VcsConsoleFolding.EP_NAME.getExtensions()) {
                    String lineText;
                    for (VcsConsoleFolding.Placeholder folding : provider.getFoldingsForLine(this$0.getProject(), lineText)) {
                        FoldRegion region;
                        TextRange foldingRange;
                        Intrinsics.checkNotNullExpressionValue((Object)folding.getTextRange().shiftRight(oStart), (String)"shiftRight(...)");
                        if (foldingRange.getEndOffset() > oEnd) {
                            LOG.error("Folding exceeds line length: " + folding + ", provider: " + provider);
                            continue;
                        }
                        Editor editor2 = this$0.getEditor();
                        Intrinsics.checkNotNull((Object)editor2);
                        FoldRegion foldRegion = region = editor2.getFoldingModel().addFoldRegion(foldingRange.getStartOffset(), foldingRange.getEndOffset(), folding.getPlaceholder());
                        if (foldRegion == null) continue;
                        foldRegion.setExpanded(false);
                    }
                }
                if (line == $endLine) break;
                ++line;
            }
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VcsConsoleView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        CONSOLE_PLACE = new ConsoleViewPlace("VCS Console");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/vcs/console/VcsConsoleView$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "CONSOLE_PLACE", "Lcom/intellij/execution/ui/ConsoleViewPlace;", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

