/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.ArrayReferenceImpl;
import com.jetbrains.sa.jdi.ArrayTypeImpl;
import com.jetbrains.sa.jdi.BooleanValueImpl;
import com.jetbrains.sa.jdi.ByteValueImpl;
import com.jetbrains.sa.jdi.CharValueImpl;
import com.jetbrains.sa.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.sa.jdi.ClassObjectReferenceImpl;
import com.jetbrains.sa.jdi.ClassTypeImpl;
import com.jetbrains.sa.jdi.CompatibilityHelper;
import com.jetbrains.sa.jdi.DoubleValueImpl;
import com.jetbrains.sa.jdi.FloatValueImpl;
import com.jetbrains.sa.jdi.IntegerValueImpl;
import com.jetbrains.sa.jdi.InterfaceTypeImpl;
import com.jetbrains.sa.jdi.LongValueImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.PrimitiveTypeImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.ShortValueImpl;
import com.jetbrains.sa.jdi.StringReferenceImpl;
import com.jetbrains.sa.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.sa.jdi.ThreadReferenceImpl;
import com.jetbrains.sa.jdi.VoidValueImpl;
import com.sun.jdi.VirtualMachineManager;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import sun.jvm.hotspot.HotSpotAgent;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.memory.Universe;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.DefaultHeapVisitor;
import sun.jvm.hotspot.oops.HeapVisitor;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjArray;
import sun.jvm.hotspot.oops.ObjArrayKlass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.oops.TypeArray;
import sun.jvm.hotspot.oops.TypeArrayKlass;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.utilities.Assert;

public class VirtualMachineImpl {
    private final HotSpotAgent saAgent = new HotSpotAgent();
    private VM saVM;
    private Universe saUniverse;
    private SystemDictionary saSystemDictionary;
    private ObjectHeap saObjectHeap;
    VirtualMachineManager vmmgr;
    private final PrimitiveTypeImpl theBooleanType = new PrimitiveTypeImpl(90);
    private final PrimitiveTypeImpl theByteType = new PrimitiveTypeImpl(66);
    private final PrimitiveTypeImpl theCharType = new PrimitiveTypeImpl(67);
    private final PrimitiveTypeImpl theShortType = new PrimitiveTypeImpl(83);
    private final PrimitiveTypeImpl theIntegerType = new PrimitiveTypeImpl(73);
    private final PrimitiveTypeImpl theLongType = new PrimitiveTypeImpl(74);
    private final PrimitiveTypeImpl theFloatType = new PrimitiveTypeImpl(70);
    private final PrimitiveTypeImpl theDoubleType = new PrimitiveTypeImpl(68);
    final VoidValueImpl voidVal = new VoidValueImpl();
    private final Map<Long, ReferenceTypeImpl> typesById = new HashMap<Long, ReferenceTypeImpl>();
    private boolean retrievedAllTypes = false;
    private List<ReferenceTypeImpl> bootstrapClasses;
    private ArrayList<ThreadReferenceImpl> allThreads;
    private ArrayList<ThreadGroupReferenceImpl> topLevelGroups;
    final int sequenceNumber;
    private final Map<Long, SoftObjectReference> objectsByID = new HashMap<Long, SoftObjectReference>();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final String javaLangString = "java/lang/String";
    private final String javaLangThread = "java/lang/Thread";
    private final String javaLangThreadGroup = "java/lang/ThreadGroup";
    private final String javaLangClass = "java/lang/Class";
    private final String javaLangClassLoader = "java/lang/ClassLoader";
    final String javaLangThrowable = "java/lang/Throwable";
    final String javaLangObject = "java/lang/Object";
    final String javaLangCloneable = "java/lang/Cloneable";
    final String javaIoSerializable = "java/io/Serializable";

    VM saVM() {
        return this.saVM;
    }

    SystemDictionary saSystemDictionary() {
        return this.saSystemDictionary;
    }

    Universe saUniverse() {
        return this.saUniverse;
    }

    ObjectHeap saObjectHeap() {
        return this.saObjectHeap;
    }

    private void init() {
        this.saVM = VM.getVM();
        this.saUniverse = this.saVM.getUniverse();
        this.saSystemDictionary = this.saVM.getSystemDictionary();
        this.saObjectHeap = this.saVM.getObjectHeap();
    }

    public static VirtualMachineImpl createVirtualMachineForCorefile(VirtualMachineManager mgr, String javaExecutableName, String coreFileName, int sequenceNumber) throws Exception {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((coreFileName != null ? 1 : 0) != 0, (String)"SA VirtualMachineImpl: core filename = null is not yet implemented");
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((javaExecutableName != null ? 1 : 0) != 0, (String)"SA VirtualMachineImpl: java executable = null is not yet implemented");
        }
        VirtualMachineImpl myvm = new VirtualMachineImpl(mgr, sequenceNumber);
        try {
            myvm.saAgent.attach(javaExecutableName, coreFileName);
            myvm.init();
        }
        catch (Exception ee) {
            myvm.saAgent.detach();
            throw ee;
        }
        return myvm;
    }

    public static VirtualMachineImpl createVirtualMachineForPID(VirtualMachineManager mgr, int pid, int sequenceNumber) throws Exception {
        VirtualMachineImpl myvm = new VirtualMachineImpl(mgr, sequenceNumber);
        try {
            myvm.saAgent.attach(pid);
            myvm.init();
        }
        catch (Exception ee) {
            myvm.saAgent.detach();
            throw ee;
        }
        return myvm;
    }

    public static VirtualMachineImpl createVirtualMachineForServer(VirtualMachineManager mgr, String server, int sequenceNumber) throws Exception {
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((server != null ? 1 : 0) != 0, (String)"SA VirtualMachineImpl: DebugServer = null is not yet implemented");
        }
        VirtualMachineImpl myvm = new VirtualMachineImpl(mgr, sequenceNumber);
        try {
            myvm.saAgent.attach(server);
            myvm.init();
        }
        catch (Exception ee) {
            myvm.saAgent.detach();
            throw ee;
        }
        return myvm;
    }

    VirtualMachineImpl(VirtualMachineManager mgr, int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
        this.vmmgr = mgr;
        System.setProperty("sun.jvm.hotspot.debugger.useWindbgDebugger", "true");
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public List<ReferenceTypeImpl> allClasses() {
        if (!this.retrievedAllTypes) {
            for (Klass saKlass : CompatibilityHelper.INSTANCE.allClasses(this.saSystemDictionary, this.saVM)) {
                this.referenceType(saKlass);
            }
            this.retrievedAllTypes = true;
        }
        return Collections.unmodifiableList(new ArrayList<ReferenceTypeImpl>(this.typesById.values()));
    }

    List<ReferenceTypeImpl> bootstrapClasses() {
        if (this.bootstrapClasses == null) {
            this.bootstrapClasses = new ArrayList<ReferenceTypeImpl>();
            for (ReferenceTypeImpl type : this.allClasses()) {
                if (type.classLoader() != null) continue;
                this.bootstrapClasses.add(type);
            }
        }
        return this.bootstrapClasses;
    }

    public List<ReferenceTypeImpl> findReferenceTypes(String signature) {
        String typeName = signature.charAt(0) == 'L' ? signature.substring(1, signature.length() - 1) : signature;
        ArrayList<ReferenceTypeImpl> list = new ArrayList<ReferenceTypeImpl>(1);
        for (ReferenceTypeImpl type : this.allClasses()) {
            if (!type.name().equals(typeName)) continue;
            list.add(type);
        }
        return list;
    }

    ReferenceTypeImpl referenceType(Klass kk) {
        ReferenceTypeImpl retType = this.typesById.get(ReferenceTypeImpl.uniqueID(kk, this));
        if (retType == null) {
            retType = this.addReferenceType(kk);
        }
        return retType;
    }

    private ReferenceTypeImpl addReferenceType(Klass kk) {
        ReferenceTypeImpl newRefType;
        if (kk instanceof ObjArrayKlass || kk instanceof TypeArrayKlass) {
            newRefType = new ArrayTypeImpl(this, (ArrayKlass)kk);
        } else if (kk instanceof InstanceKlass) {
            newRefType = kk.isInterface() ? new InterfaceTypeImpl(this, (InstanceKlass)kk) : new ClassTypeImpl(this, (InstanceKlass)kk);
        } else {
            throw new RuntimeException("should not reach here:" + kk);
        }
        this.typesById.put(newRefType.uniqueID(), newRefType);
        return newRefType;
    }

    private List<ThreadReferenceImpl> getAllThreads() {
        if (this.allThreads == null) {
            this.allThreads = new ArrayList(10);
            for (JavaThread thread : CompatibilityHelper.INSTANCE.getThreads(this.saVM)) {
                if (thread.isHiddenFromExternalView()) continue;
                ThreadReferenceImpl myThread = this.threadMirror(thread);
                this.allThreads.add(myThread);
            }
        }
        return this.allThreads;
    }

    public List<ThreadReferenceImpl> allThreads() {
        return Collections.unmodifiableList(this.getAllThreads());
    }

    public List<ThreadGroupReferenceImpl> topLevelThreadGroups() {
        if (this.topLevelGroups == null) {
            this.topLevelGroups = new ArrayList(1);
            for (ThreadReferenceImpl threadReference : this.getAllThreads()) {
                ThreadGroupReferenceImpl myGroup = threadReference.threadGroup();
                if (myGroup.parent() != null) continue;
                this.topLevelGroups.add(myGroup);
                break;
            }
        }
        return Collections.unmodifiableList(this.topLevelGroups);
    }

    public BooleanValueImpl mirrorOf(boolean value) {
        return new BooleanValueImpl(value);
    }

    public ByteValueImpl mirrorOf(byte value) {
        return new ByteValueImpl(value);
    }

    public CharValueImpl mirrorOf(char value) {
        return new CharValueImpl(value);
    }

    public ShortValueImpl mirrorOf(short value) {
        return new ShortValueImpl(value);
    }

    public IntegerValueImpl mirrorOf(int value) {
        return new IntegerValueImpl(value);
    }

    public LongValueImpl mirrorOf(long value) {
        return new LongValueImpl(value);
    }

    public FloatValueImpl mirrorOf(float value) {
        return new FloatValueImpl(value);
    }

    public DoubleValueImpl mirrorOf(double value) {
        return new DoubleValueImpl(value);
    }

    public void dispose() {
        this.saAgent.detach();
    }

    public boolean canWatchFieldModification() {
        return false;
    }

    public boolean canWatchFieldAccess() {
        return false;
    }

    public boolean canGetBytecodes() {
        return true;
    }

    public boolean canGetSyntheticAttribute() {
        return true;
    }

    public boolean canGetOwnedMonitorInfo() {
        return false;
    }

    public boolean canGetCurrentContendedMonitor() {
        return false;
    }

    public boolean canGetMonitorInfo() {
        return false;
    }

    public boolean canUseInstanceFilters() {
        return false;
    }

    public boolean canRedefineClasses() {
        return false;
    }

    public boolean canAddMethod() {
        return false;
    }

    public boolean canUnrestrictedlyRedefineClasses() {
        return false;
    }

    public boolean canPopFrames() {
        return false;
    }

    public boolean canGetSourceDebugExtension() {
        return false;
    }

    public boolean canRequestVMDeathEvent() {
        return false;
    }

    public boolean canForceEarlyReturn() {
        return false;
    }

    public boolean canGetConstantPool() {
        return true;
    }

    public boolean canGetClassFileVersion() {
        return true;
    }

    public boolean canGetInstanceInfo() {
        return true;
    }

    public boolean canUseSourceNameFilters() {
        return false;
    }

    public boolean canRequestMonitorEvents() {
        return false;
    }

    public boolean canGetMonitorFrameInfo() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public long[] instanceCounts(List<? extends ReferenceTypeImpl> classes) {
        void var6_8;
        if (!this.canGetInstanceInfo()) {
            throw new UnsupportedOperationException("target does not support getting instances");
        }
        int size = classes.size();
        final HashMap<Address, Long> instanceMap = new HashMap<Address, Long>(size);
        boolean allAbstractClasses = true;
        for (ReferenceTypeImpl referenceTypeImpl : classes) {
            instanceMap.put(CompatibilityHelper.INSTANCE.getAddress(referenceTypeImpl.ref()), 0L);
            if (referenceTypeImpl.isAbstract() || referenceTypeImpl instanceof InterfaceTypeImpl) continue;
            allAbstractClasses = false;
        }
        if (allAbstractClasses) {
            return new long[size];
        }
        this.saObjectHeap.iterate((HeapVisitor)new DefaultHeapVisitor(){

            public boolean doObj(Oop oop) {
                Address klassAddress = CompatibilityHelper.INSTANCE.getKlassAddress(oop);
                Long current = (Long)instanceMap.get(klassAddress);
                if (current != null) {
                    instanceMap.put(klassAddress, current + 1L);
                }
                return false;
            }
        });
        long[] retValue = new long[size];
        boolean bl = false;
        while (var6_8 < retValue.length) {
            retValue[var6_8] = (Long)instanceMap.get(CompatibilityHelper.INSTANCE.getAddress(classes.get((int)var6_8).ref()));
            ++var6_8;
        }
        return retValue;
    }

    private List<String> getPath(String pathName) {
        String cp = this.saVM.getSystemProperty(pathName);
        if (cp == null) {
            return Collections.emptyList();
        }
        String pathSep = this.saVM.getSystemProperty("path.separator");
        ArrayList<String> al = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(cp, pathSep);
        while (st.hasMoreTokens()) {
            al.add(st.nextToken());
        }
        al.trimToSize();
        return al;
    }

    public List<String> classPath() {
        return this.getPath("java.class.path");
    }

    public List<String> bootClassPath() {
        return this.getPath("sun.boot.class.path");
    }

    public String baseDirectory() {
        return this.saVM.getSystemProperty("user.dir");
    }

    public String description() {
        String version_format = "Java Debug Interface (Reference Implementation) version {0}.{1} \\n{2}";
        return MessageFormat.format(version_format, "" + this.vmmgr.majorInterfaceVersion(), "" + this.vmmgr.minorInterfaceVersion(), this.name());
    }

    public String version() {
        String version = this.saVM.getSystemProperty("java.version");
        return version != null ? version : this.saVM.getVMRelease();
    }

    public String name() {
        return "JVM version " + this.version() + " (" + this.saVM.getSystemProperty("java.vm.name") + ", " + this.saVM.getSystemProperty("java.vm.info") + ")";
    }

    public int jdwpMajor() {
        return this.vmmgr.majorInterfaceVersion();
    }

    public int jdwpMinor() {
        return this.vmmgr.minorInterfaceVersion();
    }

    public String toString() {
        return this.name();
    }

    PrimitiveTypeImpl primitiveTypeMirror(char tag) {
        switch (tag) {
            case 'Z': {
                return this.theBooleanType;
            }
            case 'B': {
                return this.theByteType;
            }
            case 'C': {
                return this.theCharType;
            }
            case 'S': {
                return this.theShortType;
            }
            case 'I': {
                return this.theIntegerType;
            }
            case 'J': {
                return this.theLongType;
            }
            case 'F': {
                return this.theFloatType;
            }
            case 'D': {
                return this.theDoubleType;
            }
        }
        throw new IllegalArgumentException("Unrecognized primitive tag " + tag);
    }

    private void processQueue() {
        Reference ref;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.removeObjectMirror((SoftObjectReference)ref);
        }
    }

    long getAddressValue(Address address) {
        return this.saVM.getDebugger().getAddressValue(address);
    }

    private ObjectReferenceImpl getCachedObjectMirror(long id) {
        this.processQueue();
        SoftObjectReference ref = this.objectsByID.get(id);
        return ref != null ? ref.object() : null;
    }

    private ObjectReferenceImpl createObjectMirror(long id, Oop key) {
        ObjectReferenceImpl object = null;
        Klass klass = key.getKlass();
        ReferenceTypeImpl type = this.referenceType(klass);
        if (key instanceof Instance) {
            Symbol classNameSymbol = klass.getName();
            if (Assert.ASSERTS_ENABLED) {
                Assert.that((classNameSymbol != null ? 1 : 0) != 0, (String)"Null class name");
            }
            String className = classNameSymbol.asString();
            Instance inst = (Instance)key;
            if (className.equals("java/lang/String")) {
                object = new StringReferenceImpl(type, inst);
            } else if (className.equals("java/lang/Thread")) {
                object = new ThreadReferenceImpl(type, inst);
            } else if (className.equals("java/lang/ThreadGroup")) {
                object = new ThreadGroupReferenceImpl(type, (Oop)inst);
            } else if (className.equals("java/lang/Class")) {
                object = new ClassObjectReferenceImpl(type, inst);
            } else if (className.equals("java/lang/ClassLoader")) {
                object = new ClassLoaderReferenceImpl(type, inst);
            } else {
                for (Klass kls = klass.getSuper(); kls != null; kls = kls.getSuper()) {
                    className = kls.getName().asString();
                    if (className.equals("java/lang/Thread")) {
                        object = new ThreadReferenceImpl(type, inst);
                        break;
                    }
                    if (className.equals("java/lang/ThreadGroup")) {
                        object = new ThreadGroupReferenceImpl(type, (Oop)inst);
                        break;
                    }
                    if (!className.equals("java/lang/ClassLoader")) continue;
                    object = new ClassLoaderReferenceImpl(type, inst);
                    break;
                }
                if (object == null) {
                    object = new ObjectReferenceImpl(type, (Oop)inst);
                }
            }
        } else if (key instanceof TypeArray || key instanceof ObjArray) {
            object = new ArrayReferenceImpl(type, (Array)key);
        } else {
            throw new RuntimeException("unexpected object type " + key);
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that((id == object.uniqueID() ? 1 : 0) != 0, (String)"Unique id does not match");
        }
        this.objectsByID.put(id, new SoftObjectReference(id, object, this.referenceQueue));
        return object;
    }

    public ObjectReferenceImpl objectMirror(long id) {
        ObjectReferenceImpl object = this.getCachedObjectMirror(id);
        if (object == null) {
            object = this.createObjectMirror(id, this.saObjectHeap.newOop(this.saVM.getDebugger().parseAddress("0x" + Long.toHexString(id)).addOffsetToAsOopHandle(0L)));
        }
        return object;
    }

    ObjectReferenceImpl objectMirror(OopHandle handle) {
        if (handle == null) {
            return null;
        }
        long id = ObjectReferenceImpl.uniqueID(handle, this);
        ObjectReferenceImpl object = this.getCachedObjectMirror(id);
        if (object == null) {
            object = this.createObjectMirror(id, this.saObjectHeap.newOop(handle));
        }
        return object;
    }

    ObjectReferenceImpl objectMirror(Oop key) {
        if (key == null) {
            return null;
        }
        long id = ObjectReferenceImpl.uniqueID(key.getHandle(), this);
        ObjectReferenceImpl object = this.getCachedObjectMirror(id);
        if (object == null) {
            object = this.createObjectMirror(id, key);
        }
        return object;
    }

    private void removeObjectMirror(SoftObjectReference ref) {
        this.objectsByID.remove(ref.key());
    }

    ThreadReferenceImpl threadMirror(JavaThread jt) {
        return (ThreadReferenceImpl)this.objectMirror(jt.getThreadObj());
    }

    ThreadGroupReferenceImpl threadGroupMirror(Instance id) {
        return (ThreadGroupReferenceImpl)this.objectMirror((Oop)id);
    }

    ClassLoaderReferenceImpl classLoaderMirror(Instance id) {
        return (ClassLoaderReferenceImpl)this.objectMirror((Oop)id);
    }

    ClassObjectReferenceImpl classObjectMirror(Instance id) {
        return (ClassObjectReferenceImpl)this.objectMirror((Oop)id);
    }

    public ThreadReferenceImpl getThreadById(long id) {
        for (ThreadReferenceImpl thread : this.allThreads()) {
            if (thread.uniqueID() != id) continue;
            return thread;
        }
        throw new IllegalStateException("Thread with id " + id + " not found");
    }

    public ReferenceTypeImpl getReferenceTypeById(long id) {
        ReferenceTypeImpl res = this.typesById.get(id);
        if (res == null) {
            throw new IllegalStateException("ReferenceType with id " + id + " not found");
        }
        return res;
    }

    public ThreadGroupReferenceImpl getThreadGroupReferenceById(long id) {
        for (ThreadReferenceImpl thread : this.allThreads()) {
            ThreadGroupReferenceImpl threadGroup = thread.threadGroup();
            if (threadGroup.uniqueID() != id) continue;
            return threadGroup;
        }
        throw new IllegalStateException("ThreadGroup with id " + id + " not found");
    }

    private static class SoftObjectReference
    extends SoftReference<ObjectReferenceImpl> {
        Long key;

        SoftObjectReference(Long key, ObjectReferenceImpl mirror, ReferenceQueue queue) {
            super(mirror, queue);
            this.key = key;
        }

        Long key() {
            return this.key;
        }

        ObjectReferenceImpl object() {
            return (ObjectReferenceImpl)this.get();
        }
    }
}

