/*
 * Decompiled with CFR 0.152.
 */
package coil3.disk;

import coil3.disk.RealDiskCache;
import coil3.util.FileSystems_jvmKt;
import coil3.util.FileSystems_nonJsCommonKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001:\u0003\u001b\u001c\u001dJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0012\u001a\u00020\u0013H&J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0019H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcoil3/disk/DiskCache;", "", "size", "", "getSize", "()J", "maxSize", "getMaxSize", "directory", "Lokio/Path;", "getDirectory", "()Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "getFileSystem", "()Lokio/FileSystem;", "openSnapshot", "Lcoil3/disk/DiskCache$Snapshot;", "key", "", "openEditor", "Lcoil3/disk/DiskCache$Editor;", "remove", "", "clear", "", "shutdown", "Snapshot", "Editor", "Builder", "coil-core"})
public interface DiskCache {
    public long getSize();

    public long getMaxSize();

    @NotNull
    public Path getDirectory();

    @NotNull
    public FileSystem getFileSystem();

    @Nullable
    public Snapshot openSnapshot(@NotNull String var1);

    @Nullable
    public Editor openEditor(@NotNull String var1);

    public boolean remove(@NotNull String var1);

    public void clear();

    public void shutdown();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u000fJ\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0006\u0010\u0016\u001a\u00020\u0017R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcoil3/disk/DiskCache$Builder;", "", "<init>", "()V", "directory", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "maxSizePercent", "", "minimumMaxSizeBytes", "", "maximumMaxSizeBytes", "maxSizeBytes", "cleanupCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "percent", "size", "context", "cleanupDispatcher", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "build", "Lcoil3/disk/DiskCache;", "coil-core"})
    @SourceDebugExtension(value={"SMAP\nDiskCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskCache.kt\ncoil3/disk/DiskCache$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
    public static final class Builder {
        @Nullable
        private Path directory;
        @NotNull
        private FileSystem fileSystem = FileSystems_nonJsCommonKt.defaultFileSystem();
        private double maxSizePercent = 0.02;
        private long minimumMaxSizeBytes = 0xA00000L;
        private long maximumMaxSizeBytes = 0xFA00000L;
        private long maxSizeBytes;
        @NotNull
        private CoroutineContext cleanupCoroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;

        @NotNull
        public final Builder directory(@NotNull Path directory) {
            Builder builder;
            Builder $this$directory_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$directory_u24lambda_u240.directory = directory;
            return builder;
        }

        @NotNull
        public final Builder fileSystem(@NotNull FileSystem fileSystem2) {
            Builder builder;
            Builder $this$fileSystem_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$fileSystem_u24lambda_u241.fileSystem = fileSystem2;
            return builder;
        }

        @NotNull
        public final Builder maxSizePercent(double percent) {
            Builder builder;
            Builder $this$maxSizePercent_u24lambda_u243 = builder = this;
            boolean bl = false;
            if (!(0.0 <= percent ? percent <= 1.0 : false)) {
                boolean bl2 = false;
                String string = "percent must be in the range [0.0, 1.0].";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizePercent_u24lambda_u243.maxSizeBytes = 0L;
            $this$maxSizePercent_u24lambda_u243.maxSizePercent = percent;
            return builder;
        }

        @NotNull
        public final Builder minimumMaxSizeBytes(long size2) {
            Builder builder;
            Builder $this$minimumMaxSizeBytes_u24lambda_u245 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$minimumMaxSizeBytes_u24lambda_u245.minimumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maximumMaxSizeBytes(long size2) {
            Builder builder;
            Builder $this$maximumMaxSizeBytes_u24lambda_u247 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maximumMaxSizeBytes_u24lambda_u247.maximumMaxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder maxSizeBytes(long size2) {
            Builder builder;
            Builder $this$maxSizeBytes_u24lambda_u249 = builder = this;
            boolean bl = false;
            if (!(size2 > 0L)) {
                boolean bl2 = false;
                String string = "size must be > 0.";
                throw new IllegalArgumentException(string.toString());
            }
            $this$maxSizeBytes_u24lambda_u249.maxSizePercent = 0.0;
            $this$maxSizeBytes_u24lambda_u249.maxSizeBytes = size2;
            return builder;
        }

        @NotNull
        public final Builder cleanupCoroutineContext(@NotNull CoroutineContext context) {
            Builder builder;
            Builder $this$cleanupCoroutineContext_u24lambda_u2410 = builder = this;
            boolean bl = false;
            $this$cleanupCoroutineContext_u24lambda_u2410.cleanupCoroutineContext = context;
            return builder;
        }

        @Deprecated(message="Replaced by cleanupCoroutineContext.", replaceWith=@ReplaceWith(expression="cleanupCoroutineContext(dispatcher)", imports={}))
        @NotNull
        public final Builder cleanupDispatcher(@NotNull CoroutineDispatcher dispatcher) {
            return this.cleanupCoroutineContext((CoroutineContext)dispatcher);
        }

        @NotNull
        public final DiskCache build() {
            long l;
            Path path = this.directory;
            if (path == null) {
                boolean bl = false;
                String string = "directory == null";
                throw new IllegalStateException(string.toString());
            }
            Path directory = path;
            if (this.maxSizePercent > 0.0) {
                long l2;
                try {
                    double size2 = this.maxSizePercent * (double)FileSystems_jvmKt.remainingFreeSpaceBytes(this.fileSystem, directory);
                    l2 = RangesKt.coerceIn((long)((long)size2), (long)this.minimumMaxSizeBytes, (long)this.maximumMaxSizeBytes);
                }
                catch (Exception exception) {
                    l2 = this.minimumMaxSizeBytes;
                }
                l = l2;
            } else {
                l = this.maxSizeBytes;
            }
            long maxSize = l;
            return new RealDiskCache(maxSize, directory, this.fileSystem, this.cleanupCoroutineContext);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\b\u001a\u00020\tH&J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH&J\b\u0010\f\u001a\u00020\tH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcoil3/disk/DiskCache$Editor;", "", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "commit", "", "commitAndOpenSnapshot", "Lcoil3/disk/DiskCache$Snapshot;", "abort", "coil-core"})
    public static interface Editor {
        @NotNull
        public Path getMetadata();

        @NotNull
        public Path getData();

        public void commit();

        @Nullable
        public Snapshot commitAndOpenSnapshot();

        public void abort();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00060\u0001j\u0002`\u0002J\b\u0010\t\u001a\u00020\nH&J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH&R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcoil3/disk/DiskCache$Snapshot;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "metadata", "Lokio/Path;", "getMetadata", "()Lokio/Path;", "data", "getData", "close", "", "closeAndOpenEditor", "Lcoil3/disk/DiskCache$Editor;", "coil-core"})
    public static interface Snapshot
    extends AutoCloseable {
        @NotNull
        public Path getMetadata();

        @NotNull
        public Path getData();

        @Override
        public void close();

        @Nullable
        public Editor closeAndOpenEditor();
    }
}

