/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.parser.impl;

import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.parser.structs.FieldDef;
import com.thoughtworks.qdox.parser.structs.MethodDef;
import com.thoughtworks.qdox.parser.structs.PackageDef;
import com.thoughtworks.qdox.parser.structs.TypeDef;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.StringTokenizer;

public class BinaryClassParser {
    private Class<?> declaringClazz;
    private Builder binaryBuilder;

    public BinaryClassParser(Class<?> declaringClazz, Builder modelBuilder) {
        this.declaringClazz = declaringClazz;
        this.binaryBuilder = modelBuilder;
    }

    public boolean parse() {
        try {
            if (this.declaringClazz.getPackage() != null && !"".equals(this.declaringClazz.getPackage().getName())) {
                this.binaryBuilder.addPackage(new PackageDef(this.declaringClazz.getPackage().getName()));
            }
            this.addClass(this.declaringClazz);
            return true;
        }
        catch (NoClassDefFoundError e) {
            return false;
        }
    }

    private void addClass(Class<?> clazz) {
        Class<?> anInterface;
        ClassDef classDef = new ClassDef(clazz.getSimpleName());
        Class<?>[] interfaces = clazz.getInterfaces();
        if (clazz.isEnum()) {
            classDef.setType("enum");
        } else if (clazz.isAnnotation()) {
            classDef.setType("@interface");
        } else if (clazz.isInterface()) {
            classDef.setType("interface");
            for (int i = 0; i < interfaces.length; ++i) {
                anInterface = interfaces[i];
                classDef.getExtends().add(new TypeDef(anInterface.getName()));
            }
        } else {
            for (int i = 0; i < interfaces.length; ++i) {
                anInterface = interfaces[i];
                classDef.getImplements().add(new TypeDef(anInterface.getName()));
            }
            Class<?> superclass = clazz.getSuperclass();
            if (superclass != null) {
                classDef.getExtends().add(new TypeDef(superclass.getName()));
            }
        }
        BinaryClassParser.addModifiers(classDef.getModifiers(), clazz.getModifiers());
        this.binaryBuilder.beginClass(classDef);
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            this.binaryBuilder.beginConstructor();
            MethodDef methodDef = this.createMethodDef(constructors[i]);
            this.binaryBuilder.endConstructor(methodDef);
        }
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            this.binaryBuilder.beginMethod();
            MethodDef methodDef = this.createMethodDef(methods[i]);
            this.binaryBuilder.endMethod(methodDef);
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            this.addField(fields[i]);
        }
        Class<?>[] classes = clazz.getDeclaredClasses();
        for (int i = 0; i < classes.length; ++i) {
            this.addClass(classes[i]);
        }
        this.binaryBuilder.endClass();
    }

    private static void addModifiers(Set<String> set, int modifier) {
        String modifierString = Modifier.toString(modifier);
        StringTokenizer stringTokenizer = new StringTokenizer(modifierString);
        while (stringTokenizer.hasMoreTokens()) {
            set.add(stringTokenizer.nextToken());
        }
    }

    private void addField(Field field) {
        FieldDef fieldDef = new FieldDef(field.getName());
        Class<?> fieldType = field.getType();
        fieldDef.setType(BinaryClassParser.getTypeDef(fieldType));
        fieldDef.setDimensions(BinaryClassParser.getDimension(fieldType));
        fieldDef.setEnumConstant(field.isEnumConstant());
        BinaryClassParser.addModifiers(fieldDef.getModifiers(), field.getModifiers());
        this.binaryBuilder.beginField(fieldDef);
        this.binaryBuilder.endField();
    }

    private MethodDef createMethodDef(Member member) {
        int j;
        Class<?>[] parameterTypes;
        Class<?>[] exceptions;
        MethodDef methodDef = new MethodDef();
        int lastDot = member.getName().lastIndexOf(46);
        methodDef.setName(member.getName().substring(lastDot + 1));
        BinaryClassParser.addModifiers(methodDef.getModifiers(), member.getModifiers());
        if (member instanceof Method) {
            methodDef.setConstructor(false);
            exceptions = ((Method)member).getExceptionTypes();
            parameterTypes = ((Method)member).getParameterTypes();
            Class<?> returnType = ((Method)member).getReturnType();
            methodDef.setReturnType(BinaryClassParser.getTypeDef(returnType));
            methodDef.setDimensions(BinaryClassParser.getDimension(returnType));
        } else {
            methodDef.setConstructor(true);
            exceptions = ((Constructor)member).getExceptionTypes();
            parameterTypes = ((Constructor)member).getParameterTypes();
        }
        for (j = 0; j < exceptions.length; ++j) {
            Class<?> exception = exceptions[j];
            methodDef.getExceptions().add(BinaryClassParser.getTypeDef(exception));
        }
        for (j = 0; j < parameterTypes.length; ++j) {
            FieldDef param = new FieldDef("p" + j);
            Class<?> parameterType = parameterTypes[j];
            param.setType(BinaryClassParser.getTypeDef(parameterType));
            param.setDimensions(BinaryClassParser.getDimension(parameterType));
            this.binaryBuilder.addParameter(param);
        }
        return methodDef;
    }

    private static int getDimension(Class<?> c) {
        return c.getName().lastIndexOf(91) + 1;
    }

    private static String getTypeName(Class<?> c) {
        return c.getComponentType() != null ? c.getComponentType().getName() : c.getName();
    }

    private static TypeDef getTypeDef(Class<?> c) {
        return new TypeDef(BinaryClassParser.getTypeName(c));
    }
}

