/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.beam;

import java.util.BitSet;
import uk.ac.ebi.beam.Bond;
import uk.ac.ebi.beam.Edge;
import uk.ac.ebi.beam.Graph;
import uk.ac.ebi.beam.Matching;

final class ArbitraryMatching {
    ArbitraryMatching() {
    }

    static int initial(Graph g, Matching m, BitSet s) {
        int nMatched = 0;
        int v = s.nextSetBit(0);
        while (v >= 0) {
            if (!m.matched(v)) {
                int d = g.degree(v);
                for (int j = 0; j < d; ++j) {
                    Edge e = g.edgeAt(v, j);
                    int w = e.other(v);
                    if (e.bond() == Bond.SINGLE || !m.unmatched(w) || !s.get(w)) continue;
                    m.match(v, w);
                    nMatched += 2;
                    break;
                }
            }
            v = s.nextSetBit(v + 1);
        }
        return nMatched;
    }

    static int dfs(Graph g, Matching m, BitSet s) {
        int nMatched = 0;
        BitSet unvisited = (BitSet)s.clone();
        int v = unvisited.nextSetBit(0);
        while (v >= 0) {
            if (!m.matched(v)) {
                int cnt = 0;
                int d = g.degree(v);
                while (--d >= 0) {
                    int w = g.edgeAt(v, d).other(v);
                    if (!unvisited.get(w)) continue;
                    ++cnt;
                }
                if (cnt == 1) {
                    nMatched += ArbitraryMatching.dfsVisit(g, v, m, unvisited, true);
                }
            }
            v = unvisited.nextSetBit(v + 1);
        }
        v = unvisited.nextSetBit(0);
        while (v >= 0) {
            if (!m.matched(v)) {
                nMatched += ArbitraryMatching.dfsVisit(g, v, m, unvisited, true);
            }
            v = unvisited.nextSetBit(v + 1);
        }
        return nMatched;
    }

    static int dfsVisit(Graph g, int v, Matching m, BitSet unvisited, boolean match) {
        unvisited.clear(v);
        int nMatched = 0;
        int d = g.degree(v);
        while (--d >= 0) {
            int w = g.edgeAt(v, d).other(v);
            if (!unvisited.get(w)) continue;
            if (match) {
                m.match(v, w);
                return 2 + ArbitraryMatching.dfsVisit(g, w, m, unvisited, false);
            }
            nMatched += ArbitraryMatching.dfsVisit(g, w, m, unvisited, true);
        }
        return nMatched;
    }

    static int augmentOnce(Graph g, Matching m, int nMatched, BitSet s) {
        int vStart = s.nextSetBit(0);
        while (vStart >= 0 && m.matched(vStart)) {
            vStart = s.nextSetBit(vStart + 1);
        }
        int vEnd = s.nextSetBit(vStart + 1);
        while (vEnd >= 0 && m.matched(vEnd)) {
            vEnd = s.nextSetBit(vEnd + 1);
        }
        int[] path = new int[g.order()];
        int len = ArbitraryMatching.findPath(g, vStart, vEnd, s, path, 0, m, false);
        if (len > 0) {
            for (int i = 0; i < len; i += 2) {
                m.match(path[i], path[i + 1]);
            }
            nMatched += 2;
        }
        return nMatched;
    }

    static int findPath(Graph g, int v, int end, BitSet unvisited, int[] path, int len, Matching m, boolean matchNeeded) {
        unvisited.clear(v);
        path[len++] = v;
        int d = g.degree(v);
        for (int j = 0; j < d; ++j) {
            int l;
            int w;
            Edge e = g.edgeAt(v, j);
            if (e.bond() == Bond.SINGLE || !unvisited.get(w = e.other(v))) continue;
            if (w == end) {
                path[len] = w;
                unvisited.set(v);
                return (++len & 1) == 1 ? 0 : len;
            }
            if (m.other(w) == v != matchNeeded || (l = ArbitraryMatching.findPath(g, w, end, unvisited, path, len, m, !matchNeeded)) <= 0) continue;
            unvisited.set(v);
            return l;
        }
        unvisited.set(v);
        return 0;
    }
}

