/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

public class PreparedTxnState {
    private final long producerId;
    private final short epoch;

    public PreparedTxnState() {
        this.producerId = -1L;
        this.epoch = (short)-1;
    }

    public PreparedTxnState(String serializedState) {
        if (serializedState == null || serializedState.isEmpty()) {
            this.producerId = -1L;
            this.epoch = (short)-1;
            return;
        }
        try {
            String[] parts = serializedState.split(":");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid serialized transaction state format: " + serializedState);
            }
            this.producerId = Long.parseLong(parts[0]);
            this.epoch = Short.parseShort(parts[1]);
            if (this.producerId < 0L || this.epoch < 0) {
                throw new IllegalArgumentException("Invalid producer ID and epoch values: " + this.producerId + ":" + this.epoch + ". Both must be >= 0");
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid serialized transaction state format: " + serializedState, e);
        }
    }

    PreparedTxnState(long producerId, short epoch) {
        this.producerId = producerId;
        this.epoch = epoch;
    }

    public long producerId() {
        return this.producerId;
    }

    public short epoch() {
        return this.epoch;
    }

    public boolean hasTransaction() {
        return this.producerId != -1L;
    }

    public String toString() {
        if (!this.hasTransaction()) {
            return "";
        }
        return this.producerId + ":" + this.epoch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PreparedTxnState that = (PreparedTxnState)o;
        return this.producerId == that.producerId && this.epoch == that.epoch;
    }

    public int hashCode() {
        int result = 31;
        result = 31 * result + Long.hashCode(this.producerId);
        result = 31 * result + this.epoch;
        return result;
    }
}

