/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.streams.MemberState;
import org.apache.kafka.coordinator.group.streams.TasksTuple;

public record StreamsGroupMember(String memberId, Integer memberEpoch, Integer previousMemberEpoch, MemberState state, Optional<String> instanceId, Optional<String> rackId, String clientId, String clientHost, Integer rebalanceTimeoutMs, Integer topologyEpoch, String processId, Optional<StreamsGroupMemberMetadataValue.Endpoint> userEndpoint, Map<String, String> clientTags, TasksTuple assignedTasks, TasksTuple tasksPendingRevocation) {
    public StreamsGroupMember {
        Objects.requireNonNull(memberId, "memberId cannot be null");
        clientTags = clientTags != null ? Collections.unmodifiableMap(clientTags) : null;
    }

    public boolean isReconciledTo(int targetAssignmentEpoch) {
        return this.state == MemberState.STABLE && this.memberEpoch == targetAssignmentEpoch;
    }

    public StreamsGroupDescribeResponseData.Member asStreamsGroupDescribeMember(TasksTuple targetAssignment) {
        StreamsGroupDescribeResponseData.Assignment describedTargetAssignment = new StreamsGroupDescribeResponseData.Assignment();
        if (targetAssignment != null) {
            describedTargetAssignment.setActiveTasks(StreamsGroupMember.taskIdsFromMap(targetAssignment.activeTasks())).setStandbyTasks(StreamsGroupMember.taskIdsFromMap(targetAssignment.standbyTasks())).setWarmupTasks(StreamsGroupMember.taskIdsFromMap(targetAssignment.warmupTasks()));
        }
        return new StreamsGroupDescribeResponseData.Member().setMemberEpoch(this.memberEpoch.intValue()).setMemberId(this.memberId).setAssignment(new StreamsGroupDescribeResponseData.Assignment().setActiveTasks(StreamsGroupMember.taskIdsFromMap(this.assignedTasks.activeTasks())).setStandbyTasks(StreamsGroupMember.taskIdsFromMap(this.assignedTasks.standbyTasks())).setWarmupTasks(StreamsGroupMember.taskIdsFromMap(this.assignedTasks.warmupTasks()))).setTargetAssignment(describedTargetAssignment).setClientHost(this.clientHost).setClientId(this.clientId).setInstanceId((String)this.instanceId.orElse(null)).setRackId((String)this.rackId.orElse(null)).setClientTags(this.clientTags.entrySet().stream().map(entry -> new StreamsGroupDescribeResponseData.KeyValue().setKey((String)entry.getKey()).setValue((String)entry.getValue())).toList()).setProcessId(this.processId).setTopologyEpoch(this.topologyEpoch.intValue()).setUserEndpoint((StreamsGroupDescribeResponseData.Endpoint)this.userEndpoint.map(endpoint -> new StreamsGroupDescribeResponseData.Endpoint().setHost(endpoint.host()).setPort(endpoint.port())).orElse(null));
    }

    private static List<StreamsGroupDescribeResponseData.TaskIds> taskIdsFromMap(Map<String, Set<Integer>> tasks) {
        ArrayList<StreamsGroupDescribeResponseData.TaskIds> taskIds = new ArrayList<StreamsGroupDescribeResponseData.TaskIds>();
        tasks.keySet().stream().sorted().forEach(subtopologyId -> taskIds.add(new StreamsGroupDescribeResponseData.TaskIds().setSubtopologyId(subtopologyId).setPartitions(((Set)tasks.get(subtopologyId)).stream().sorted().toList())));
        return taskIds;
    }

    public static boolean hasAssignedTasksChanged(StreamsGroupMember member1, StreamsGroupMember member2) {
        return !member1.assignedTasks().equals(member2.assignedTasks());
    }

    public static class Builder {
        private final String memberId;
        private Integer memberEpoch = null;
        private Integer previousMemberEpoch = null;
        private MemberState state = null;
        private Optional<String> instanceId = null;
        private Optional<String> rackId = null;
        private Integer rebalanceTimeoutMs = null;
        private String clientId = null;
        private String clientHost = null;
        private Integer topologyEpoch = null;
        private String processId = null;
        private Optional<StreamsGroupMemberMetadataValue.Endpoint> userEndpoint = null;
        private Map<String, String> clientTags = null;
        private TasksTuple assignedTasks = null;
        private TasksTuple tasksPendingRevocation = null;

        public Builder(String memberId) {
            this.memberId = Objects.requireNonNull(memberId, "memberId cannot be null");
        }

        public Builder(StreamsGroupMember member) {
            Objects.requireNonNull(member, "member cannot be null");
            this.memberId = member.memberId;
            this.memberEpoch = member.memberEpoch;
            this.previousMemberEpoch = member.previousMemberEpoch;
            this.instanceId = member.instanceId;
            this.rackId = member.rackId;
            this.rebalanceTimeoutMs = member.rebalanceTimeoutMs;
            this.clientId = member.clientId;
            this.clientHost = member.clientHost;
            this.topologyEpoch = member.topologyEpoch;
            this.processId = member.processId;
            this.userEndpoint = member.userEndpoint;
            this.clientTags = member.clientTags;
            this.state = member.state;
            this.assignedTasks = member.assignedTasks;
            this.tasksPendingRevocation = member.tasksPendingRevocation;
        }

        public Builder updateMemberEpoch(int memberEpoch) {
            int currentMemberEpoch = this.memberEpoch;
            this.memberEpoch = memberEpoch;
            this.previousMemberEpoch = currentMemberEpoch;
            return this;
        }

        public Builder setMemberEpoch(int memberEpoch) {
            this.memberEpoch = memberEpoch;
            return this;
        }

        public Builder setPreviousMemberEpoch(int previousMemberEpoch) {
            this.previousMemberEpoch = previousMemberEpoch;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.instanceId = Optional.ofNullable(instanceId);
            return this;
        }

        public Builder maybeUpdateInstanceId(Optional<String> instanceId) {
            instanceId.ifPresent(this::setInstanceId);
            return this;
        }

        public Builder setRackId(String rackId) {
            this.rackId = Optional.ofNullable(rackId);
            return this;
        }

        public Builder maybeUpdateRackId(Optional<String> rackId) {
            rackId.ifPresent(this::setRackId);
            return this;
        }

        public Builder setRebalanceTimeoutMs(int rebalanceTimeoutMs) {
            this.rebalanceTimeoutMs = rebalanceTimeoutMs;
            return this;
        }

        public Builder maybeUpdateRebalanceTimeoutMs(OptionalInt rebalanceTimeoutMs) {
            this.rebalanceTimeoutMs = rebalanceTimeoutMs.orElse(this.rebalanceTimeoutMs);
            return this;
        }

        public Builder setClientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public Builder setClientHost(String clientHost) {
            this.clientHost = clientHost;
            return this;
        }

        public Builder setState(MemberState state) {
            this.state = state;
            return this;
        }

        public Builder setTopologyEpoch(int topologyEpoch) {
            this.topologyEpoch = topologyEpoch;
            return this;
        }

        public Builder maybeUpdateTopologyEpoch(OptionalInt topologyEpoch) {
            this.topologyEpoch = topologyEpoch.orElse(this.topologyEpoch);
            return this;
        }

        public Builder setProcessId(String processId) {
            this.processId = processId;
            return this;
        }

        public Builder maybeUpdateProcessId(Optional<String> processId) {
            this.processId = processId.orElse(this.processId);
            return this;
        }

        public Builder setUserEndpoint(StreamsGroupMemberMetadataValue.Endpoint userEndpoint) {
            this.userEndpoint = Optional.ofNullable(userEndpoint);
            return this;
        }

        public Builder maybeUpdateUserEndpoint(Optional<StreamsGroupMemberMetadataValue.Endpoint> userEndpoint) {
            userEndpoint.ifPresent(this::setUserEndpoint);
            return this;
        }

        public Builder setClientTags(Map<String, String> clientTags) {
            this.clientTags = clientTags;
            return this;
        }

        public Builder maybeUpdateClientTags(Optional<Map<String, String>> clientTags) {
            this.clientTags = clientTags.orElse(this.clientTags);
            return this;
        }

        public Builder setAssignedTasks(TasksTuple assignedTasks) {
            this.assignedTasks = assignedTasks;
            return this;
        }

        public Builder setTasksPendingRevocation(TasksTuple tasksPendingRevocation) {
            this.tasksPendingRevocation = tasksPendingRevocation;
            return this;
        }

        public Builder updateWith(StreamsGroupMemberMetadataValue record) {
            this.setInstanceId(record.instanceId());
            this.setRackId(record.rackId());
            this.setClientId(record.clientId());
            this.setClientHost(record.clientHost());
            this.setRebalanceTimeoutMs(record.rebalanceTimeoutMs());
            this.setTopologyEpoch(record.topologyEpoch());
            this.setProcessId(record.processId());
            this.setUserEndpoint(record.userEndpoint());
            this.setClientTags(record.clientTags().stream().collect(Collectors.toMap(StreamsGroupMemberMetadataValue.KeyValue::key, StreamsGroupMemberMetadataValue.KeyValue::value)));
            return this;
        }

        public Builder updateWith(StreamsGroupCurrentMemberAssignmentValue record) {
            this.setMemberEpoch(record.memberEpoch());
            this.setPreviousMemberEpoch(record.previousMemberEpoch());
            this.setState(MemberState.fromValue(record.state()));
            this.setAssignedTasks(new TasksTuple(Builder.assignmentFromTaskIds(record.activeTasks()), Builder.assignmentFromTaskIds(record.standbyTasks()), Builder.assignmentFromTaskIds(record.warmupTasks())));
            this.setTasksPendingRevocation(new TasksTuple(Builder.assignmentFromTaskIds(record.activeTasksPendingRevocation()), Builder.assignmentFromTaskIds(record.standbyTasksPendingRevocation()), Builder.assignmentFromTaskIds(record.warmupTasksPendingRevocation())));
            return this;
        }

        private static Map<String, Set<Integer>> assignmentFromTaskIds(List<StreamsGroupCurrentMemberAssignmentValue.TaskIds> topicPartitionsList) {
            return topicPartitionsList.stream().collect(Collectors.toMap(StreamsGroupCurrentMemberAssignmentValue.TaskIds::subtopologyId, taskIds -> Set.copyOf(taskIds.partitions())));
        }

        public static Builder withDefaults(String memberId) {
            return new Builder(memberId).setRebalanceTimeoutMs(-1).setTopologyEpoch(-1).setInstanceId(null).setRackId(null).setProcessId("").setClientTags(Collections.emptyMap()).setState(MemberState.STABLE).setMemberEpoch(0).setAssignedTasks(TasksTuple.EMPTY).setTasksPendingRevocation(TasksTuple.EMPTY).setUserEndpoint(null);
        }

        public StreamsGroupMember build() {
            return new StreamsGroupMember(this.memberId, this.memberEpoch, this.previousMemberEpoch, this.state, this.instanceId, this.rackId, this.clientId, this.clientHost, this.rebalanceTimeoutMs, this.topologyEpoch, this.processId, this.userEndpoint, this.clientTags, this.assignedTasks, this.tasksPendingRevocation);
        }
    }
}

