/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import jakarta.ws.rs.core.Application;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.common.crypto.CryptoIntegration;
import org.keycloak.config.ConfigProviderFactory;
import org.keycloak.exportimport.ExportImportConfig;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.dblock.DBLockManager;
import org.keycloak.models.dblock.DBLockProvider;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.platform.Platform;
import org.keycloak.platform.PlatformProvider;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.services.managers.ApplianceBootstrap;
import org.keycloak.transaction.JtaTransactionManagerLookup;

public abstract class KeycloakApplication
extends Application {
    private static final Logger logger = Logger.getLogger(KeycloakApplication.class);
    protected final PlatformProvider platform = Platform.getPlatform();
    private static KeycloakSessionFactory sessionFactory;

    public KeycloakApplication() {
        try {
            logger.debugv("PlatformProvider: {0}", (Object)this.platform.getClass().getName());
            this.loadConfig();
            this.platform.onStartup(this::startup);
            this.platform.onShutdown(this::shutdown);
        }
        catch (Throwable t) {
            this.platform.exit(t);
        }
    }

    protected void startup() {
        Profile.getInstance().logUnsupportedFeatures();
        CryptoIntegration.init((ClassLoader)KeycloakApplication.class.getClassLoader());
        sessionFactory = this.createSessionFactory();
        final ExportImportManager[] exportImportManager = new ExportImportManager[1];
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession session) {
                DBLockManager dbLockManager = new DBLockManager(session);
                dbLockManager.checkForcedUnlock();
                DBLockProvider dbLock = dbLockManager.getDBLock();
                dbLock.waitForLock(DBLockProvider.Namespace.KEYCLOAK_BOOT);
                try {
                    exportImportManager[0] = KeycloakApplication.this.bootstrap();
                }
                finally {
                    dbLock.releaseLock();
                }
            }
        });
        if (exportImportManager[0].isRunExport()) {
            exportImportManager[0].runExport();
        }
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent(sessionFactory));
    }

    protected void shutdown() {
        if (sessionFactory != null) {
            sessionFactory.close();
        }
    }

    protected ExportImportManager bootstrap() {
        final BootstrapState bootstrapState = new BootstrapState();
        logger.debug((Object)"bootstrap");
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(KeycloakSession session) {
                JtaTransactionManagerLookup lookup = (JtaTransactionManagerLookup)sessionFactory.getProviderFactory(JtaTransactionManagerLookup.class);
                if (lookup != null && lookup.getTransactionManager() != null) {
                    try {
                        Transaction transaction = lookup.getTransactionManager().getTransaction();
                        logger.debugv("bootstrap current transaction? {0}", (Object)(transaction != null ? 1 : 0));
                        if (transaction != null) {
                            logger.debugv("bootstrap current transaction status? {0}", (Object)transaction.getStatus());
                        }
                    }
                    catch (SystemException e) {
                        throw new RuntimeException(e);
                    }
                }
                ApplianceBootstrap applianceBootstrap = new ApplianceBootstrap(session);
                ExportImportManager exportImportManager = bootstrapState.exportImportManager = new ExportImportManager(session);
                bootstrapState.newInstall = applianceBootstrap.isNewInstall();
                if (bootstrapState.newInstall) {
                    boolean existing = ExportImportConfig.isSingleTransaction();
                    ExportImportConfig.setSingleTransaction(true);
                    try {
                        if (!exportImportManager.isImportMasterIncluded()) {
                            applianceBootstrap.createMasterRealm();
                        }
                        exportImportManager.runImport();
                        KeycloakApplication.this.createTemporaryAdmin(session);
                    }
                    finally {
                        ExportImportConfig.setSingleTransaction(existing);
                    }
                }
            }
        });
        if (!bootstrapState.newInstall) {
            bootstrapState.exportImportManager.runImport();
        }
        return bootstrapState.exportImportManager;
    }

    protected abstract void createTemporaryAdmin(KeycloakSession var1);

    protected void loadConfig() {
        ServiceLoader<ConfigProviderFactory> loader = ServiceLoader.load(ConfigProviderFactory.class, KeycloakApplication.class.getClassLoader());
        try {
            ConfigProviderFactory factory = loader.iterator().next();
            logger.debugv("ConfigProvider: {0}", (Object)factory.getClass().getName());
            Config.init((Config.ConfigProvider)factory.create().orElseThrow(() -> new RuntimeException("Failed to load Keycloak configuration")));
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("No valid ConfigProvider found");
        }
    }

    protected abstract KeycloakSessionFactory createSessionFactory();

    public static KeycloakSessionFactory getSessionFactory() {
        return sessionFactory;
    }

    private static class BootstrapState {
        ExportImportManager exportImportManager;
        boolean newInstall;

        private BootstrapState() {
        }
    }
}

