/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.protocol;

import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.saml.v2.protocol.StatusCodeType;
import org.keycloak.dom.saml.v2.protocol.StatusDetailType;
import org.keycloak.dom.saml.v2.protocol.StatusType;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.AnyDomParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.protocol.AbstractStaxSamlProtocolParser;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLProtocolQNames;
import org.keycloak.saml.processing.core.parsers.saml.protocol.SAMLStatusCodeParser;
import org.w3c.dom.Element;

public class SAMLStatusParser
extends AbstractStaxSamlProtocolParser<StatusType> {
    private static final SAMLStatusParser INSTANCE = new SAMLStatusParser();
    private static final AnyDomParser STATUS_DETAIL_PARSER = AnyDomParser.getInstance(SAMLProtocolQNames.STATUS_DETAIL.getQName());

    private SAMLStatusParser() {
        super(SAMLProtocolQNames.STATUS);
    }

    public static SAMLStatusParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected StatusType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new StatusType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, StatusType target, SAMLProtocolQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case STATUS_CODE: {
                target.setStatusCode((StatusCodeType)SAMLStatusCodeParser.getInstance().parse(xmlEventReader));
                break;
            }
            case STATUS_MESSAGE: {
                StaxParserUtil.advance(xmlEventReader);
                target.setStatusMessage(StaxParserUtil.getElementText(xmlEventReader));
                break;
            }
            case STATUS_DETAIL: {
                List elements = (List)STATUS_DETAIL_PARSER.parse(xmlEventReader);
                StatusDetailType statusDetailType = new StatusDetailType();
                for (Element e : elements) {
                    statusDetailType.addStatusDetail((Object)e);
                }
                target.setStatusDetail(statusDetailType);
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

