/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ResourceType {
    private final String type;
    private final Set<String> scopes;
    private final Map<String, Set<String>> scopeAliases;
    private final String groupType;

    @JsonCreator
    public ResourceType(@JsonProperty(value="type") String type, @JsonProperty(value="scopes") Set<String> scopes) {
        this(type, scopes, Collections.emptyMap());
    }

    public ResourceType(String type, Set<String> scopes, Map<String, Set<String>> scopeAliases) {
        this(type, scopes, scopeAliases, null);
    }

    public ResourceType(String type, Set<String> scopes, Map<String, Set<String>> scopeAliases, String groupType) {
        this.type = type;
        this.scopes = Collections.unmodifiableSet(scopes);
        this.scopeAliases = scopeAliases;
        this.groupType = groupType;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getScopes() {
        return Collections.unmodifiableSet(this.scopes);
    }

    public Map<String, Set<String>> getScopeAliases() {
        return Collections.unmodifiableMap(this.scopeAliases);
    }

    public String getGroupType() {
        return this.groupType;
    }
}

