/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.internal;

import java.util.Locale;
import org.hibernate.sql.model.MutationOperation;
import org.hibernate.sql.model.MutationOperationGroup;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.MutationType;

final class MutationOperationGroupStandard
implements MutationOperationGroup {
    private static final MutationOperation[] EMPTY = new MutationOperation[0];
    private final MutationType mutationType;
    private final MutationTarget mutationTarget;
    private final MutationOperation[] operations;

    MutationOperationGroupStandard(MutationType mutationType, MutationTarget mutationTarget) {
        this(mutationType, mutationTarget, EMPTY);
    }

    MutationOperationGroupStandard(MutationType mutationType, MutationTarget mutationTarget, MutationOperation operation) {
        this(mutationType, mutationTarget, new MutationOperation[]{operation});
    }

    MutationOperationGroupStandard(MutationType mutationType, MutationTarget mutationTarget, MutationOperation[] operations) {
        this.mutationType = mutationType;
        this.mutationTarget = mutationTarget;
        this.operations = operations;
    }

    @Override
    public MutationType getMutationType() {
        return this.mutationType;
    }

    @Override
    public MutationTarget getMutationTarget() {
        return this.mutationTarget;
    }

    @Override
    public int getNumberOfOperations() {
        return this.operations.length;
    }

    @Override
    public MutationOperation getSingleOperation() {
        if (this.operations.length == 1) {
            return this.operations[0];
        }
        throw new IllegalStateException(String.format(Locale.ROOT, "Group contains multiple table mutations - %s : %s ", this.getMutationType().name(), this.getMutationTarget().getNavigableRole()));
    }

    @Override
    public MutationOperation getOperation(int idx) {
        return this.operations[idx];
    }

    @Override
    public MutationOperation getOperation(String tableName) {
        for (int i = 0; i < this.operations.length; ++i) {
            MutationOperation operation = this.operations[i];
            if (!operation.getTableDetails().getTableName().equals(tableName)) continue;
            return operation;
        }
        return null;
    }
}

