/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.openapi.runtime.filter;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;
import org.jboss.logging.Logger;

public abstract class AutoSecurityFilter
implements OASFilter {
    private static final Logger log = Logger.getLogger(AutoSecurityFilter.class);
    private String securitySchemeName;
    private String securitySchemeDescription;
    private Map<String, String> securitySchemeExtensions;

    protected AutoSecurityFilter() {
    }

    protected AutoSecurityFilter(String securitySchemeName, String securitySchemeDescription, Map<String, String> securitySchemeExtensions) {
        this.securitySchemeName = securitySchemeName;
        this.securitySchemeDescription = securitySchemeDescription;
        this.securitySchemeExtensions = securitySchemeExtensions;
    }

    public String getSecuritySchemeName() {
        return this.securitySchemeName;
    }

    public void setSecuritySchemeName(String securitySchemeName) {
        this.securitySchemeName = securitySchemeName;
    }

    public String getSecuritySchemeDescription() {
        return this.securitySchemeDescription;
    }

    public void setSecuritySchemeDescription(String securitySchemeDescription) {
        this.securitySchemeDescription = securitySchemeDescription;
    }

    public Map<String, String> getSecuritySchemeExtensions() {
        return this.securitySchemeExtensions;
    }

    public void setSecuritySchemeExtensions(Map<String, String> securitySchemeExtensions) {
        this.securitySchemeExtensions = securitySchemeExtensions;
    }

    public boolean runtimeRequired() {
        return false;
    }

    public void filterOpenAPI(OpenAPI openAPI) {
        if (openAPI.getComponents() == null) {
            openAPI.setComponents(OASFactory.createComponents());
        }
        LinkedHashMap<String, SecurityScheme> securitySchemes = new LinkedHashMap<String, SecurityScheme>();
        Optional.ofNullable(openAPI.getComponents().getSecuritySchemes()).ifPresent(securitySchemes::putAll);
        SecurityScheme securityScheme = securitySchemes.computeIfAbsent(this.securitySchemeName, name -> OASFactory.createSecurityScheme());
        this.updateSecurityScheme(securityScheme);
        if (this.securitySchemeDescription != null) {
            securityScheme.setDescription(this.securitySchemeDescription);
        }
        this.securitySchemeExtensions.forEach((arg_0, arg_1) -> ((SecurityScheme)securityScheme).addExtension(arg_0, arg_1));
        securitySchemes.put(this.securitySchemeName, securityScheme);
        openAPI.getComponents().setSecuritySchemes(securitySchemes);
    }

    protected abstract void updateSecurityScheme(SecurityScheme var1);

    protected String getUrl(String configKey, String defaultValue, String shouldEndWith) {
        Config c = ConfigProvider.getConfig();
        Object u = c.getOptionalValue(configKey, String.class).orElse(defaultValue);
        if (u != null && !((String)u).endsWith(shouldEndWith)) {
            u = (String)u + shouldEndWith;
        }
        return u;
    }
}

