/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen.pset;

import java.awt.Color;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.config.Daten;
import mediathek.daten.DatenPset;

public class DuplicatePsetNameCheckListener
implements DocumentListener {
    private final JTextField textField;

    public DuplicatePsetNameCheckListener(JTextField textField) {
        this.textField = textField;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.duplicateNameCheck();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.duplicateNameCheck();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.duplicateNameCheck();
    }

    private void markDuplicate() {
        this.textField.setBackground(Color.ORANGE);
        this.textField.requestFocusInWindow();
    }

    private void resetDuplicate() {
        this.textField.setBackground(UIManager.getDefaults().getColor("TextField.background"));
    }

    private void duplicateNameCheck() {
        long count = Daten.listePset.stream().map(DatenPset::getName).filter(name -> name.equals(this.textField.getText())).count();
        if (count > 1L) {
            this.markDuplicate();
        } else {
            this.resetDuplicate();
        }
    }
}

