# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.0
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.


# Copyright (c) 2019-2021, NVIDIA CORPORATION. All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#  * Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#  * Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#  * Neither the name of NVIDIA CORPORATION nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR
# CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
# PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
# PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
# OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.



from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _NvRules
else:
    import _NvRules

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_SwigPyIterator

    def value(self):
        return _NvRules.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _NvRules.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _NvRules.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _NvRules.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _NvRules.SwigPyIterator_equal(self, x)

    def copy(self):
        return _NvRules.SwigPyIterator_copy(self)

    def next(self):
        return _NvRules.SwigPyIterator_next(self)

    def __next__(self):
        return _NvRules.SwigPyIterator___next__(self)

    def previous(self):
        return _NvRules.SwigPyIterator_previous(self)

    def advance(self, n):
        return _NvRules.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _NvRules.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _NvRules.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _NvRules.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _NvRules.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _NvRules.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _NvRules.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _NvRules:
_NvRules.SwigPyIterator_swigregister(SwigPyIterator)
class map_string_string(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.map_string_string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.map_string_string___nonzero__(self)

    def __bool__(self):
        return _NvRules.map_string_string___bool__(self)

    def __len__(self):
        return _NvRules.map_string_string___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _NvRules.map_string_string___getitem__(self, key)

    def __delitem__(self, key):
        return _NvRules.map_string_string___delitem__(self, key)

    def has_key(self, key):
        return _NvRules.map_string_string_has_key(self, key)

    def keys(self):
        return _NvRules.map_string_string_keys(self)

    def values(self):
        return _NvRules.map_string_string_values(self)

    def items(self):
        return _NvRules.map_string_string_items(self)

    def __contains__(self, key):
        return _NvRules.map_string_string___contains__(self, key)

    def key_iterator(self):
        return _NvRules.map_string_string_key_iterator(self)

    def value_iterator(self):
        return _NvRules.map_string_string_value_iterator(self)

    def __setitem__(self, *args):
        return _NvRules.map_string_string___setitem__(self, *args)

    def asdict(self):
        return _NvRules.map_string_string_asdict(self)

    def __init__(self, *args):
        _NvRules.map_string_string_swiginit(self, _NvRules.new_map_string_string(*args))

    def empty(self):
        return _NvRules.map_string_string_empty(self)

    def size(self):
        return _NvRules.map_string_string_size(self)

    def swap(self, v):
        return _NvRules.map_string_string_swap(self, v)

    def begin(self):
        return _NvRules.map_string_string_begin(self)

    def end(self):
        return _NvRules.map_string_string_end(self)

    def rbegin(self):
        return _NvRules.map_string_string_rbegin(self)

    def rend(self):
        return _NvRules.map_string_string_rend(self)

    def clear(self):
        return _NvRules.map_string_string_clear(self)

    def get_allocator(self):
        return _NvRules.map_string_string_get_allocator(self)

    def count(self, x):
        return _NvRules.map_string_string_count(self, x)

    def erase(self, *args):
        return _NvRules.map_string_string_erase(self, *args)

    def find(self, x):
        return _NvRules.map_string_string_find(self, x)

    def lower_bound(self, x):
        return _NvRules.map_string_string_lower_bound(self, x)

    def upper_bound(self, x):
        return _NvRules.map_string_string_upper_bound(self, x)
    __swig_destroy__ = _NvRules.delete_map_string_string

# Register map_string_string in _NvRules:
_NvRules.map_string_string_swigregister(map_string_string)
class map_string_double(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.map_string_double_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.map_string_double___nonzero__(self)

    def __bool__(self):
        return _NvRules.map_string_double___bool__(self)

    def __len__(self):
        return _NvRules.map_string_double___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _NvRules.map_string_double___getitem__(self, key)

    def __delitem__(self, key):
        return _NvRules.map_string_double___delitem__(self, key)

    def has_key(self, key):
        return _NvRules.map_string_double_has_key(self, key)

    def keys(self):
        return _NvRules.map_string_double_keys(self)

    def values(self):
        return _NvRules.map_string_double_values(self)

    def items(self):
        return _NvRules.map_string_double_items(self)

    def __contains__(self, key):
        return _NvRules.map_string_double___contains__(self, key)

    def key_iterator(self):
        return _NvRules.map_string_double_key_iterator(self)

    def value_iterator(self):
        return _NvRules.map_string_double_value_iterator(self)

    def __setitem__(self, *args):
        return _NvRules.map_string_double___setitem__(self, *args)

    def asdict(self):
        return _NvRules.map_string_double_asdict(self)

    def __init__(self, *args):
        _NvRules.map_string_double_swiginit(self, _NvRules.new_map_string_double(*args))

    def empty(self):
        return _NvRules.map_string_double_empty(self)

    def size(self):
        return _NvRules.map_string_double_size(self)

    def swap(self, v):
        return _NvRules.map_string_double_swap(self, v)

    def begin(self):
        return _NvRules.map_string_double_begin(self)

    def end(self):
        return _NvRules.map_string_double_end(self)

    def rbegin(self):
        return _NvRules.map_string_double_rbegin(self)

    def rend(self):
        return _NvRules.map_string_double_rend(self)

    def clear(self):
        return _NvRules.map_string_double_clear(self)

    def get_allocator(self):
        return _NvRules.map_string_double_get_allocator(self)

    def count(self, x):
        return _NvRules.map_string_double_count(self, x)

    def erase(self, *args):
        return _NvRules.map_string_double_erase(self, *args)

    def find(self, x):
        return _NvRules.map_string_double_find(self, x)

    def lower_bound(self, x):
        return _NvRules.map_string_double_lower_bound(self, x)

    def upper_bound(self, x):
        return _NvRules.map_string_double_upper_bound(self, x)
    __swig_destroy__ = _NvRules.delete_map_string_double

# Register map_string_double in _NvRules:
_NvRules.map_string_double_swigregister(map_string_double)
class set_string(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.set_string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.set_string___nonzero__(self)

    def __bool__(self):
        return _NvRules.set_string___bool__(self)

    def __len__(self):
        return _NvRules.set_string___len__(self)

    def append(self, x):
        return _NvRules.set_string_append(self, x)

    def __contains__(self, x):
        return _NvRules.set_string___contains__(self, x)

    def __getitem__(self, i):
        return _NvRules.set_string___getitem__(self, i)

    def add(self, x):
        return _NvRules.set_string_add(self, x)

    def discard(self, x):
        return _NvRules.set_string_discard(self, x)

    def __init__(self, *args):
        _NvRules.set_string_swiginit(self, _NvRules.new_set_string(*args))

    def empty(self):
        return _NvRules.set_string_empty(self)

    def size(self):
        return _NvRules.set_string_size(self)

    def clear(self):
        return _NvRules.set_string_clear(self)

    def swap(self, v):
        return _NvRules.set_string_swap(self, v)

    def count(self, x):
        return _NvRules.set_string_count(self, x)

    def begin(self):
        return _NvRules.set_string_begin(self)

    def end(self):
        return _NvRules.set_string_end(self)

    def rbegin(self):
        return _NvRules.set_string_rbegin(self)

    def rend(self):
        return _NvRules.set_string_rend(self)

    def erase(self, *args):
        return _NvRules.set_string_erase(self, *args)

    def find(self, x):
        return _NvRules.set_string_find(self, x)

    def lower_bound(self, x):
        return _NvRules.set_string_lower_bound(self, x)

    def upper_bound(self, x):
        return _NvRules.set_string_upper_bound(self, x)

    def equal_range(self, x):
        return _NvRules.set_string_equal_range(self, x)

    def insert(self, __x):
        return _NvRules.set_string_insert(self, __x)
    __swig_destroy__ = _NvRules.delete_set_string

# Register set_string in _NvRules:
_NvRules.set_string_swigregister(set_string)
class set_ull(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.set_ull_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.set_ull___nonzero__(self)

    def __bool__(self):
        return _NvRules.set_ull___bool__(self)

    def __len__(self):
        return _NvRules.set_ull___len__(self)

    def append(self, x):
        return _NvRules.set_ull_append(self, x)

    def __contains__(self, x):
        return _NvRules.set_ull___contains__(self, x)

    def __getitem__(self, i):
        return _NvRules.set_ull___getitem__(self, i)

    def add(self, x):
        return _NvRules.set_ull_add(self, x)

    def discard(self, x):
        return _NvRules.set_ull_discard(self, x)

    def __init__(self, *args):
        _NvRules.set_ull_swiginit(self, _NvRules.new_set_ull(*args))

    def empty(self):
        return _NvRules.set_ull_empty(self)

    def size(self):
        return _NvRules.set_ull_size(self)

    def clear(self):
        return _NvRules.set_ull_clear(self)

    def swap(self, v):
        return _NvRules.set_ull_swap(self, v)

    def count(self, x):
        return _NvRules.set_ull_count(self, x)

    def begin(self):
        return _NvRules.set_ull_begin(self)

    def end(self):
        return _NvRules.set_ull_end(self)

    def rbegin(self):
        return _NvRules.set_ull_rbegin(self)

    def rend(self):
        return _NvRules.set_ull_rend(self)

    def erase(self, *args):
        return _NvRules.set_ull_erase(self, *args)

    def find(self, x):
        return _NvRules.set_ull_find(self, x)

    def lower_bound(self, x):
        return _NvRules.set_ull_lower_bound(self, x)

    def upper_bound(self, x):
        return _NvRules.set_ull_upper_bound(self, x)

    def equal_range(self, x):
        return _NvRules.set_ull_equal_range(self, x)

    def insert(self, __x):
        return _NvRules.set_ull_insert(self, __x)
    __swig_destroy__ = _NvRules.delete_set_ull

# Register set_ull in _NvRules:
_NvRules.set_ull_swigregister(set_ull)
class vector_string(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.vector_string_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.vector_string___nonzero__(self)

    def __bool__(self):
        return _NvRules.vector_string___bool__(self)

    def __len__(self):
        return _NvRules.vector_string___len__(self)

    def __getslice__(self, i, j):
        return _NvRules.vector_string___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _NvRules.vector_string___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _NvRules.vector_string___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _NvRules.vector_string___delitem__(self, *args)

    def __getitem__(self, *args):
        return _NvRules.vector_string___getitem__(self, *args)

    def __setitem__(self, *args):
        return _NvRules.vector_string___setitem__(self, *args)

    def pop(self):
        return _NvRules.vector_string_pop(self)

    def append(self, x):
        return _NvRules.vector_string_append(self, x)

    def empty(self):
        return _NvRules.vector_string_empty(self)

    def size(self):
        return _NvRules.vector_string_size(self)

    def swap(self, v):
        return _NvRules.vector_string_swap(self, v)

    def begin(self):
        return _NvRules.vector_string_begin(self)

    def end(self):
        return _NvRules.vector_string_end(self)

    def rbegin(self):
        return _NvRules.vector_string_rbegin(self)

    def rend(self):
        return _NvRules.vector_string_rend(self)

    def clear(self):
        return _NvRules.vector_string_clear(self)

    def get_allocator(self):
        return _NvRules.vector_string_get_allocator(self)

    def pop_back(self):
        return _NvRules.vector_string_pop_back(self)

    def erase(self, *args):
        return _NvRules.vector_string_erase(self, *args)

    def __init__(self, *args):
        _NvRules.vector_string_swiginit(self, _NvRules.new_vector_string(*args))

    def push_back(self, x):
        return _NvRules.vector_string_push_back(self, x)

    def front(self):
        return _NvRules.vector_string_front(self)

    def back(self):
        return _NvRules.vector_string_back(self)

    def assign(self, n, x):
        return _NvRules.vector_string_assign(self, n, x)

    def resize(self, *args):
        return _NvRules.vector_string_resize(self, *args)

    def insert(self, *args):
        return _NvRules.vector_string_insert(self, *args)

    def reserve(self, n):
        return _NvRules.vector_string_reserve(self, n)

    def capacity(self):
        return _NvRules.vector_string_capacity(self)
    __swig_destroy__ = _NvRules.delete_vector_string

# Register vector_string in _NvRules:
_NvRules.vector_string_swigregister(vector_string)
class vector_double(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.vector_double_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.vector_double___nonzero__(self)

    def __bool__(self):
        return _NvRules.vector_double___bool__(self)

    def __len__(self):
        return _NvRules.vector_double___len__(self)

    def __getslice__(self, i, j):
        return _NvRules.vector_double___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _NvRules.vector_double___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _NvRules.vector_double___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _NvRules.vector_double___delitem__(self, *args)

    def __getitem__(self, *args):
        return _NvRules.vector_double___getitem__(self, *args)

    def __setitem__(self, *args):
        return _NvRules.vector_double___setitem__(self, *args)

    def pop(self):
        return _NvRules.vector_double_pop(self)

    def append(self, x):
        return _NvRules.vector_double_append(self, x)

    def empty(self):
        return _NvRules.vector_double_empty(self)

    def size(self):
        return _NvRules.vector_double_size(self)

    def swap(self, v):
        return _NvRules.vector_double_swap(self, v)

    def begin(self):
        return _NvRules.vector_double_begin(self)

    def end(self):
        return _NvRules.vector_double_end(self)

    def rbegin(self):
        return _NvRules.vector_double_rbegin(self)

    def rend(self):
        return _NvRules.vector_double_rend(self)

    def clear(self):
        return _NvRules.vector_double_clear(self)

    def get_allocator(self):
        return _NvRules.vector_double_get_allocator(self)

    def pop_back(self):
        return _NvRules.vector_double_pop_back(self)

    def erase(self, *args):
        return _NvRules.vector_double_erase(self, *args)

    def __init__(self, *args):
        _NvRules.vector_double_swiginit(self, _NvRules.new_vector_double(*args))

    def push_back(self, x):
        return _NvRules.vector_double_push_back(self, x)

    def front(self):
        return _NvRules.vector_double_front(self)

    def back(self):
        return _NvRules.vector_double_back(self)

    def assign(self, n, x):
        return _NvRules.vector_double_assign(self, n, x)

    def resize(self, *args):
        return _NvRules.vector_double_resize(self, *args)

    def insert(self, *args):
        return _NvRules.vector_double_insert(self, *args)

    def reserve(self, n):
        return _NvRules.vector_double_reserve(self, n)

    def capacity(self):
        return _NvRules.vector_double_capacity(self)
    __swig_destroy__ = _NvRules.delete_vector_double

# Register vector_double in _NvRules:
_NvRules.vector_double_swigregister(vector_double)
class vector_longlong(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.vector_longlong_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.vector_longlong___nonzero__(self)

    def __bool__(self):
        return _NvRules.vector_longlong___bool__(self)

    def __len__(self):
        return _NvRules.vector_longlong___len__(self)

    def __getslice__(self, i, j):
        return _NvRules.vector_longlong___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _NvRules.vector_longlong___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _NvRules.vector_longlong___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _NvRules.vector_longlong___delitem__(self, *args)

    def __getitem__(self, *args):
        return _NvRules.vector_longlong___getitem__(self, *args)

    def __setitem__(self, *args):
        return _NvRules.vector_longlong___setitem__(self, *args)

    def pop(self):
        return _NvRules.vector_longlong_pop(self)

    def append(self, x):
        return _NvRules.vector_longlong_append(self, x)

    def empty(self):
        return _NvRules.vector_longlong_empty(self)

    def size(self):
        return _NvRules.vector_longlong_size(self)

    def swap(self, v):
        return _NvRules.vector_longlong_swap(self, v)

    def begin(self):
        return _NvRules.vector_longlong_begin(self)

    def end(self):
        return _NvRules.vector_longlong_end(self)

    def rbegin(self):
        return _NvRules.vector_longlong_rbegin(self)

    def rend(self):
        return _NvRules.vector_longlong_rend(self)

    def clear(self):
        return _NvRules.vector_longlong_clear(self)

    def get_allocator(self):
        return _NvRules.vector_longlong_get_allocator(self)

    def pop_back(self):
        return _NvRules.vector_longlong_pop_back(self)

    def erase(self, *args):
        return _NvRules.vector_longlong_erase(self, *args)

    def __init__(self, *args):
        _NvRules.vector_longlong_swiginit(self, _NvRules.new_vector_longlong(*args))

    def push_back(self, x):
        return _NvRules.vector_longlong_push_back(self, x)

    def front(self):
        return _NvRules.vector_longlong_front(self)

    def back(self):
        return _NvRules.vector_longlong_back(self)

    def assign(self, n, x):
        return _NvRules.vector_longlong_assign(self, n, x)

    def resize(self, *args):
        return _NvRules.vector_longlong_resize(self, *args)

    def insert(self, *args):
        return _NvRules.vector_longlong_insert(self, *args)

    def reserve(self, n):
        return _NvRules.vector_longlong_reserve(self, n)

    def capacity(self):
        return _NvRules.vector_longlong_capacity(self)
    __swig_destroy__ = _NvRules.delete_vector_longlong

# Register vector_longlong in _NvRules:
_NvRules.vector_longlong_swigregister(vector_longlong)
class vector_ull(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.vector_ull_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.vector_ull___nonzero__(self)

    def __bool__(self):
        return _NvRules.vector_ull___bool__(self)

    def __len__(self):
        return _NvRules.vector_ull___len__(self)

    def __getslice__(self, i, j):
        return _NvRules.vector_ull___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _NvRules.vector_ull___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _NvRules.vector_ull___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _NvRules.vector_ull___delitem__(self, *args)

    def __getitem__(self, *args):
        return _NvRules.vector_ull___getitem__(self, *args)

    def __setitem__(self, *args):
        return _NvRules.vector_ull___setitem__(self, *args)

    def pop(self):
        return _NvRules.vector_ull_pop(self)

    def append(self, x):
        return _NvRules.vector_ull_append(self, x)

    def empty(self):
        return _NvRules.vector_ull_empty(self)

    def size(self):
        return _NvRules.vector_ull_size(self)

    def swap(self, v):
        return _NvRules.vector_ull_swap(self, v)

    def begin(self):
        return _NvRules.vector_ull_begin(self)

    def end(self):
        return _NvRules.vector_ull_end(self)

    def rbegin(self):
        return _NvRules.vector_ull_rbegin(self)

    def rend(self):
        return _NvRules.vector_ull_rend(self)

    def clear(self):
        return _NvRules.vector_ull_clear(self)

    def get_allocator(self):
        return _NvRules.vector_ull_get_allocator(self)

    def pop_back(self):
        return _NvRules.vector_ull_pop_back(self)

    def erase(self, *args):
        return _NvRules.vector_ull_erase(self, *args)

    def __init__(self, *args):
        _NvRules.vector_ull_swiginit(self, _NvRules.new_vector_ull(*args))

    def push_back(self, x):
        return _NvRules.vector_ull_push_back(self, x)

    def front(self):
        return _NvRules.vector_ull_front(self)

    def back(self):
        return _NvRules.vector_ull_back(self)

    def assign(self, n, x):
        return _NvRules.vector_ull_assign(self, n, x)

    def resize(self, *args):
        return _NvRules.vector_ull_resize(self, *args)

    def insert(self, *args):
        return _NvRules.vector_ull_insert(self, *args)

    def reserve(self, n):
        return _NvRules.vector_ull_reserve(self, n)

    def capacity(self):
        return _NvRules.vector_ull_capacity(self)
    __swig_destroy__ = _NvRules.delete_vector_ull

# Register vector_ull in _NvRules:
_NvRules.vector_ull_swigregister(vector_ull)
class vector_table_column(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _NvRules.vector_table_column_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _NvRules.vector_table_column___nonzero__(self)

    def __bool__(self):
        return _NvRules.vector_table_column___bool__(self)

    def __len__(self):
        return _NvRules.vector_table_column___len__(self)

    def __getslice__(self, i, j):
        return _NvRules.vector_table_column___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _NvRules.vector_table_column___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _NvRules.vector_table_column___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _NvRules.vector_table_column___delitem__(self, *args)

    def __getitem__(self, *args):
        return _NvRules.vector_table_column___getitem__(self, *args)

    def __setitem__(self, *args):
        return _NvRules.vector_table_column___setitem__(self, *args)

    def pop(self):
        return _NvRules.vector_table_column_pop(self)

    def append(self, x):
        return _NvRules.vector_table_column_append(self, x)

    def empty(self):
        return _NvRules.vector_table_column_empty(self)

    def size(self):
        return _NvRules.vector_table_column_size(self)

    def swap(self, v):
        return _NvRules.vector_table_column_swap(self, v)

    def begin(self):
        return _NvRules.vector_table_column_begin(self)

    def end(self):
        return _NvRules.vector_table_column_end(self)

    def rbegin(self):
        return _NvRules.vector_table_column_rbegin(self)

    def rend(self):
        return _NvRules.vector_table_column_rend(self)

    def clear(self):
        return _NvRules.vector_table_column_clear(self)

    def get_allocator(self):
        return _NvRules.vector_table_column_get_allocator(self)

    def pop_back(self):
        return _NvRules.vector_table_column_pop_back(self)

    def erase(self, *args):
        return _NvRules.vector_table_column_erase(self, *args)

    def __init__(self, *args):
        _NvRules.vector_table_column_swiginit(self, _NvRules.new_vector_table_column(*args))

    def push_back(self, x):
        return _NvRules.vector_table_column_push_back(self, x)

    def front(self):
        return _NvRules.vector_table_column_front(self)

    def back(self):
        return _NvRules.vector_table_column_back(self)

    def assign(self, n, x):
        return _NvRules.vector_table_column_assign(self, n, x)

    def resize(self, *args):
        return _NvRules.vector_table_column_resize(self, *args)

    def insert(self, *args):
        return _NvRules.vector_table_column_insert(self, *args)

    def reserve(self, n):
        return _NvRules.vector_table_column_reserve(self, n)

    def capacity(self):
        return _NvRules.vector_table_column_capacity(self)
    __swig_destroy__ = _NvRules.delete_vector_table_column

# Register vector_table_column in _NvRules:
_NvRules.vector_table_column_swigregister(vector_table_column)

def metric_instances(metric):
    instances = []

    for idx in range(metric.num_instances()):
        kind = metric.kind(idx)
        if (kind == IMetric.ValueKind_FLOAT) or (kind == IMetric.ValueKind_DOUBLE):
            instances.append(metric.as_double(idx))
        elif (kind == IMetric.ValueKind_UINT64) or (kind == IMetric.ValueKind_UINT32):
            instances.append(metric.as_uint64(idx))
        else:
            instances.append(metric.as_string(idx))

    return instances


def require_metrics(handle, metrics):
    """
    Convenience wrapper for :meth:`NvRules.IEvaluator.require_metric`.

    Args:
        handle (:class:`int`): The context handle,
            obtained from :func:`get_context`.
        metrics (:class:`list`) : List of metric names.
    """
    ev = get_evaluator(handle)
    for metric in metrics:
        ev.require_metric(metric)

def require_rules(handle, rules):
    """
    Convenience wrapper for :meth:`NvRules.IEvaluator.require_rule`.

    Args:
        handle (:class:`int`): The context handle,
            obtained from :func:`get_context`.
        rules (:class:`list`) : List of rule identifiers.
    """
    ev = get_evaluator(handle)
    for rule in rules:
        ev.require_rule(rule)


from abc import ABC, abstractmethod
from typing import List, Optional
from warnings import warn

class _ConfigParser(ABC):
    @abstractmethod
    def parse(self, config: Optional[dict]):
        pass


class _StyleConfigParser(_ConfigParser):
    STYLE_KEYS = ("bold", "italic")

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)

    def parse(self, config: Optional[dict]):
        if config is None or not any(key in config for key in self.STYLE_KEYS):
            return None

        style_config = TableStyle()

        style_config.is_bold = config.get("bold", False)
        style_config.is_italic = config.get("italic", False)

        return style_config


class _SortingConfigParser(_ConfigParser):
    SORTING_KEYS = ("column", "order")

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)

    def _get_valid_column_index_or_raise(self, column, header):
        column_index = None
        column_name = None

        if isinstance(column, str):
            column_name = column
        elif isinstance(column, int):
            column_index = column
        else:
            raise ValueError(f"Unsupported type in \"sort_by\" for \"column\": {type(column)}")

        if column_index is None:
            if column_name is not None:
                try:
                    column_index = header.index(column_name)
                except ValueError:
                    raise ValueError(f"Invalid column name in \"sort_by\": {column_name}")
            else:
                raise ValueError("No column specified in \"sort_by\"")

        if 0 <= column_index < len(header):
            return column_index

        raise ValueError(f"Invalid column index in \"sort_by\": {column_index}")

    def _get_is_ascending_or_raise(self, order_keyword):
        if order_keyword.lower() == "ascending":
            return True
        elif order_keyword.lower() == "descending":
            return False
        else:
            raise ValueError(
                f"Invalid order keyword in \"sort_by\": {order_keyword}."
                " Allowed values are \"ascending\" and \"descending\"."
            )

    def parse(self, config: Optional[dict], header: List[str]):
        if config is None or not any(key in config for key in self.SORTING_KEYS):
            return None

        sorting_config = TableSortInfo()

# Specification of column to sort by is mandatory
        if "column" in config:
            column_index = self._get_valid_column_index_or_raise(config["column"], header)
        else:
            raise ValueError("No column specified in \"sort_by\"")

# Order defaults to ascending
        ascending = True
        if "order" in config:
            ascending = self._get_is_ascending_or_raise(config["order"])

        sorting_config.column = column_index
        sorting_config.is_ascending = ascending

        return sorting_config


class _ColumnLevelConfigParser(_ConfigParser):
    COLUMN_LEVEL_KEYS = ("tooltip", "relative_width", "style")

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)

    def parse(self, config: Optional[dict]):
        if config is None or not any(key in config for key in self.COLUMN_LEVEL_KEYS):
            return None

        column_config = TableColumnConfig()

        if "tooltip" in config:
            column_config.tooltip = config["tooltip"]
        if "relative_width" in config:
            column_config.relative_width = config["relative_width"]
        if "style" in config:
            if "header" in config["style"]:
                header_style_config = _StyleConfigParser().parse(config["style"]["header"])
                if header_style_config is not None:
                    column_config.header_style = header_style_config
            if "data" in config["style"]:
                data_style_config = _StyleConfigParser().parse(config["style"]["data"])
                if data_style_config is not None:
                    column_config.data_style = data_style_config

        return column_config


class _GlobalLevelConfigParser(_ConfigParser):
    GLOBAL_LEVEL_KEYS = ("title", "description", "sort_by", "style")

    def __init__(self, *args, **kwargs) -> None:
        super().__init__(*args, **kwargs)

    def parse(self, config: Optional[dict], header: List[str]):
        if config is None or not any(key in config for key in self.GLOBAL_LEVEL_KEYS):
            return None

        table_config = TableConfig()

        if "title" in config:
            table_config.title = config["title"]
        if "description" in config:
            table_config.description = config["description"]
        if "sort_by" in config:
            sort_config = _SortingConfigParser().parse(config["sort_by"], header)
            if sort_config is not None:
                table_config.use_sorting = True
                table_config.sort_by = sort_config
        if "style" in config:
            style_config = _StyleConfigParser().parse(config["style"])
            if style_config is not None:
                table_config.use_styling = True
                table_config.style = style_config

        return table_config


def _transpose_table_data(data_by_row):
    if len(data_by_row) == 0:
        raise ValueError("No rows in data")

    num_columns = len(data_by_row[0])
    if num_columns == 0:
        raise ValueError("No columns in first row of data")

    for id, row in enumerate(data_by_row):
        current_num_columns = len(row)
        if current_num_columns != num_columns:
            raise ValueError(
                f"Row {id} has different length ({current_num_columns})"
                f" than first row ({num_columns})"
            )

    return list(map(list, zip(*data_by_row)))


def _convert_data_to_backend_format(header, data_by_column, config):
    if len(header) == 0:
        raise ValueError("No columns in header")

    if len(header) != len(data_by_column):
        raise ValueError(
            f"Number of columns in header ({len(header)}) does not match"
            f" number of columns in data ({len(data_by_column)})"
        )

    for col_id, column in enumerate(data_by_column):
        first_element = column[0]
        for row_id, element in enumerate(column):
            if type(element) is not type(first_element):
                raise TypeError(
                    f"Column {col_id} has mixed types:"
                    f" {type(element)} (row {row_id}) and"
                    f" {type(first_element)} (row 0)"
                )

    data_backend = TableData()

# fill global config
    table_config = _GlobalLevelConfigParser().parse(config, header)
    if table_config is not None:
        data_backend.has_config = True
        data_backend.config = table_config

# fill columns
    for column_id, (column_name, column_data) in enumerate(zip(header, data_by_column)):
        column_backend = TableColumn()
        column_backend.name = column_name

# set column kind and values
        first_element = column_data[0]

        if isinstance(first_element, int):
            column_backend.kind = TableElementKind_INT
            column_backend.int_values = vector_longlong(column_data)
        elif isinstance(first_element, float):
            column_backend.kind = TableElementKind_DOUBLE
            column_backend.double_values = vector_double(column_data)
        elif isinstance(first_element, str):
            column_backend.kind = TableElementKind_STRING
            column_backend.string_values = vector_string(column_data)
        else:
            try:
                column_backend.kind = TableElementKind_CUSTOM
                column_values = [str(value) for value in column_data]
            except Exception:
                column_backend.kind = TableElementKind_INVALID
                column_values = ["???"] * len(column_data)
            finally:
                column_backend.string_values = vector_string(column_values)

# set column config
        if config is not None and "per_column_configs" in config:
            per_column_config = config["per_column_configs"].get(column_name, None) or \
                config["per_column_configs"].get(column_id, None)
            column_config = _ColumnLevelConfigParser().parse(per_column_config)
            if column_config is not None:
                column_backend.has_column_config = True
                column_backend.column_config = column_config

        data_backend.columns.append(column_backend)

    return data_backend


RuleKind_DEFAULT = _NvRules.RuleKind_DEFAULT
RuleKind_GUIDED = _NvRules.RuleKind_GUIDED
MarkerKind_SASS = _NvRules.MarkerKind_SASS
MarkerKind_SOURCE = _NvRules.MarkerKind_SOURCE
MarkerKind_NONE = _NvRules.MarkerKind_NONE
MsgType_NONE = _NvRules.MsgType_NONE
MsgType_OK = _NvRules.MsgType_OK
MsgType_OPTIMIZATION = _NvRules.MsgType_OPTIMIZATION
MsgType_WARNING = _NvRules.MsgType_WARNING
MsgType_ERR = _NvRules.MsgType_ERR
class RuleResultMessage(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    title = property(_NvRules.RuleResultMessage_title_get, _NvRules.RuleResultMessage_title_set)
    message = property(_NvRules.RuleResultMessage_message_get, _NvRules.RuleResultMessage_message_set)
    type = property(_NvRules.RuleResultMessage_type_get, _NvRules.RuleResultMessage_type_set)

    def __init__(self):
        _NvRules.RuleResultMessage_swiginit(self, _NvRules.new_RuleResultMessage())
    __swig_destroy__ = _NvRules.delete_RuleResultMessage

# Register RuleResultMessage in _NvRules:
_NvRules.RuleResultMessage_swigregister(RuleResultMessage)
class ISourceInfo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_ISourceInfo

    def file_name(self):
        return _NvRules.ISourceInfo_file_name(self)

    def line(self):
        return _NvRules.ISourceInfo_line(self)

# Register ISourceInfo in _NvRules:
_NvRules.ISourceInfo_swigregister(ISourceInfo)
class SourceMarker(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    rule_identifier = property(_NvRules.SourceMarker_rule_identifier_get, _NvRules.SourceMarker_rule_identifier_set)
    section_identifier = property(_NvRules.SourceMarker_section_identifier_get, _NvRules.SourceMarker_section_identifier_set)
    kind = property(_NvRules.SourceMarker_kind_get, _NvRules.SourceMarker_kind_set)
    message_type = property(_NvRules.SourceMarker_message_type_get, _NvRules.SourceMarker_message_type_set)
    message = property(_NvRules.SourceMarker_message_get, _NvRules.SourceMarker_message_set)
    source_location = property(_NvRules.SourceMarker_source_location_get, _NvRules.SourceMarker_source_location_set)
    source_address = property(_NvRules.SourceMarker_source_address_get, _NvRules.SourceMarker_source_address_set)

    def __init__(self):
        _NvRules.SourceMarker_swiginit(self, _NvRules.new_SourceMarker())
    __swig_destroy__ = _NvRules.delete_SourceMarker

# Register SourceMarker in _NvRules:
_NvRules.SourceMarker_swigregister(SourceMarker)
class IRuleResult(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IRuleResult

    def rule_identifier(self):
        return _NvRules.IRuleResult_rule_identifier(self)

    def name(self):
        return _NvRules.IRuleResult_name(self)

    def section_identifier(self):
        return _NvRules.IRuleResult_section_identifier(self)

    def has_rule_message(self):
        return _NvRules.IRuleResult_has_rule_message(self)

    def rule_message(self):
        return _NvRules.IRuleResult_rule_message(self)

    def focus_metrics(self):
        return _NvRules.IRuleResult_focus_metrics(self)

    def has_speedup_estimation(self):
        return _NvRules.IRuleResult_has_speedup_estimation(self)

    def speedup_estimation(self):
        return _NvRules.IRuleResult_speedup_estimation(self)

    def result_tables(self):
        return _NvRules.IRuleResult_result_tables(self)

# Register IRuleResult in _NvRules:
_NvRules.IRuleResult_swigregister(IRuleResult)
class IMetric(object):
    r"""

    Represents a single, named metric. An :class:`IMetric` can carry one value
    or multiple ones if it is an instanced metric.

    Attributes:
        MetricType_OTHER (:class:`int`): Metric type for metrics that do not fit
            in any other category.
        MetricType_COUNTER (:class:`int`): Metric type for counter metrics.
        MetricType_RATIO (:class:`int`): Metric type for ratio metrics.
        MetricType_THROUGHPUT (:class:`int`): Metric type for throughput
            metrics.

        MetricSubtype_NONE (:class:`int`): Metric subtype for metrics that do
            not have a subtype.
        MetricSubtype_PEAK_SUSTAINED (:class:`int`): Metric subtype for peak
            sustained metrics.
        MetricSubtype_PEAK_SUSTAINED_ACTIVE (:class:`int`): Metric subtype for
            peak sustained active metrics.
        MetricSubtype_PEAK_SUSTAINED_ACTIVE_PER_SECOND (:class:`int`): Metric
            subtype for peak sustained active per-second metrics.
        MetricSubtype_PEAK_SUSTAINED_ELAPSED (:class:`int`): Metric subtype for
            peak sustained elapsed metrics.
        MetricSubtype_PEAK_SUSTAINED_ELAPSED_PER_SECOND (:class:`int`): Metric
            subtype for peak sustained elapsed per-second metrics.
        MetricSubtype_PER_CYCLE_ACTIVE (:class:`int`): Metric subtype for
            per-cycle active metrics.
        MetricSubtype_PER_CYCLE_ELAPSED (:class:`int`): Metric subtype for
            per-cycle elapsed metrics.
        MetricSubtype_PER_SECOND (:class:`int`): Metric subtype for per-second
            metrics.
        MetricSubtype_PCT_OF_PEAK_SUSTAINED_ACTIVE (:class:`int`): Metric
            subtype for percentage of peak sustained active metrics.
        MetricSubtype_PCT_OF_PEAK_SUSTAINED_ELAPSED (:class:`int`): Metric
            subtype for percentage of peak sustained elapsed metrics.
        MetricSubtype_MAX_RATE (:class:`int`): Metric subtype for max rate
            metrics.
        MetricSubtype_PCT (:class:`int`): Metric subtype for percentage metrics.
        MetricSubtype_RATIO (:class:`int`): Metric subtype for ratio metrics.

        RollupOperation_NONE (:class:`int`): No rollup operation.
        RollupOperation_AVG (:class:`int`): Average rollup operation.
        RollupOperation_MAX (:class:`int`): Maximum rollup operation.
        RollupOperation_MIN (:class:`int`): Minimum rollup operation.
        RollupOperation_SUM (:class:`int`): Sum rollup operation.

        ValueKind_UNKNOWN (:class:`int`): Unknown value kind.
        ValueKind_ANY (:class:`int`): Undefined value kind.
        ValueKind_STRING (:class:`int`): String value kind.
        ValueKind_FLOAT (:class:`int`): Float value kind.
        ValueKind_DOUBLE (:class:`int`): Double value kind.
        ValueKind_UINT32 (:class:`int`): Unsigned 32-bit integer value kind.
        ValueKind_UINT64 (:class:`int`): Unsigned 64-bit integer value kind.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    ValueKind_UNKNOWN = _NvRules.IMetric_ValueKind_UNKNOWN
    ValueKind_ANY = _NvRules.IMetric_ValueKind_ANY
    ValueKind_STRING = _NvRules.IMetric_ValueKind_STRING
    ValueKind_FLOAT = _NvRules.IMetric_ValueKind_FLOAT
    ValueKind_DOUBLE = _NvRules.IMetric_ValueKind_DOUBLE
    ValueKind_UINT32 = _NvRules.IMetric_ValueKind_UINT32
    ValueKind_UINT64 = _NvRules.IMetric_ValueKind_UINT64
    MetricType_OTHER = _NvRules.IMetric_MetricType_OTHER
    MetricType_COUNTER = _NvRules.IMetric_MetricType_COUNTER
    MetricType_RATIO = _NvRules.IMetric_MetricType_RATIO
    MetricType_THROUGHPUT = _NvRules.IMetric_MetricType_THROUGHPUT
    MetricSubtype_NONE = _NvRules.IMetric_MetricSubtype_NONE
    MetricSubtype_PEAK_SUSTAINED = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED
    MetricSubtype_PEAK_SUSTAINED_ACTIVE = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_ACTIVE
    MetricSubtype_PEAK_SUSTAINED_ACTIVE_PER_SECOND = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_ACTIVE_PER_SECOND
    MetricSubtype_PEAK_SUSTAINED_ELAPSED = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_ELAPSED
    MetricSubtype_PEAK_SUSTAINED_ELAPSED_PER_SECOND = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_ELAPSED_PER_SECOND
    MetricSubtype_PEAK_SUSTAINED_FRAME = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_FRAME
    MetricSubtype_PEAK_SUSTAINED_FRAME_PER_SECOND = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_FRAME_PER_SECOND
    MetricSubtype_PEAK_SUSTAINED_REGION = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_REGION
    MetricSubtype_PEAK_SUSTAINED_REGION_PER_SECOND = _NvRules.IMetric_MetricSubtype_PEAK_SUSTAINED_REGION_PER_SECOND
    MetricSubtype_PER_CYCLE_ACTIVE = _NvRules.IMetric_MetricSubtype_PER_CYCLE_ACTIVE
    MetricSubtype_PER_CYCLE_ELAPSED = _NvRules.IMetric_MetricSubtype_PER_CYCLE_ELAPSED
    MetricSubtype_PER_CYCLE_IN_FRAME = _NvRules.IMetric_MetricSubtype_PER_CYCLE_IN_FRAME
    MetricSubtype_PER_CYCLE_IN_REGION = _NvRules.IMetric_MetricSubtype_PER_CYCLE_IN_REGION
    MetricSubtype_PER_SECOND = _NvRules.IMetric_MetricSubtype_PER_SECOND
    MetricSubtype_PCT_OF_PEAK_SUSTAINED_ACTIVE = _NvRules.IMetric_MetricSubtype_PCT_OF_PEAK_SUSTAINED_ACTIVE
    MetricSubtype_PCT_OF_PEAK_SUSTAINED_ELAPSED = _NvRules.IMetric_MetricSubtype_PCT_OF_PEAK_SUSTAINED_ELAPSED
    MetricSubtype_PCT_OF_PEAK_SUSTAINED_FRAME = _NvRules.IMetric_MetricSubtype_PCT_OF_PEAK_SUSTAINED_FRAME
    MetricSubtype_PCT_OF_PEAK_SUSTAINED_REGION = _NvRules.IMetric_MetricSubtype_PCT_OF_PEAK_SUSTAINED_REGION
    MetricSubtype_MAX_RATE = _NvRules.IMetric_MetricSubtype_MAX_RATE
    MetricSubtype_PCT = _NvRules.IMetric_MetricSubtype_PCT
    MetricSubtype_RATIO = _NvRules.IMetric_MetricSubtype_RATIO
    RollupOperation_NONE = _NvRules.IMetric_RollupOperation_NONE
    RollupOperation_AVG = _NvRules.IMetric_RollupOperation_AVG
    RollupOperation_MAX = _NvRules.IMetric_RollupOperation_MAX
    RollupOperation_MIN = _NvRules.IMetric_RollupOperation_MIN
    RollupOperation_SUM = _NvRules.IMetric_RollupOperation_SUM
    __swig_destroy__ = _NvRules.delete_IMetric

    def name(self):
        r"""

        Get the metric name.

        Returns:
            :class:`str`: The metric name.

        """
        return _NvRules.IMetric_name(self)

    def metric_type(self):
        r"""

        Get the metric type.

        Returns:
            :class:`int`: The metric type.

        """
        return _NvRules.IMetric_metric_type(self)

    def metric_subtype(self):
        r"""

        Get the metric subtype.

        Returns:
            :class:`int`: The metric subtype.

        """
        val = _NvRules.IMetric_metric_subtype(self)

        if val == self.MetricSubtype_NONE:
            return None


        return val


    def rollup_operation(self):
        r"""

        Get the type of rollup operation for this metric.

        Returns:
            :class:`int`: The rollup operation type.

        """
        val = _NvRules.IMetric_rollup_operation(self)

        if val == self.RollupOperation_NONE:
            return None


        return val


    def unit(self):
        r"""

        Get the metric unit.

        Returns:
            :class:`str`: The metric unit.

        """
        return _NvRules.IMetric_unit(self)

    def description(self):
        r"""

        Get the metric description.

        Returns:
            :class:`str`: The description of the metric.

        """
        return _NvRules.IMetric_description(self)

    def kind(self, *args):
        r"""

        Get the metric or metric instance value kind.

        Args:
            instance (:class:`int`, optional): If provided, the index of the
                instance metric to get the value kind for.

        Returns:
            :class:`int`: The metric or metric instance value kind.

        """
        return _NvRules.IMetric_kind(self, *args)

    def has_value(self, *args):
        r"""

        Check if the metric or metric instance has a value.

        Args:
            instance (:class:`int`, optional): If provided, the index of the
                instance metric to check.

        Returns:
            :class:`bool`: :data:`True` if the metric or metric instance has a
            value, :data:`False`` otherwise.

        """
        return _NvRules.IMetric_has_value(self, *args)

    def as_double(self, *args):
        r"""

        Get the metric value or metric instance value as a :class:`float`.

        Args:
            instance (:class:`int`, optional): If provided, the index of the
                instance value to retrieve instead a metric value.

        Returns:
            :class:`float`: The metric value or metric instance value requested. If
            the value cannot be casted to a :class:`float`, this function will
            return ``0.``.

        """
        return _NvRules.IMetric_as_double(self, *args)

    def as_uint64(self, *args):
        r"""

        Get the metric value or metric instance value as an :class:`int`.

        Args:
            instance (:class:`int`, optional): If provided, the index of the
                instance value to retrieve instead a metric value.

        Returns:
            :class:`int`: The metric value or metric instance value requested. If
            the value cannot be casted to a :class:`int`, this function will
            return ``0``.

        """
        return _NvRules.IMetric_as_uint64(self, *args)

    def as_string(self, *args):
        r"""

        Get the metric value or metric instance value as a :class:`str`.

        Args:
            instance (:class:`int`, optional): If provided, the index of the
                instance value to retrieve instead a metric value.

        Returns:
            :class:`str` | :data:`None`: The metric value or metric instance value
            requested. If the value cannot be casted to a :class:`str`, this
            function will return :data:`None`.

        """
        return _NvRules.IMetric_as_string(self, *args)

    def num_instances(self):
        r"""

        Get the number of instance values for this metric.

        Not all metrics have instance values. If a metric has instance values, it
        may also have :meth:`IMetric.correlation_ids` matching these instance
        values.

        Returns:
            :class:`int`: The number of instances for this metric.

        """
        return _NvRules.IMetric_num_instances(self)

    def has_correlation_ids(self):
        r"""

        Check if the metric has correlation IDs.

        Returns:
            :class:`bool`: :data:`True` if the metric has correlation IDs matching
            its instance values, :data:`False` otherwise.

        """
        return _NvRules.IMetric_has_correlation_ids(self)

    def correlation_ids(self):
        r"""

        Get a metric object for this metric's instance value's correlation IDs.

        Returns a new :class:`IMetric` representing the correlation IDs for the
        metric's instance values. Use :meth:`IMetric.has_correlation_ids` to check
        if this metric has correlation IDs for its instance values. Correlation IDs
        are used to associate instance values with the instance their value
        represents. In the returned new metric object, the correlation IDs are that
        object's instance values.

        If the metric does not have any correlation IDs, this function will return
        :data:`None`.

        Returns:
            :class:`IMetric` | :data:`None`: The new :class:`IMetric` object
            representing the correlation IDs for this metric's instance values or
            :data:`None` if the metric has no correlation IDs.

        """
        return _NvRules.IMetric_correlation_ids(self)

    def __str__(self):
        """Get a human-readable representation of this :class:`IMetric`.

        Returns:
            :class:`str`: The name of the :class:`IMetric`.
        """
        return self.name()


    def value(self, idx=None):
        """Get the value of this :class:`IMetric`.

        This is a convenience function that will wrap the logic of invoking the
        correct ``IMetric.as_*`` method based on the value kind of this
        :class:`IMetric`.

        Args:
            idx (:class:`int`, optional): The index of the value to get.

        Returns:
            :class:`str` | :class:`int` | :class:`float` | :data:`None`: The
            value of this :class:`IMetric` as :class:`str`, :class:`int` or
            :class:`float`. If no value is available, this will return
            :data:`None`.
        """
        kind_to_value_func = {
            IMetric.ValueKind_ANY: lambda *args: None,
            IMetric.ValueKind_DOUBLE: IMetric.as_double,
            IMetric.ValueKind_FLOAT: IMetric.as_double,
            IMetric.ValueKind_STRING: IMetric.as_string,
            IMetric.ValueKind_UINT32: IMetric.as_uint64,
            IMetric.ValueKind_UINT64: IMetric.as_uint64,
            IMetric.ValueKind_UNKNOWN: lambda *args: None,
        }

        args = tuple() if idx is None else (idx,)
        return kind_to_value_func[self.kind(*args)](self, *args)


# Register IMetric in _NvRules:
_NvRules.IMetric_swigregister(IMetric)
class INvtxRange(object):
    r"""

    Represents a single NVTX Push/Pop or Start/End range.

    Attributes:
        PayloadType_PAYLOAD_UNKNOWN (:class:`int`): Payload type for ranges of unknown type.
        PayloadType_PAYLOAD_INT32 (:class:`int`): Payload type for ranges of INT32 type.
        PayloadType_PAYLOAD_INT64 (:class:`int`): Payload type for ranges of INT64 type.
        PayloadType_PAYLOAD_UINT32 (:class:`int`): Payload type for ranges of UINT32 type.
        PayloadType_PAYLOAD_UINT64 (:class:`int`): Payload type for ranges of UINT64 type.
        PayloadType_PAYLOAD_FLOAT (:class:`int`): Payload type for ranges of float type.
        PayloadType_PAYLOAD_DOUBLE (:class:`int`): Payload type for ranges of double type .
        PayloadType_PAYLOAD_JSON (:class:`int`): Payload type for ranges of JSON type.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    PayloadType_PAYLOAD_UNKNOWN = _NvRules.INvtxRange_PayloadType_PAYLOAD_UNKNOWN
    PayloadType_PAYLOAD_UINT64 = _NvRules.INvtxRange_PayloadType_PAYLOAD_UINT64
    PayloadType_PAYLOAD_INT64 = _NvRules.INvtxRange_PayloadType_PAYLOAD_INT64
    PayloadType_PAYLOAD_DOUBLE = _NvRules.INvtxRange_PayloadType_PAYLOAD_DOUBLE
    PayloadType_PAYLOAD_UINT32 = _NvRules.INvtxRange_PayloadType_PAYLOAD_UINT32
    PayloadType_PAYLOAD_INT32 = _NvRules.INvtxRange_PayloadType_PAYLOAD_INT32
    PayloadType_PAYLOAD_FLOAT = _NvRules.INvtxRange_PayloadType_PAYLOAD_FLOAT
    PayloadType_PAYLOAD_JSON = _NvRules.INvtxRange_PayloadType_PAYLOAD_JSON
    __swig_destroy__ = _NvRules.delete_INvtxRange

    def name(self):
        r"""

        Get the range's name.

        Returns:
            :class:`str`: The range's name.

        """
        return _NvRules.INvtxRange_name(self)

    def has_attributes(self):
        r"""

        Check if range has event attributes.

        Returns:
            :class:`bool`: :data:`True` if the range has event attributes,
            :data:`False` otherwise.

        """
        return _NvRules.INvtxRange_has_attributes(self)

    def category(self):
        r"""

        Get the category attribute value.

        Returns:
            :class:`int`: The category attribute value. If
            :meth:`INvtxRange.has_attributes` returns :data:`False`, this will
            return ``0``.

        """
        return _NvRules.INvtxRange_category(self)

    def color(self):
        r"""

        Get the color attribute value.

        Returns:
            :class:`int`: The color attribute value. If
            :meth:`INvtxRange.has_attributes` returns :data:`False`, this will
            return ``0``.

        """
        return _NvRules.INvtxRange_color(self)

    def payload_type(self):
        r"""

        Get the payload type as an :class:`int`.

        Returns:
            :class:`int`: The payload type.

        """
        return _NvRules.INvtxRange_payload_type(self)

    def payload_as_uint64(self):
        r"""

        Get the payload attribute value as an :class:`int`.

        Returns:
            :class:`int`: The payload attribute's value as a :class:`int`. If
            the value cannot be casted to a :class:`int`, this function will
            return ``0``.

        """
        return _NvRules.INvtxRange_payload_as_uint64(self)

    def payload_as_double(self):
        r"""

        Get the payload attribute value as a :class:`float`.

        Returns:
            :class:`float`: The payload attribute's value as a :class:`float`. If
            the value cannot be casted to a :class:`float`, this function will
            return ``0.``.

        """
        return _NvRules.INvtxRange_payload_as_double(self)

    def payload_as_string(self):
        r"""

        Get the payload attribute value as a :class:`str`.

        Returns:
            :class:`str`: The payload attribute's value as a :class:`str`. If
            the value cannot be casted to a :class:`str`, this function will
            return the empty string.

        """
        return _NvRules.INvtxRange_payload_as_string(self)

    def message(self):
        r"""

        Get the message attribute value.

        Returns:
            :class:`str`: The message attribute value. If
            :meth:`INvtxRange.has_attributes` returns :data:`False`, this will
            return the empty string.

        """
        return _NvRules.INvtxRange_message(self)

# Register INvtxRange in _NvRules:
_NvRules.INvtxRange_swigregister(INvtxRange)
class INvtxDomainInfo(object):
    r"""

    Represents a single NVTX domain of the NVTX state, including all ranges
    associated with this domain.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_INvtxDomainInfo

    def name(self):
        r"""

        Get a human-readable representation of this :class:`INvtxDomainInfo`.

        Returns:
            :class:`str`: The name of the :class:`INvtxDomainInfo`.

        """
        return _NvRules.INvtxDomainInfo_name(self)

    def push_pop_ranges(self):
        r"""

        Get a sorted list of push/pop range names.

        Get the sorted list of stacked push/pop range names in this domain,
        associated with the current :class:`INvtxState`.

        Returns:
            :class:`tuple` of :class:`str`: The sorted names of all push/pop ranges.

        """
        return _NvRules.INvtxDomainInfo_push_pop_ranges(self)

    def push_pop_range(self, idx):
        r"""

        Get a push/pop range object by index.

        The index is identical to the range's order on the call stack.

        Returns:
            :class:`INvtxRange` | :data:`None`: The requested :class:`INvtxRange` or
            :data:`None` if the index is out of range.

        """
        return _NvRules.INvtxDomainInfo_push_pop_range(self, idx)

    def start_end_ranges(self):
        r"""

        Get a sorted list of start/end range names.

        Get the sorted list of start/end range names in this domain, associated with
        the current :class:`INvtxState`.

        Returns:
            :class:`tuple` of :class:`str`: The sorted names of all start/end ranges.

        """
        return _NvRules.INvtxDomainInfo_start_end_ranges(self)

    def start_end_range(self, idx):
        r"""

        Get a start/end range object by index.

        Returns:
            :class:`INvtxRange` | :data:`None`: The requested :class:`INvtxRange` or
            :data:`None` if the index is out of range.

        """
        return _NvRules.INvtxDomainInfo_start_end_range(self, idx)

    def __str__(self):
        """Get a human-readable representation of this :class:`INvtxDomainInfo`.

        Returns:
            :class:`str`: The name of the :class:`INvtxDomainInfo`.

        """
        return self.name()


# Register INvtxDomainInfo in _NvRules:
_NvRules.INvtxDomainInfo_swigregister(INvtxDomainInfo)
class INvtxState(object):
    r"""

    Represents the NVTX (Nvidia Tools Extensions) state associated with a single
    :class:`IAction`.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_INvtxState

    def domains(self):
        r"""

        Get the list of domain IDs in this state.

        Returns:
            :class:`tuple` of :class:`int`: The tuple of valid domain IDs.

        """
        return _NvRules.INvtxState_domains(self)

    def domain_by_id(self, id):
        r"""

        Get a :class:`INvtxDomainInfo` object by ID.

        Use :meth:`INvtxState.domains` to retrieve the list of valid domain IDs.

        Args:
            id (:class:`int`): The ID of the request domain.

        Returns:
            :class:`INvtxDomainInfo` | :data:`None`: The requested
            :class:`INvtxDomainInfo` object.

        """
        return _NvRules.INvtxState_domain_by_id(self, id)

    def __len__(self):
        """Get the number of :class:`INvtxDomainInfo` objects of this
        :class:`INvtxState`.

        Returns:
            :class:`int`: The number of :class:`INvtxDomainInfo` objects.

        """
        return len(self.domains())


    def __iter__(self):
        """Get an :term:`iterator` over the :class:`INvtxDomainInfo` objects of this
        :class:`INvtxState`.

        Returns:
            :term:`iterator`: An :term:`iterator` over the
            :class:`INvtxDomainInfo` objects.

        """
        return iter(self.domains())


    def __getitem__(self, key):
        """Get an :class:`INvtxDomainInfo` object by ID.

        Args:
            key (:class:`int`): The ID of the :class:`INvtxDomainInfo` object.

        Returns:
            :class:`INvtxDomainInfo`: An :class:`INvtxDomainInfo` object.

        Raises:
            :exc:`TypeError`: If ``key`` is not of type :class:`int`.
            :exc:`KeyError`: If ``key`` is not a valid ID.

        """
        if isinstance(key, int):
            if key not in self.domains():
                raise KeyError("INvtxState invalid ID")
            return self.domain_by_id(key)
        raise TypeError(
            "INvtxState IDs must be integers, not {}".format(
                type(key).__name__
            )
        )


# Register INvtxState in _NvRules:
_NvRules.INvtxState_swigregister(INvtxState)
class IAction(object):
    r"""

    The :class:`IAction` represents a profile result such as a CUDA kernel in a
    single range or a range itself in range-based profiling, for which zero or
    more metrics were collected.

    Attributes:
        NameBase_DEMANGLED (:class:`int`): Name base for demangled names.
        NameBase_FUNCTION (:class:`int`): Name base for function signature
            names.
        NameBase_MANGLED (:class:`int`): Name base for mangled names.

        WorkloadType_CMDLIST (:class:`int`): Workload type for CBL command
            lists.
        WorkloadType_GRAPH (:class:`int`): Workload type for CUDA graphs.
        WorkloadType_KERNEL (:class:`int`): Workload type for CUDA kernels or
            CUDA graph kernel nodes.
        WorkloadType_RANGE (:class:`int`): Workload type for result ranges.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    NameBase_FUNCTION = _NvRules.IAction_NameBase_FUNCTION
    NameBase_DEMANGLED = _NvRules.IAction_NameBase_DEMANGLED
    NameBase_MANGLED = _NvRules.IAction_NameBase_MANGLED
    WorkloadType_KERNEL = _NvRules.IAction_WorkloadType_KERNEL
    WorkloadType_RANGE = _NvRules.IAction_WorkloadType_RANGE
    WorkloadType_CMDLIST = _NvRules.IAction_WorkloadType_CMDLIST
    WorkloadType_GRAPH = _NvRules.IAction_WorkloadType_GRAPH
    __swig_destroy__ = _NvRules.delete_IAction

    def name(self, *args):
        r"""

        Get the name of the result the :class:`IAction` object represents.

        Args:
            name_base (:class:`int`, optional): The desired name base. Defaults to
                :data:`NameBase_FUNCTION`.

        Returns:
            :class:`str`: The name of the result (potentially in a specific name base).

        """
        return _NvRules.IAction_name(self, *args)

    def workload_type(self):
        r"""

        Get the workload type of the action.

        Returns:
            :class:`int`: The workload type.

        """
        return _NvRules.IAction_workload_type(self)

    def metric_by_name(self, metric_name):
        r"""

        Get a single :class:`IMetric` by name.

        Args:
            metric_name (:class:`str`): The name of the :class:`IMetric` to retrieve.

        Returns:
            :class:`IMetric` | :data:`None`: The :class:`IMetric` object or
            :data:`None` if no such metric exists.

        """
        return _NvRules.IAction_metric_by_name(self, metric_name)

    def metric_names(self):
        r"""

        Get the names of all metrics of this :class:`IAction`.

        Returns:
            :class:`tuple` of :class:`str`: The names of all metrics.

        """
        return _NvRules.IAction_metric_names(self)

    def add_integer_metric(self, value_name, value_kind, value):
        return _NvRules.IAction_add_integer_metric(self, value_name, value_kind, value)

    def add_double_metric(self, value_name, value_kind, value):
        return _NvRules.IAction_add_double_metric(self, value_name, value_kind, value)

    def add_string_metric(self, value_name, value_kind, value):
        return _NvRules.IAction_add_string_metric(self, value_name, value_kind, value)

    def add_metric(self, value_name):
        return _NvRules.IAction_add_metric(self, value_name)

    def source_info(self, address):
        r"""

        Get the source info for a function address within this action.

        Addresses are commonly obtained as correlation IDs of source-correlated
        metrics.

        Args:
            address (:class:`int`): The address to get source info for.

        Returns:
            :class:`ISourceInfo` | :data:`None`: The :class:`ISourceInfo` associated
            to the given address. If no source info is available, :data:`None` is
            returned.

        """
        return _NvRules.IAction_source_info(self, address)

    def source_files(self):
        r"""

        Get the source files associated with this action along with their content.

        If content is not available for a file (e.g. because it hadn't been imported
        into the report), the file name will map to an empty string.

        Returns:
            :class:`dict` of :class:`str` to :class:`str`: A dictionary mapping
            source files to their content.

        """
        return _NvRules.IAction_source_files(self)

    def sass_by_pc(self, address):
        r"""

        Get the SASS associated with an address.

        Args:
            address (:class:`int`): The address to get SASS for.

        Returns:
            :class:`str`: The SASS associated with the given address. If no SASS is
            available, the empty string will be returned.

        """
        return _NvRules.IAction_sass_by_pc(self, address)

    def nvtx_state(self):
        r"""

        Get the NVTX state associated with this action.

        Returns:
            :class:`INvtxState` | :data:`None`: The associated :class:`INvtxState`
            or :data:`None` if no state is associated.

        """
        return _NvRules.IAction_nvtx_state(self)

    def ptx_by_pc(self, address):
        r"""

        Get the PTX associated with an address.

        Args:
            address (:class:`int`): The address to get PTX for.

        Returns:
            :class:`str`: The PTX associated with the given address. If no PTX is
            available, the empty string will be returned.

        """
        return _NvRules.IAction_ptx_by_pc(self, address)

    def source_markers(self):
        return _NvRules.IAction_source_markers(self)

    def rule_results(self):
        return _NvRules.IAction_rule_results(self)

    def __str__(self):
        """Get a human-readable representation of this :class:`IAction`.

        Returns:
            :class:`str`: The name of the kernel the :class:`IAction` object
            represents.
        """
        return self.name()


    def __len__(self):
        """Get the number of :class:`IMetric` objects of this :class:`IAction`.

        Returns:
            :class:`int`: The number of :class:`IMetric` objects.
        """
        return len(self.metric_names())


    def __iter__(self):
        """Get an :term:`iterator` over the metric names of this
        :class:`IAction`.

        Returns:
            :term:`iterator` of :class:`str`: An :term:`iterator` over the
            metric names.
        """
        return iter(self.metric_names())


    def __getitem__(self, key):
        """Get an :class:`IMetric` object contained in this :class:`IAction` by
        its name.

        Args:
            key (:class:`str`): The name of the :class:`IMetric` object to
                retrieve.

        Returns:
            :class:`IMetric`: An :class:`IMetric` object.

        Raises:
            :exc:`TypeError`: If ``key`` is not of type :class:`str`.
            :exc:`KeyError`: If ``key`` is not the name of any :class:`IMetric`
                object.
        """
        if not isinstance(key, str):
            raise TypeError(
                "IAction metric keys must be strings, not {}".format(type(key).__name__)
            )

        metric = self.metric_by_name(key)

        if metric is None:
            raise KeyError("no metric named '{}'".format(key))

        return metric


# Register IAction in _NvRules:
_NvRules.IAction_swigregister(IAction)
class IRange(object):
    r"""

    Represents a serial, ordered stream of execution, such as a CUDA stream. It
    holds one or more actions that were logically executing in this range.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IRange

    def num_actions(self):
        r"""

        Get the number of :class:`IAction` objects in this :class:`IRange`.

        Returns:
            :class:`int`: The number of class:`IAction` objects.

        """
        return _NvRules.IRange_num_actions(self)

    def action_by_idx(self, idx):
        r"""

        Get an :class:`IAction` objects by index.

        Args:
            key (:class:`int`): The index to retrieve.

        Returns:
            :class:`IAction` | :data:`None`: An :class:`IAction` object or
            :data:`None` if the index is out of range.

        """
        return _NvRules.IRange_action_by_idx(self, idx)

    def actions_by_nvtx(self, includes, excludes):
        r"""

        Get a set of indices to IAction objects by their NVTX state. The state is
        defined using a series of *includes* and *excludes*.

        Args:
            includes (:term:`iterable` of :class:`str`): The NVTX states the result
                should be part of.
            excludes (:term:`iterable` of :class:`str`): The NVTX states the result
                should not be part of.

        Returns:
            :class:`tuple` of :class:`int`: A :class:`tuple` of indices to
            :class:`IAction` matching the desired NVTX state.

        """
        return _NvRules.IRange_actions_by_nvtx(self, includes, excludes)

    def __len__(self):
        """Get the number of :class:`IAction` objects in this :class:`IRange`.

        Returns:
            :class:`int`: The number of class:`IAction` objects.
        """
        return self.num_actions()


    def __getitem__(self, key):
        """Get one or more :class:`IAction` objects by index or by
        :class:`slice`.

        Args:
            key (:class:`int` | :class:`slice`): The index or :class:`slice` to
                retrieve.

        Returns:
            :class:`IAction` | :class:`tuple` of :class:`IAction`: An
            :class:`IAction` object or a :class:`tuple` of :class:`IAction` objects.

        Raises:
            :exc:`TypeError`: If ``key`` is not of type :obj:`int` or
                :obj:`slice`.
            :exc:`IndexError`: If ``key`` is out of range for the
                :class:`IRange`.
        """
        _len = len(self)
        if isinstance(key, int):
            if key < -_len or key >= _len:
                raise IndexError("IRange index out of range")
            if key < 0:
                key += _len
            return self.action_by_idx(key)
        if isinstance(key, slice):
            return tuple(self[i] for i in range(*key.indices(_len)))
        raise TypeError(
            "IRange indices must be integers or slices, not {}".format(
                type(key).__name__
            )
        )


    def __iter__(self):
        """Get an :term:`iterator` over the :class:`IAction` objects of this
        class:`IRange`.

        Returns:
            :term:`iterator` of :class:`IAction`: An :term:`iterator` over the
            :class:`IAction` objects.
        """
        return (self[i] for i in range(len(self)))


# Register IRange in _NvRules:
_NvRules.IRange_swigregister(IRange)
class IFrontend(object):
    r"""

    The frontend is responsible for relaying messages and results to the caller
    via user interfaces, logs or output files.

    Deprecated Attributes and Their Replacement:
        MarkerKind_SASS - :attr:`MarkerKind.SASS`

        MarkerKind_SOURCE - :attr:`MarkerKind.SOURCE`

        MsgType_MSG_NONE - :attr:`MsgType.NONE`

        MsgType_MSG_OK - :attr:`MsgType.OK`

        MsgType_MSG_OPTIMIZATION - :attr:`MsgType.OPTIMIZATION`

        MsgType_MSG_WARNING - :attr:`MsgType.WARNING`

        MsgType_MSG_ERROR - :attr:`MsgType.ERROR`

    Attributes:
        Severity_SEVERITY_DEFAULT (:class:`int`): The default severity.
        Severity_SEVERITY_LOW (:class:`int`): Severity if low.
        Severity_SEVERITY_HIGH (:class:`int`): Severity if high.

        SpeedupType_LOCAL (:class:`int`): The proportional increase in efficiency of the
            hardware usage when viewing the performance problem in isolation.
        SpeedupType_GLOBAL (:class:`int`): The proportional reduction in runtime of the entire workload.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    Severity_SEVERITY_DEFAULT = _NvRules.IFrontend_Severity_SEVERITY_DEFAULT
    Severity_SEVERITY_LOW = _NvRules.IFrontend_Severity_SEVERITY_LOW
    Severity_SEVERITY_HIGH = _NvRules.IFrontend_Severity_SEVERITY_HIGH
    SpeedupType_LOCAL = _NvRules.IFrontend_SpeedupType_LOCAL
    SpeedupType_GLOBAL = _NvRules.IFrontend_SpeedupType_GLOBAL
    __swig_destroy__ = _NvRules.delete_IFrontend

    def message(self, *args):
        r"""

        Issues a message to the frontend.

        Args:
            type (:class:`int`, optional): The message type.
            str (:class:`str`): The message content.

                The message may contain substrings with the following special link formats:
                    - @url:<hypertext>:<external link>@ - To add a external link for a hypertext.
                    - @sass:<address>:<text>@ - To add a SASS address to the cell.
                    - @source:<file name>:<line number>:<hypertext>@ - To add a link to the hypertext to open the source file at the specified line number on the Source page.
                    - @section:<section identifier>:<hypertext>@ - To add a link to the hypertext to jump to the respective section.

            name (:class:`str`, optional): The name of the message.

        Returns:
            :class:`int`: A message ID that is unique in this rule invocation.

        """
        return _NvRules.IFrontend_message(self, *args)

    def _generate_table(self, message_id, table):
        return _NvRules.IFrontend__generate_table(self, message_id, table)

    def send_dict_to_children(self, dict):
        r"""

        Send a dictionary to all child rules.

        Sends a Python dictionary of type dict[str,float] to
        all rules that specify this rule as a parent rule.
        Child rules can retrieve the message using
        :meth:`IFrontend.receive_dict_from_parent`.
        In case this function is called repeatedly, the dict
        is updated accordingly, thereby adding new key-value pairs,
        and overwriting values of pre-existing keys.

        Args:
            dict (:class:`dict`): The dictionary to send.

        """
        return _NvRules.IFrontend_send_dict_to_children(self, dict)

    def receive_dict_from_parent(self, parent_id):
        r"""

        Receive a dictionary from a parent rule.

        Receive a dictionary of type dict[str,float] sent using
        :meth:`IFrontend.send_dict_to_children`.
        If the parent id does not represent a pre-specified
        parent rule of this rule, or in case the parent rule has
        not been executed, an empty dict will be returned.

        Args:
            parent_id (:class:`str`): ID of the pre-specified parent rule.

        Returns:
            :class:`dict`: The received dictionary.
                An empty dict if the parent rule has not been executed.

        """
        return _NvRules.IFrontend_receive_dict_from_parent(self, parent_id)

    def speedup(self, message_id, type, estimated_speedup):
        r"""

        Rule estimated speedup message.

        Issues an estimated speedup associated with a message to the frontend.

        Args:
            message_id (:class:`int`): ID of the existing message.
            type (:class:`int`): The SpeedupType.
                If GLOBAL, it indicates what proportional decrease in workload runtime
                could potentially be achieved, when following the guidelines of the rule.
                If LOCAL, it indicates what increase in the efficiency of the hardware
                usage within the context of the performance problem could be achieved.

        Returns:
            :class:`bool`: :data:`True` if the speedup could be set successfully,
                :data:`False` otherwise.

        """
        return _NvRules.IFrontend_speedup(self, message_id, type, estimated_speedup)

    def focus_metric(self, message_id, metric_name, metric_value, severity, info):
        r"""

        Create a rule focus metric message.

        Issues a focus metric message to the frontend, e.g. to indicate a key metric
        that triggered the rule output.

        Args:
            message_id (:class:`int`): The prior message to associate with.
            metric_name (:class:`str`): Name of the focus metric.
            metric_value (:class:`float`): Value of the focus metric.
            severity (:class:`int`): Indicates the impact orseverity on the result.
            info (:class:`str`): Descriptive string for further information, e.g.,
                the calculation leading to this metric being focused.

        Returns:
            :class:`bool`: :data:`True` if the focus metric could be set successfully,
                :data:`False` otherwise.

        """
        return _NvRules.IFrontend_focus_metric(self, message_id, metric_name, metric_value, severity, info)

    def source_marker(self, *args):
        r"""

        Create a rule source marker.

        Args:
            str (:class:`str`): The source marker message.
            address_or_line (:class:`int`): The source location in the appropriate kind of source.
            kind (:class:`int`): The the kind of source.
            file_name (:class:`str`, optional): The file name.
            type (:class:`int`, optional): The urgency associated with this marker.
                By default :attr:`MsgType.NONE`.

        """
        return _NvRules.IFrontend_source_marker(self, *args)

    def load_chart_from_file(self, filename):
        r"""

        Load a ProfilerSection google protocol buffer chart from a file.

        Args:
            filename (:class:`str`): The file name.

        """
        return _NvRules.IFrontend_load_chart_from_file(self, filename)
    MarkerKind_SASS = _NvRules.IFrontend_MarkerKind_SASS
    MarkerKind_SOURCE = _NvRules.IFrontend_MarkerKind_SOURCE
    MsgType_MSG_NONE = _NvRules.IFrontend_MsgType_MSG_NONE
    MsgType_MSG_OK = _NvRules.IFrontend_MsgType_MSG_OK
    MsgType_MSG_OPTIMIZATION = _NvRules.IFrontend_MsgType_MSG_OPTIMIZATION
    MsgType_MSG_WARNING = _NvRules.IFrontend_MsgType_MSG_WARNING
    MsgType_MSG_ERROR = _NvRules.IFrontend_MsgType_MSG_ERROR


    deprecated_attributes = {
        "MarkerKind_SASS": "MarkerKind.SASS",
        "MarkerKind_SOURCE": "MarkerKind.SOURCE",
        "MsgType_MSG_NONE": "MsgType.NONE",
        "MsgType_MSG_OK": "MsgType.OK",
        "MsgType_MSG_OPTIMIZATION": "MsgType.OPTIMIZATION",
        "MsgType_MSG_WARNING": "MsgType.WARNING",
        "MsgType_MSG_ERROR": "MsgType.ERROR",
    }

    def __getattribute__(self, name):
        if name in IFrontend.deprecated_attributes:
            warn(f"'IFrontend.{name}' is deprecated, use '{IFrontend.deprecated_attributes[name]}' instead.", DeprecationWarning, stacklevel=2)
        return super().__getattribute__(name)

    def generate_table(self, message_id, header, data, config=None):
        """Generate a table in the frontend.

        This function attaches a table to the pre-existing rule message given by `message_id`.
        It can be called multiple times to attach multiple tables to the same message.

        The table can be customized by passing a `dict` to the `config` parameter.
        The table can contain a title, description, a column to sort by, and a global styling.
        Additionally, the table can have per-column configurations, which can specify
        a header tooltip, relative column width, and styling for the header and data cells.

        This is an example of a valid `config` `dict`::

            config = {
                "title": "My table title",
                "description": "Short description of the table",
                "sort_by": {
                    "column": "MyColumn",  # specify column by name or index
                    "order": "ascending",  # in ascending order (default)
                },
                "per_column_configs": {  # overwrites global styling for individual columns
                    "MyColumn": {  # can use column name or index
                        "tooltip": "Explanation of MyColumn",  # tooltip for the header
                        "relative_width": 0.5,  # relative width of the column
                        "style": {
                            "header": {"bold": True},
                            "data": {"italic": True},
                        }
                    },
                },
            }

        Args:
            message_id (int): The message to which to attach the table to.
            header (list[str]): The column labels of the table.
            data (list[list[int | float | str | Any]]): The table data in row-major format.
                `Any` refers to any type that implements `__str__`.
                Each column must only have elements of the same type,
                and all columns must have the same length.

                :class:str values may contain substrings with the following special link formats:
                    - @url:<hypertext>:<external link>@ - To add a external link for a hypertext.
                    - @sass:<address>:<hypertext>@ - To add a link to the hypertext to open the SASS address line on the Source page.
                    - @source:<file name>:<line number>:<hypertext>@ - To add a link to the hypertext to open the source file at the specified line number on the Source page.
                    - @section:<section identifier>:<hypertext>@ - To add a link to the hypertext to jump to the respective section.

            config (dict[str, Any] | None): Configuration options for the table.
                Defaults to None.

        Raises:
            TypeError: If types of elements within a column are mixed.
            ValueError: If columns have different lengths, or len(header) does not match
                the number of columns in data.
        """
        data_by_column = _transpose_table_data(data)
        data_backend = _convert_data_to_backend_format(header, data_by_column, config)
        self._generate_table(message_id, data_backend)


# Register IFrontend in _NvRules:
_NvRules.IFrontend_swigregister(IFrontend)
class IBaseContext(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IBaseContext

    def handle_exception(self, msg):
        return _NvRules.IBaseContext_handle_exception(self, msg)

    def get_version(self):
        return _NvRules.IBaseContext_get_version(self)

# Register IBaseContext in _NvRules:
_NvRules.IBaseContext_swigregister(IBaseContext)
class IMessageVault(object):
    r"""

    Passes messages between rules.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IMessageVault

    def Put(self, ruleId, message):
        r"""

        Commit a message associated with a rule to the vault.

        In case multiple messages associated with the same rule are committed,
        the messages are merged, in such a way that new key-value pairs are added,
        and values of pre-existing keys are updated.

        Args:
            ruleId (:class:`str`): The identifier of the rule.
            message (:class:`dict`): The message to commit.

        """
        return _NvRules.IMessageVault_Put(self, ruleId, message)

    def Get(self, ruleId):
        r"""

        Retrieve the message associated with a rule from the vault.

        In case the rule is unknown, an empty message is returned.

        Args:
            ruleId (:class:`str`): The identifier of the rule.

        Returns:
            :class:`dict`: The message associated with the rule.

        """
        return _NvRules.IMessageVault_Get(self, ruleId)

# Register IMessageVault in _NvRules:
_NvRules.IMessageVault_swigregister(IMessageVault)
class IController(object):
    r"""

    Controller interface.

    The controller can be used to interact with the tool runtime, e.g.,
    to signal the tools to propose a follow-up rule.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IController

    def propose_rule(self, rule):
        r"""

        Propose the specified rule in the current context.

        Args:
            rule (:class:`str`): The proposed rule identifier.

        """
        return _NvRules.IController_propose_rule(self, rule)

    def get_message_vault(self):
        r"""

        Get an :class:`IMessageVault` object that can be used for message
        passing between rules.

        Returns:
            :class:`IMessageVault`

        """
        return _NvRules.IController_get_message_vault(self)

# Register IController in _NvRules:
_NvRules.IController_swigregister(IController)
class IEvaluator(IBaseContext):
    r"""

    Evaluator interface.

    The evaluator is used during rule setup to pass information about rule dependencies to the tool.
    For most cases, its Python wrapper functions :func:`require_metrics` and :func:`require_rules`
    should be used instead for convenience.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IEvaluator

    def require_metric(self, metric):
        r"""

        Define that the specified metric must have been collected in order
        for the calling rule to be applied.

        Args:
            metric (:class:`str`): The metric name to require.

        """
        return _NvRules.IEvaluator_require_metric(self, metric)

    def require_rule(self, rule):
        r"""

        Define that the specified rule must be available and ready to be applied
        in order for the calling rule to be applied itself.

        Args:
            rule (:class:`str`): The rule identifier to require.

        """
        return _NvRules.IEvaluator_require_rule(self, rule)

# Register IEvaluator in _NvRules:
_NvRules.IEvaluator_swigregister(IEvaluator)
class IContext(IBaseContext):
    r"""

    The :class:`IContext` class is the top-level object representing an open
    report.

    It can be created by calling the :func:`load_report` function.

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IContext

    def controller(self):
        r"""

        Get the controller object.

        Returns:
            :class:`IController`: The controller object.

        """
        return _NvRules.IContext_controller(self)

    def frontend(self):
        r"""

        Get the frontend object.

        Returns:
            :class:`IFrontend`: The frontend object.

        """
        return _NvRules.IContext_frontend(self)

    def num_ranges(self):
        r"""

        Get the number of :class:`IRange` objects in this :class:`IContext`.

        Returns:
            :class:`int`: The number of :class:`IRange` objects.

        """
        return _NvRules.IContext_num_ranges(self)

    def range_by_idx(self, idx):
        r"""

        Get an :class:`IRange` object by index.

        Args:
            key (:class:`int`): The index to retrieve.

        Returns:
            :class:`IRange` | :data:`None`: An :class:`IRange` object or
            :data:`None` if the index is out of range.

        """
        return _NvRules.IContext_range_by_idx(self, idx)

    def __len__(self):
        """Get the number of :class:`IRange` objects in this :class:`IContext`.

        Returns:
            :class:`int`: The number of :class:`IRange` objects.
        """
        return self.num_ranges()

    def __getitem__(self, key):
        """Get one or more :class:`IRange` objects by index or by slice.

        Args:
            key (:class:`int` | :class:`slice`): The index or slice to retrieve.

        Returns:
        :class:`IRange` | :class:`tuple` of :class:`IRange`: An :class:`IRange`
        object or a :class:`tuple` of :class:`IRange` objects.

        Raises:
            :exc:`TypeError`: If ``key`` is not of type :class:`int` or
                :class:`slice`.
            :exc:`IndexError`: If ``key`` is out of range for the
                :class:`IContext`.
        """
        _len = len(self)
        if isinstance(key, int):
            if key < -_len or key >= _len:
                raise IndexError("IContext index out of range")
            if key < 0:
                key += _len
            return self.range_by_idx(key)
        if isinstance(key, slice):
            return tuple(self[i] for i in range(*key.indices(_len)))
        raise TypeError(
            "IContext indices must be integers or slices, not {}".format(
                type(key).__name__
            )
        )


    def __iter__(self):
        """Get an :term:`iterator` over the :class:`IRange` objects of this
        :class:`IContext`.

        Returns:
            :term:`iterator` of :class:`IRange`: An :term:`iterator` over the
            :class:`IRange` objects.
        """
        return (self[i] for i in range(len(self)))


# Register IContext in _NvRules:
_NvRules.IContext_swigregister(IContext)
class IMutableMetric(IMetric):
    r"""

    Represents a single, named mutable metric. An :class:`IMutableMetric` can carry one value
    or multiple ones if it is an instanced metric.
    In comparison to :class:`IMetric`, :class:`IMutableMetric` can be modified by assigning
    it a new value and/or instance values. The metric kind is determined by the assigned value(s).

    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _NvRules.delete_IMutableMetric

    def set_double(self, *args):
        r"""

        Assign the metric an instance :class:`float` value.

        Args:
            instance (:class:`int`, optional): The instance to assign the value to.
            value_kind (:class:`int`): Acceptable kinds are FLOAT, DOUBLE or ANY
                (for which the implementation chooses the kind internally)
            value (:class:`float`): The value to assign.

        Returns:
            :class:`bool`: :data:`True` if the instance value was set, :data:`False` otherwise.

        """
        return _NvRules.IMutableMetric_set_double(self, *args)

    def set_uint64(self, *args):
        r"""

        Assign the metric a :class:`int` value.

        Args:
            instance (:class:`int`, optional): The instance to assign the value to.
            value_kind (:class:`int`): Acceptable kinds are UINT32, UINT64 or ANY
                (for which the implementation chooses the kind internally)
            value (:class:`int`): The value to assign.

        Returns:
            :class:`bool`: :data:`True` if the value was set, :data:`False` otherwise.

        """
        return _NvRules.IMutableMetric_set_uint64(self, *args)

    def set_string(self, *args):
        r"""

        Assign the metric an instance :class:`str` value.

        Args:
            instance (:class:`int`, optional): The instance to assign the value to.
            value_kind (:class:`int`): Acceptable kinds are STRING or ANY
                (for which the implementation chooses the kind internally)
            value (:class:`str`): The value to assign.

        Returns:
            :class:`bool`: :data:`True` if the instance value was set, :data:`False` otherwise.

        """
        return _NvRules.IMutableMetric_set_string(self, *args)

    def mutable_correlation_ids(self):
        r"""

        Get a mutable metric object for this metric's instance value's correlation IDs.

        Returns a new :class:`IMutableMetric` representing the correlation IDs for the
        metric's instance values. Correlation IDs are used to associate instance values
        with the instance their value represents. In the returned new metric object,
        the correlation IDs are that object's instance values.

        Returns:
            :class:`IMutableMetric`: The new :class:`IMutableMetric` object
            representing the correlation IDs for this metric's instance values.

        """
        return _NvRules.IMutableMetric_mutable_correlation_ids(self)

# Register IMutableMetric in _NvRules:
_NvRules.IMutableMetric_swigregister(IMutableMetric)
TableElementKind_INVALID = _NvRules.TableElementKind_INVALID
TableElementKind_DOUBLE = _NvRules.TableElementKind_DOUBLE
TableElementKind_INT = _NvRules.TableElementKind_INT
TableElementKind_STRING = _NvRules.TableElementKind_STRING
TableElementKind_CUSTOM = _NvRules.TableElementKind_CUSTOM
class TableSortInfo(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    column = property(_NvRules.TableSortInfo_column_get, _NvRules.TableSortInfo_column_set)
    is_ascending = property(_NvRules.TableSortInfo_is_ascending_get, _NvRules.TableSortInfo_is_ascending_set)

    def __init__(self):
        _NvRules.TableSortInfo_swiginit(self, _NvRules.new_TableSortInfo())
    __swig_destroy__ = _NvRules.delete_TableSortInfo

# Register TableSortInfo in _NvRules:
_NvRules.TableSortInfo_swigregister(TableSortInfo)
class TableStyle(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    is_bold = property(_NvRules.TableStyle_is_bold_get, _NvRules.TableStyle_is_bold_set)
    is_italic = property(_NvRules.TableStyle_is_italic_get, _NvRules.TableStyle_is_italic_set)

    def __init__(self):
        _NvRules.TableStyle_swiginit(self, _NvRules.new_TableStyle())
    __swig_destroy__ = _NvRules.delete_TableStyle

# Register TableStyle in _NvRules:
_NvRules.TableStyle_swigregister(TableStyle)
class TableColumnConfig(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    tooltip = property(_NvRules.TableColumnConfig_tooltip_get, _NvRules.TableColumnConfig_tooltip_set)
    relative_width = property(_NvRules.TableColumnConfig_relative_width_get, _NvRules.TableColumnConfig_relative_width_set)
    header_style = property(_NvRules.TableColumnConfig_header_style_get, _NvRules.TableColumnConfig_header_style_set)
    data_style = property(_NvRules.TableColumnConfig_data_style_get, _NvRules.TableColumnConfig_data_style_set)

    def __init__(self):
        _NvRules.TableColumnConfig_swiginit(self, _NvRules.new_TableColumnConfig())
    __swig_destroy__ = _NvRules.delete_TableColumnConfig

# Register TableColumnConfig in _NvRules:
_NvRules.TableColumnConfig_swigregister(TableColumnConfig)
class TableConfig(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    title = property(_NvRules.TableConfig_title_get, _NvRules.TableConfig_title_set)
    description = property(_NvRules.TableConfig_description_get, _NvRules.TableConfig_description_set)
    use_sorting = property(_NvRules.TableConfig_use_sorting_get, _NvRules.TableConfig_use_sorting_set)
    sort_by = property(_NvRules.TableConfig_sort_by_get, _NvRules.TableConfig_sort_by_set)
    use_styling = property(_NvRules.TableConfig_use_styling_get, _NvRules.TableConfig_use_styling_set)
    style = property(_NvRules.TableConfig_style_get, _NvRules.TableConfig_style_set)

    def __init__(self):
        _NvRules.TableConfig_swiginit(self, _NvRules.new_TableConfig())
    __swig_destroy__ = _NvRules.delete_TableConfig

# Register TableConfig in _NvRules:
_NvRules.TableConfig_swigregister(TableConfig)
class TableColumn(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_NvRules.TableColumn_name_get, _NvRules.TableColumn_name_set)
    kind = property(_NvRules.TableColumn_kind_get, _NvRules.TableColumn_kind_set)
    double_values = property(_NvRules.TableColumn_double_values_get, _NvRules.TableColumn_double_values_set)
    int_values = property(_NvRules.TableColumn_int_values_get, _NvRules.TableColumn_int_values_set)
    string_values = property(_NvRules.TableColumn_string_values_get, _NvRules.TableColumn_string_values_set)
    has_column_config = property(_NvRules.TableColumn_has_column_config_get, _NvRules.TableColumn_has_column_config_set)
    column_config = property(_NvRules.TableColumn_column_config_get, _NvRules.TableColumn_column_config_set)

    def size(self):
        return _NvRules.TableColumn_size(self)

    def __init__(self):
        _NvRules.TableColumn_swiginit(self, _NvRules.new_TableColumn())
    __swig_destroy__ = _NvRules.delete_TableColumn

# Register TableColumn in _NvRules:
_NvRules.TableColumn_swigregister(TableColumn)
class TableData(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    columns = property(_NvRules.TableData_columns_get, _NvRules.TableData_columns_set)
    has_config = property(_NvRules.TableData_has_config_get, _NvRules.TableData_has_config_set)
    config = property(_NvRules.TableData_config_get, _NvRules.TableData_config_set)

    def __init__(self):
        _NvRules.TableData_swiginit(self, _NvRules.new_TableData())
    __swig_destroy__ = _NvRules.delete_TableData

# Register TableData in _NvRules:
_NvRules.TableData_swigregister(TableData)

def get_version(h):
    r"""

    Get version number of this interface.

    Args:
        h (:class:`int`): The context handle.

    Returns:
        :class:`str`: Returns the version number of this interface
        as a string of the form <year>.<major>.<minor>.
        It matches the Nsight Compute version this interface originates from.

    """
    return _NvRules.get_version(h)

def get_context(h):
    r"""

    Return the :class:`IContext` object from the context handle.

    Args:
        h (:class:`int`): The context handle.

    Returns:
        :class:`IContext`: The evaluator object.

    """
    return _NvRules.get_context(h)

def get_evaluator(h):
    r"""

    Return the :class:`IEvaluator` object from the context handle.

    Args:
        h (:class:`int`): The context handle.

    Returns:
        :class:`IEvaluator`: The evaluator object.

    """
    return _NvRules.get_evaluator(h)

def raise_exception(h, msg):
    return _NvRules.raise_exception(h, msg)


import enum

class MarkerKind(enum.IntEnum):
    """
    Enum representing the kind of a source marker.

    Attributes:
        SASS: The marker will be associated with a SASS instruction.
        SOURCE: The marker will be associated with a Source line.
        NONE: No specific kind of marker.
    """
    SASS = MarkerKind_SASS
    SOURCE = MarkerKind_SOURCE
    NONE = MarkerKind_NONE


class MsgType(enum.IntEnum):
    """
    Enum representing the type of the message.

    Attributes:
        NONE: No specific type for this message.
        OK: The message is informative.
        OPTIMIZATION: The message represents a suggestion for performance optimization.
        WARNING: The message represents a warning or fixable issue.
        ERROR: The message represents an error, potentially in executing the rule.
    """
    NONE = MsgType_NONE
    OK = MsgType_OK
    OPTIMIZATION = MsgType_OPTIMIZATION
    WARNING = MsgType_WARNING
    ERROR = MsgType_ERR



