/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.util;

import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;

public class TimeBasedExpiryTracker
implements BooleanSupplier {
    private final LongSupplier nanoTimeSupplier;
    private volatile long lastAccessTimeInNanos;
    private final long expiryTimeInNanos;
    private static final long ONE_SEC = 1000000000L;

    public TimeBasedExpiryTracker(LongSupplier nanoTimeSupplier) {
        this(nanoTimeSupplier, 1000000000L);
    }

    public TimeBasedExpiryTracker(LongSupplier nanoTimeSupplier, long expiryTimeInNanos) {
        this.nanoTimeSupplier = nanoTimeSupplier;
        this.lastAccessTimeInNanos = nanoTimeSupplier.getAsLong();
        this.expiryTimeInNanos = expiryTimeInNanos;
    }

    @Override
    public boolean getAsBoolean() {
        boolean isExpired;
        long currentTime = this.nanoTimeSupplier.getAsLong();
        boolean bl = isExpired = currentTime - this.lastAccessTimeInNanos > this.expiryTimeInNanos;
        if (isExpired) {
            this.lastAccessTimeInNanos = currentTime;
        }
        return isExpired;
    }
}

