/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class MatchOnlyTextProperty
implements PropertyVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, MatchOnlyTextProperty> {
    @Nonnull
    private final List<String> copyTo;
    @Nonnull
    private final Map<String, Property> fields;
    @Nonnull
    private final Map<String, String> meta;
    public static final JsonpDeserializer<MatchOnlyTextProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatchOnlyTextProperty::setupMatchOnlyTextPropertyDeserializer);

    private MatchOnlyTextProperty(Builder builder) {
        this.copyTo = ApiTypeHelper.unmodifiable(builder.copyTo);
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
    }

    public static MatchOnlyTextProperty of(Function<Builder, ObjectBuilder<MatchOnlyTextProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.MatchOnlyText;
    }

    @Nonnull
    public final List<String> copyTo() {
        return this.copyTo;
    }

    @Nonnull
    public final Map<String, Property> fields() {
        return this.fields;
    }

    @Nonnull
    public final Map<String, String> meta() {
        return this.meta;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "match_only_text");
        if (ApiTypeHelper.isDefined(this.copyTo)) {
            generator.writeKey("copy_to");
            generator.writeStartArray();
            for (String string : this.copyTo) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.fields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((Property)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("meta");
            generator.writeStartObject();
            for (Map.Entry entry : this.meta.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupMatchOnlyTextPropertyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::copyTo, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "copy_to");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(Property._DESERIALIZER), "fields");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "meta");
        op.ignore("type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.copyTo);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.meta);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchOnlyTextProperty other = (MatchOnlyTextProperty)o;
        return Objects.equals(this.copyTo, other.copyTo) && Objects.equals(this.fields, other.fields) && Objects.equals(this.meta, other.meta);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, MatchOnlyTextProperty> {
        @Nullable
        private List<String> copyTo;
        @Nullable
        private Map<String, Property> fields;
        @Nullable
        private Map<String, String> meta;

        public Builder() {
        }

        private Builder(MatchOnlyTextProperty o) {
            this.copyTo = Builder._listCopy(o.copyTo);
            this.fields = Builder._mapCopy(o.fields);
            this.meta = Builder._mapCopy(o.meta);
        }

        private Builder(Builder o) {
            this.copyTo = Builder._listCopy(o.copyTo);
            this.fields = Builder._mapCopy(o.fields);
            this.meta = Builder._mapCopy(o.meta);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder copyTo(List<String> list) {
            this.copyTo = Builder._listAddAll(this.copyTo, list);
            return this;
        }

        @Nonnull
        public final Builder copyTo(String value, String ... values) {
            this.copyTo = Builder._listAdd(this.copyTo, value, values);
            return this;
        }

        @Nonnull
        public final Builder fields(Map<String, Property> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, Property value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        @Nonnull
        public final Builder fields(String key, Function<Property.Builder, ObjectBuilder<Property>> fn) {
            return this.fields(key, fn.apply(new Property.Builder()).build());
        }

        @Nonnull
        public final Builder meta(Map<String, String> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, String value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Override
        @Nonnull
        public MatchOnlyTextProperty build() {
            this._checkSingleUse();
            return new MatchOnlyTextProperty(this);
        }
    }
}

