/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.provenance;

import com.oracle.labs.mlrg.olcut.provenance.ObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.DateTimeProvenance;
import com.oracle.labs.mlrg.olcut.provenance.primitives.StringProvenance;
import com.oracle.labs.mlrg.olcut.util.Pair;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.tribuo.DataSource;
import org.tribuo.Output;
import org.tribuo.OutputFactory;
import org.tribuo.provenance.DataSourceProvenance;
import org.tribuo.provenance.OutputFactoryProvenance;

public class SimpleDataSourceProvenance
implements DataSourceProvenance {
    private static final long serialVersionUID = 1L;
    public static final String DESCRIPTION = "description";
    private final String className = DataSource.class.getName();
    private final StringProvenance description;
    private final DateTimeProvenance creationTime;
    private final OutputFactoryProvenance outputFactoryProvenance;

    public <T extends Output<T>> SimpleDataSourceProvenance(String description, OutputFactory<T> outputFactory) {
        this(description, OffsetDateTime.now(), outputFactory);
    }

    public <T extends Output<T>> SimpleDataSourceProvenance(String description, OffsetDateTime creationTime, OutputFactory<T> outputFactory) {
        this.description = new StringProvenance(DESCRIPTION, description);
        this.creationTime = new DateTimeProvenance("datasource-creation-time", creationTime);
        this.outputFactoryProvenance = (OutputFactoryProvenance)outputFactory.getProvenance();
    }

    public SimpleDataSourceProvenance(Map<String, Provenance> map) {
        this.description = (StringProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)DESCRIPTION, StringProvenance.class, (String)SimpleDataSourceProvenance.class.getSimpleName());
        this.creationTime = (DateTimeProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"datasource-creation-time", DateTimeProvenance.class, (String)SimpleDataSourceProvenance.class.getSimpleName());
        this.outputFactoryProvenance = (OutputFactoryProvenance)ObjectProvenance.checkAndExtractProvenance(map, (String)"outputFactory", OutputFactoryProvenance.class, (String)SimpleDataSourceProvenance.class.getSimpleName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleDataSourceProvenance)) {
            return false;
        }
        SimpleDataSourceProvenance pairs = (SimpleDataSourceProvenance)o;
        return this.className.equals(pairs.className) && this.description.equals((Object)pairs.description) && this.creationTime.equals((Object)pairs.creationTime) && this.outputFactoryProvenance.equals(pairs.outputFactoryProvenance);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.description, this.creationTime, this.outputFactoryProvenance);
    }

    public String getClassName() {
        return this.className;
    }

    public Iterator<Pair<String, Provenance>> iterator() {
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.add(new Pair((Object)DESCRIPTION, (Object)this.description));
        list.add(new Pair((Object)"outputFactory", (Object)this.outputFactoryProvenance));
        list.add(new Pair((Object)"datasource-creation-time", (Object)this.creationTime));
        return list.iterator();
    }

    public String toString() {
        return this.generateString("DataSource");
    }
}

