/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.sequence;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.provenance.Provenance;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.logging.Logger;
import org.tribuo.Dataset;
import org.tribuo.Model;
import org.tribuo.Output;
import org.tribuo.Trainer;
import org.tribuo.provenance.DatasetProvenance;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.provenance.TrainerProvenance;
import org.tribuo.provenance.impl.TrainerProvenanceImpl;
import org.tribuo.sequence.IndependentSequenceModel;
import org.tribuo.sequence.SequenceDataset;
import org.tribuo.sequence.SequenceTrainer;

public class IndependentSequenceTrainer<T extends Output<T>>
implements SequenceTrainer<T> {
    private static final Logger logger = Logger.getLogger(IndependentSequenceTrainer.class.getName());
    @Config(mandatory=true, description="The trainer to use.")
    private Trainer<T> innerTrainer;
    private int trainInvocationCounter;

    public IndependentSequenceTrainer(Trainer<T> innerTrainer) {
        this.innerTrainer = innerTrainer;
    }

    private IndependentSequenceTrainer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndependentSequenceModel<T> train(SequenceDataset<T> sequenceExamples, Map<String, Provenance> runProvenance) {
        TrainerProvenance trainerProvenance;
        if (sequenceExamples.getOutputInfo().getUnknownCount() > 0) {
            throw new IllegalArgumentException("The supplied Dataset contained unknown Outputs, and this Trainer is supervised.");
        }
        IndependentSequenceTrainer independentSequenceTrainer = this;
        synchronized (independentSequenceTrainer) {
            trainerProvenance = this.getProvenance();
            ++this.trainInvocationCounter;
        }
        Dataset<T> flatDataset = sequenceExamples.getFlatDataset();
        logger.info(String.format("Training inner trainer with %d examples", flatDataset.size()));
        Model<T> model = this.innerTrainer.train(flatDataset);
        ModelProvenance provenance = new ModelProvenance(IndependentSequenceModel.class.getName(), OffsetDateTime.now(), (DatasetProvenance)sequenceExamples.getProvenance(), trainerProvenance, runProvenance);
        return new IndependentSequenceModel<T>("independent-sequence-model", provenance, model);
    }

    @Override
    public int getInvocationCount() {
        return this.trainInvocationCounter;
    }

    public String toString() {
        return "IndependentSequenceTrainer(innerTrainer=" + this.innerTrainer.toString() + ")";
    }

    public TrainerProvenance getProvenance() {
        return new TrainerProvenanceImpl(this);
    }
}

