/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyElsePart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyAssignmentToLoopOrWithParameterInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static boolean isDeclaredInElse(@NotNull PsiElement elementToCheck, @NotNull PyForStatement forStatement) {
        PyElsePart elsePart;
        if (elementToCheck == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(2);
        }
        if (forStatement == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(3);
        }
        return (elsePart = forStatement.getElsePart()) != null && PsiTreeUtil.isAncestor((PsiElement)elsePart, (PsiElement)elementToCheck, (boolean)false);
    }

    @NotNull
    private static PsiElement handleSubscriptionsAndResolveSafely(@NotNull PyExpression element) {
        if (element == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(4);
        }
        if (element instanceof PySubscriptionExpression) {
            element = ((PySubscriptionExpression)element).getRootOperand();
        }
        PsiElement psiElement = PyUtil.resolveToTheTop((PsiElement)element);
        if (psiElement == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    private static boolean isRequiredStatement(PsiElement element) {
        assert (element != null);
        return element instanceof PyWithStatement || element instanceof PyForStatement;
    }

    @NotNull
    private static List<PyExpression> getNamedElementsOfForAndWithStatements(@NotNull PsiElement element) {
        if (element == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(6);
        }
        if (element instanceof PyForStatement) {
            PyForStatement forStatement = (PyForStatement)element;
            PyExpression target = forStatement.getForPart().getTarget();
            return PyAssignmentToLoopOrWithParameterInspection.dropUnderscores(PyUtil.flattenedParensAndStars(target));
        }
        if (element instanceof PyWithStatement) {
            PyWithStatement withStatement = (PyWithStatement)element;
            ArrayList<PyExpression> result = new ArrayList<PyExpression>();
            for (PyWithItem item : withStatement.getWithItems()) {
                PyExpression target = item.getTarget();
                if (target == null) continue;
                result.addAll(PyUtil.flattenedParensAndTuples(target));
            }
            return PyAssignmentToLoopOrWithParameterInspection.dropUnderscores(result);
        }
        List<PyExpression> list = Collections.emptyList();
        if (list == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static List<PyExpression> dropUnderscores(@NotNull List<PyExpression> expressions) {
        if (expressions == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(8);
        }
        List list = ContainerUtil.filter(expressions, expression -> !"_".equals(expression.getText()));
        if (list == null) {
            PyAssignmentToLoopOrWithParameterInspection.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forStatement";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "handleSubscriptionsAndResolveSafely";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamedElementsOfForAndWithStatements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dropUnderscores";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredInElse";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleSubscriptionsAndResolveSafely";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNamedElementsOfForAndWithStatements";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dropUnderscores";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9 -> new IllegalStateException(string);
        };
    }

    private static final class Visitor
    extends PyInspectionVisitor {
        private Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        public void visitPyWithStatement(@NotNull PyWithStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.checkNotReDeclaringUpperLoopOrStatement((PsiElement)node);
        }

        public void visitPyForStatement(@NotNull PyForStatement node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            this.checkNotReDeclaringUpperLoopOrStatement((PsiElement)node);
        }

        private void checkNotReDeclaringUpperLoopOrStatement(@NotNull PsiElement statement) {
            if (statement == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            for (PyExpression declaredVar : PyAssignmentToLoopOrWithParameterInspection.getNamedElementsOfForAndWithStatements(statement)) {
                Filter filter = new Filter(PyAssignmentToLoopOrWithParameterInspection.handleSubscriptionsAndResolveSafely(declaredVar));
                PsiElement firstParent = PsiTreeUtil.findFirstParent((PsiElement)statement, (boolean)true, (Condition)filter);
                if (firstParent == null || !PyAssignmentToLoopOrWithParameterInspection.isRequiredStatement(firstParent) || firstParent instanceof PyForStatement && PyAssignmentToLoopOrWithParameterInspection.isDeclaredInElse(statement, (PyForStatement)firstParent)) continue;
                this.registerProblem((PsiElement)declaredVar, PyPsiBundle.message("INSP.assignment.to.loop.or.with.parameter", declaredVar.getText()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyAssignmentToLoopOrWithParameterInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyWithStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyForStatement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkNotReDeclaringUpperLoopOrStatement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class Filter
    implements Condition<PsiElement> {
        private final PsiElement myNode;

        private Filter(PsiElement node) {
            this.myNode = node;
        }

        public boolean value(PsiElement psiElement) {
            if (psiElement instanceof ScopeOwner) {
                return true;
            }
            if (!PyAssignmentToLoopOrWithParameterInspection.isRequiredStatement(psiElement)) {
                return false;
            }
            List<PyExpression> varsDeclaredInStatement = PyAssignmentToLoopOrWithParameterInspection.getNamedElementsOfForAndWithStatements(psiElement);
            for (PyExpression varDeclaredInStatement : varsDeclaredInStatement) {
                PsiReference reference = PyAssignmentToLoopOrWithParameterInspection.handleSubscriptionsAndResolveSafely(varDeclaredInStatement).getReference();
                if (reference == null || !reference.isReferenceTo(this.myNode)) continue;
                return true;
            }
            return false;
        }
    }
}

