/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.util;

import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.List;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.PotentialCreator;
import tools.jackson.databind.util.ClassUtil;

public class RecordUtil {
    public static String[] getRecordFieldNames(Class<?> recordType) {
        RecordComponent[] components = recordType.getRecordComponents();
        if (components == null) {
            return null;
        }
        return (String[])Arrays.stream(components).map(RecordComponent::getName).toArray(String[]::new);
    }

    public static PotentialCreator findCanonicalRecordConstructor(MapperConfig<?> config, AnnotatedClass recordClass, List<PotentialCreator> constructors) {
        AnnotatedConstructor defCtor;
        RecordComponent[] components = recordClass.getRawType().getRecordComponents();
        if (components == null) {
            return null;
        }
        int argCount = components.length;
        if (argCount == 0 && (defCtor = recordClass.getDefaultConstructor()) != null) {
            return new PotentialCreator(defCtor, null);
        }
        block0: for (PotentialCreator ctor : constructors) {
            if (ctor.paramCount() != argCount) continue;
            for (int i = 0; i < argCount; ++i) {
                if (!ctor.creator().getRawParameterType(i).equals(components[i].getType())) continue block0;
            }
            PropertyName[] implicits = new PropertyName[argCount];
            for (int i = 0; i < argCount; ++i) {
                implicits[i] = PropertyName.construct(components[i].getName());
            }
            return ctor.introspectParamNames(config, implicits);
        }
        throw new IllegalArgumentException("Failed to find the canonical Record constructor of type " + ClassUtil.getTypeDescription(recordClass.getType()));
    }
}

