/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.set.PBaseSet;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.lib.PyObjectIsTrueNodeGen;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.bytecode.OperationProxy;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(value=false)
@GenerateCached
@OperationProxy.Proxyable
public abstract class PyObjectIsTrueNode
extends PNodeWithContext {
    public abstract boolean execute(Frame var1, Object var2);

    public static boolean executeUncached(Object object) {
        return PyObjectIsTrueNode.getUncached().execute(null, object);
    }

    @Specialization
    public static boolean doBoolean(boolean object) {
        return object;
    }

    @Specialization
    public static boolean doNone(PNone object) {
        return false;
    }

    @Specialization
    public static boolean doInt(int object) {
        return object != 0;
    }

    @Specialization
    public static boolean doLong(long object) {
        return object != 0L;
    }

    @Specialization
    public static boolean doDouble(double object) {
        return object != 0.0;
    }

    @Specialization
    public static boolean doString(TruffleString object) {
        return !object.isEmpty();
    }

    @Specialization(guards={"isBuiltinList(object)"})
    public static boolean doList(PList object) {
        return object.getSequenceStorage().length() != 0;
    }

    @Specialization(guards={"isBuiltinTuple(object)"})
    public static boolean doTuple(PTuple object) {
        return object.getSequenceStorage().length() != 0;
    }

    @Specialization(guards={"isBuiltinDict(object)"})
    public static boolean doDict(PDict object, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage()) != 0;
    }

    @Specialization(guards={"isBuiltinAnySet(object)"})
    @HostCompilerDirectives.InliningCutoff
    public static boolean doSet(PBaseSet object, @Bind Node inliningTarget, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageLen lenNode) {
        return lenNode.execute(inliningTarget, object.getDictStorage()) != 0;
    }

    @Specialization(guards={"!isBoolean(object)", "!isPNone(object)", "!isInt(object)", "!isLong(object)", "!isDouble(object)", "!isTruffleString(object)"}, replaces={"doList", "doTuple", "doDict", "doSet"})
    @HostCompilerDirectives.InliningCutoff
    public static boolean doOthers(VirtualFrame frame, Object object, @Cached PyObjectIsTrueNodeGeneric internalNode) {
        return internalNode.execute((Frame)frame, object);
    }

    @NeverDefault
    public static PyObjectIsTrueNode create() {
        return PyObjectIsTrueNodeGen.create();
    }

    public static PyObjectIsTrueNode getUncached() {
        return PyObjectIsTrueNodeGen.getUncached();
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class PyObjectIsTrueNodeGeneric
    extends PNodeWithContext {
        public abstract boolean execute(Frame var1, Object var2);

        protected abstract Object executeObject(Frame var1, Object var2);

        @Specialization
        static boolean doIt(VirtualFrame frame, Object object, @Bind Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getTpSlotsNode, @Cached TpSlotInquiry.CallSlotNbBoolNode callBoolNode, @Cached InlinedBranchProfile lenLookupBranch, @Cached InlinedConditionProfile hasLenProfile, @Cached TpSlotLen.CallSlotLenNode callLenNode) {
            TpSlots slots = getTpSlotsNode.execute(inliningTarget, object);
            if (slots.nb_bool() != null) {
                return callBoolNode.execute(frame, inliningTarget, slots.nb_bool(), object);
            }
            lenLookupBranch.enter(inliningTarget);
            TpSlot lenSlot = slots.combined_mp_sq_length();
            if (hasLenProfile.profile(inliningTarget, lenSlot != null)) {
                return callLenNode.execute(frame, inliningTarget, lenSlot, object) != 0;
            }
            return true;
        }
    }
}

