/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.hashlib;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.HashlibModuleBuiltins;
import com.oracle.graal.python.builtins.modules.hashlib.Sha3BuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.Collections;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Sha3SHA224Type, PythonBuiltinClassType.Sha3SHA256Type, PythonBuiltinClassType.Sha3SHA384Type, PythonBuiltinClassType.Sha3SHA512Type, PythonBuiltinClassType.Sha3Shake128Type, PythonBuiltinClassType.Sha3Shake256Type})
public class Sha3Builtins
extends PythonBuiltins {
    public static final TpSlots SLOTS = Sha3BuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return Collections.emptyList();
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(minNumOfPositionalArgs=1, parameterNames={"$cls", "string"}, keywordOnlyNames={"usedforsecurity"})
    @GenerateNodeFactory
    static abstract class ShaNode
    extends PythonBuiltinNode {
        ShaNode() {
        }

        @Specialization
        static Object newDigest(VirtualFrame frame, Object type, Object buffer, Object usedForSecurity, @Bind Node inliningTarget, @Cached HashlibModuleBuiltins.CreateDigestNode createNode, @Cached PRaiseNode raiseNode) {
            PythonBuiltinClassType resultType;
            if (type instanceof PythonBuiltinClass) {
                PythonBuiltinClass builtinType = (PythonBuiltinClass)type;
                resultType = builtinType.getType();
            } else if (type instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType enumType;
                resultType = enumType = (PythonBuiltinClassType)((Object)type);
            } else {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.WRONG_TYPE);
            }
            return createNode.execute(frame, inliningTarget, resultType, ShaNode.pythonNameFromType(resultType), ShaNode.javaNameFromType(resultType), buffer);
        }

        private static String javaNameFromType(PythonBuiltinClassType type) {
            switch (type) {
                case Sha3SHA224Type: {
                    return "sha3-224";
                }
                case Sha3SHA256Type: {
                    return "sha3-256";
                }
                case Sha3SHA384Type: {
                    return "sha3-384";
                }
                case Sha3SHA512Type: {
                    return "sha3-512";
                }
                case Sha3Shake128Type: {
                    return "SHAKE128";
                }
                case Sha3Shake256Type: {
                    return "SHAKE256";
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }

        private static String pythonNameFromType(PythonBuiltinClassType type) {
            switch (type) {
                case Sha3SHA224Type: {
                    return "sha3_224";
                }
                case Sha3SHA256Type: {
                    return "sha3_256";
                }
                case Sha3SHA384Type: {
                    return "sha3_384";
                }
                case Sha3SHA512Type: {
                    return "sha3_512";
                }
                case Sha3Shake128Type: {
                    return "shake_128";
                }
                case Sha3Shake256Type: {
                    return "shake_256";
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }
}

