/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.field;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.NumericUtils;
import org.apache.solr.analytics.function.field.AnalyticsField;
import org.apache.solr.analytics.util.function.FloatConsumer;
import org.apache.solr.analytics.value.FloatValueStream;

public class FloatMultiPointField
extends AnalyticsField
implements FloatValueStream.CastingFloatValueStream {
    private SortedNumericDocValues docValues;
    private int count = 0;
    private float[] values = new float[20];

    public FloatMultiPointField(String fieldName) {
        super(fieldName);
    }

    @Override
    public void doSetNextReader(LeafReaderContext context) throws IOException {
        this.docValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.fieldName);
    }

    @Override
    public void collect(int doc) throws IOException {
        if (this.docValues.advanceExact(doc)) {
            this.count = this.docValues.docValueCount();
            this.resizeEmptyValues(this.count);
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = NumericUtils.sortableIntToFloat((int)((int)this.docValues.nextValue()));
            }
        } else {
            this.count = 0;
        }
    }

    private void resizeEmptyValues(int count) {
        if (count > this.values.length) {
            this.values = new float[count];
        }
    }

    @Override
    public void streamFloats(FloatConsumer cons) {
        for (int i = 0; i < this.count; ++i) {
            cons.accept(this.values[i]);
        }
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        this.streamFloats(value -> cons.accept(value));
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        this.streamFloats(value -> cons.accept(Float.toString(value)));
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.streamFloats(value -> cons.accept(Float.valueOf(value)));
    }
}

