/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.color.ColorSpaceLab;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDTristimulus;

public class PDLab
extends PDColorSpace {
    public static final String NAME = "Lab";
    private COSArray array;
    private COSDictionary dictionary;

    public PDLab() {
        this.array = new COSArray();
        this.dictionary = new COSDictionary();
        this.array.add(COSName.LAB);
        this.array.add(this.dictionary);
    }

    public PDLab(COSArray lab) {
        this.array = lab;
        this.dictionary = (COSDictionary)this.array.getObject(1);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public COSBase getCOSObject() {
        return this.array;
    }

    @Override
    protected ColorSpace createColorSpace() throws IOException {
        return new ColorSpaceLab(this.getWhitePoint(), this.getBlackPoint(), this.getARange(), this.getBRange());
    }

    @Override
    public ColorModel createColorModel(int bpc) throws IOException {
        int[] nBits = new int[]{bpc, bpc, bpc};
        return new ComponentColorModel(this.getJavaColorSpace(), nBits, false, false, 1, 0);
    }

    @Override
    public int getNumberOfComponents() throws IOException {
        return 3;
    }

    public PDTristimulus getWhitePoint() {
        COSArray wp = (COSArray)this.dictionary.getDictionaryObject(COSName.WHITE_POINT);
        if (wp == null) {
            wp = new COSArray();
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
            wp.add(new COSFloat(1.0f));
        }
        return new PDTristimulus(wp);
    }

    public void setWhitePoint(PDTristimulus wp) {
        COSBase wpArray = wp.getCOSObject();
        if (wpArray != null) {
            this.dictionary.setItem(COSName.WHITE_POINT, wpArray);
        }
    }

    public PDTristimulus getBlackPoint() {
        COSArray bp = (COSArray)this.dictionary.getDictionaryObject(COSName.BLACK_POINT);
        if (bp == null) {
            bp = new COSArray();
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
            bp.add(new COSFloat(0.0f));
        }
        return new PDTristimulus(bp);
    }

    public void setBlackPoint(PDTristimulus bp) {
        COSBase bpArray = null;
        if (bp != null) {
            bpArray = bp.getCOSObject();
        }
        this.dictionary.setItem(COSName.BLACK_POINT, bpArray);
    }

    private COSArray getDefaultRangeArray() {
        COSArray range = new COSArray();
        range.add(new COSFloat(-100.0f));
        range.add(new COSFloat(100.0f));
        range.add(new COSFloat(-100.0f));
        range.add(new COSFloat(100.0f));
        return range;
    }

    public PDRange getARange() {
        COSArray rangeArray = (COSArray)this.dictionary.getDictionaryObject(COSName.RANGE);
        if (rangeArray == null) {
            rangeArray = this.getDefaultRangeArray();
        }
        return new PDRange(rangeArray, 0);
    }

    public void setARange(PDRange range) {
        COSArray rangeArray = (COSArray)this.dictionary.getDictionaryObject(COSName.RANGE);
        if (rangeArray == null) {
            rangeArray = this.getDefaultRangeArray();
        }
        if (range == null) {
            rangeArray.set(0, new COSFloat(-100.0f));
            rangeArray.set(1, new COSFloat(100.0f));
        } else {
            rangeArray.set(0, new COSFloat(range.getMin()));
            rangeArray.set(1, new COSFloat(range.getMax()));
        }
        this.dictionary.setItem(COSName.RANGE, (COSBase)rangeArray);
    }

    public PDRange getBRange() {
        COSArray rangeArray = (COSArray)this.dictionary.getDictionaryObject(COSName.RANGE);
        if (rangeArray == null) {
            rangeArray = this.getDefaultRangeArray();
        }
        return new PDRange(rangeArray, 1);
    }

    public void setBRange(PDRange range) {
        COSArray rangeArray = (COSArray)this.dictionary.getDictionaryObject(COSName.RANGE);
        if (rangeArray == null) {
            rangeArray = this.getDefaultRangeArray();
        }
        if (range == null) {
            rangeArray.set(2, new COSFloat(-100.0f));
            rangeArray.set(3, new COSFloat(100.0f));
        } else {
            rangeArray.set(2, new COSFloat(range.getMin()));
            rangeArray.set(3, new COSFloat(range.getMax()));
        }
        this.dictionary.setItem(COSName.RANGE, (COSBase)rangeArray);
    }
}

