/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.catalina.tribes.membership.cloud.AbstractStreamProvider;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.jsse.PEMFile;

public class CertificateStreamProvider
extends AbstractStreamProvider {
    private static final Log log = LogFactory.getLog(CertificateStreamProvider.class);
    private final SSLSocketFactory factory;

    CertificateStreamProvider(String string, String string2, String string3, String string4, String string5) throws Exception {
        char[] cArray = string3 != null ? string3.toCharArray() : new char[]{};
        KeyManager[] keyManagerArray = CertificateStreamProvider.configureClientCert(string, string2, cArray, string4);
        TrustManager[] trustManagerArray = CertificateStreamProvider.configureCaCert(string5);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerArray, trustManagerArray, null);
        this.factory = sSLContext.getSocketFactory();
    }

    @Override
    protected SSLSocketFactory getSocketFactory() {
        return this.factory;
    }

    private static KeyManager[] configureClientCert(String string, String string2, char[] cArray, String string3) throws Exception {
        KeyManager[] keyManagerArray;
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            PEMFile pEMFile = new PEMFile(string2, new String(cArray), string3);
            PrivateKey privateKey = pEMFile.getPrivateKey();
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, null);
            String string4 = x509Certificate.getSubjectX500Principal().getName();
            keyStore.setKeyEntry(string4, privateKey, cArray, new Certificate[]{x509Certificate});
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            keyManagerArray = keyManagerFactory.getKeyManagers();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                log.error((Object)sm.getString("certificateStream.clientCertError", string, string2));
                throw iOException;
            }
        }
        ((InputStream)fileInputStream).close();
        return keyManagerArray;
    }
}

