/*
 * Decompiled with CFR 0.152.
 */
package jakarta.servlet.jsp.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.PageContext;
import java.beans.FeatureDescriptor;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ImplicitObjectELResolver
extends ELResolver {
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Scope scope;
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && (scope = Scope.lookupMap.get(object2.toString())) != null) {
            return scope.getScopeValue(eLContext, object, object2);
        }
        return null;
    }

    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && Scope.lookupMap.containsKey(object2.toString())) {
            eLContext.setPropertyResolved(object, object2);
        }
        return null;
    }

    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && Scope.lookupMap.containsKey(object2.toString())) {
            eLContext.setPropertyResolved(object, object2);
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object == null && object2 != null && Scope.lookupMap.containsKey(object2.toString())) {
            eLContext.setPropertyResolved(object, object2);
            return true;
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="JSP 3.1")
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        ArrayList<FeatureDescriptor> arrayList = new ArrayList<FeatureDescriptor>(Scope.values().length);
        for (Scope scope : Scope.values()) {
            FeatureDescriptor featureDescriptor = new FeatureDescriptor();
            featureDescriptor.setDisplayName(scope.implicitName);
            featureDescriptor.setExpert(false);
            featureDescriptor.setHidden(false);
            featureDescriptor.setName(scope.implicitName);
            featureDescriptor.setPreferred(true);
            featureDescriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
            featureDescriptor.setValue("type", String.class);
            arrayList.add(featureDescriptor);
        }
        return arrayList.iterator();
    }

    public Class<String> getCommonPropertyType(ELContext eLContext, Object object) {
        if (object == null) {
            return String.class;
        }
        return null;
    }

    private static enum Scope {
        APPLICATION_SCOPE("applicationScope"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getApplicationScope();
            }
        }
        ,
        COOKIE("cookie"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getCookie();
            }
        }
        ,
        HEADER("header"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getHeader();
            }
        }
        ,
        HEADER_VALUES("headerValues"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getHeaderValues();
            }
        }
        ,
        INIT_PARAM("initParam"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getInitParam();
            }
        }
        ,
        PAGE_CONTEXT("pageContext"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getPageContext();
            }
        }
        ,
        PAGE_SCOPE("pageScope"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getPageScope();
            }
        }
        ,
        PARAM("param"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getParam();
            }
        }
        ,
        PARAM_VALUES("paramValues"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getParamValues();
            }
        }
        ,
        REQUEST_SCOPE("requestScope"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getRequestScope();
            }
        }
        ,
        SESSION_SCOPE("sessionScope"){

            @Override
            Object getScopeValue(ELContext eLContext, Object object, Object object2) {
                return Scope.getScopeManager(eLContext, object, object2).getSessionScope();
            }
        };

        private static final Map<String, Scope> lookupMap;
        private final String implicitName;

        private static ScopeManager getScopeManager(ELContext eLContext, Object object, Object object2) {
            PageContext pageContext = (PageContext)eLContext.getContext(JspContext.class);
            eLContext.setPropertyResolved(object, object2);
            return ScopeManager.get(pageContext);
        }

        private Scope(String string2) {
            this.implicitName = string2;
        }

        abstract Object getScopeValue(ELContext var1, Object var2, Object var3);

        static {
            lookupMap = new HashMap<String, Scope>();
            for (Scope scope : Scope.values()) {
                lookupMap.put(scope.implicitName, scope);
            }
        }
    }

    private static abstract class ScopeMap<V>
    extends AbstractMap<String, V> {
        private ScopeMap() {
        }

        protected abstract Enumeration<String> getAttributeNames();

        protected abstract V getAttribute(String var1);

        protected void removeAttribute(String string) {
            throw new UnsupportedOperationException();
        }

        protected void setAttribute(String string, Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Set<Map.Entry<String, V>> entrySet() {
            Enumeration<String> enumeration = this.getAttributeNames();
            HashSet<Map.Entry<String, V>> hashSet = new HashSet<Map.Entry<String, V>>();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    hashSet.add(new ScopeEntry(enumeration.nextElement()));
                }
            }
            return hashSet;
        }

        @Override
        public final int size() {
            int n = 0;
            Enumeration<String> enumeration = this.getAttributeNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement();
                    ++n;
                }
            }
            return n;
        }

        @Override
        public final boolean containsKey(Object object) {
            if (object == null) {
                return false;
            }
            Enumeration<String> enumeration = this.getAttributeNames();
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    if (!object.equals(enumeration.nextElement())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public final V get(Object object) {
            if (object != null) {
                return this.getAttribute((String)object);
            }
            return null;
        }

        @Override
        public final V put(String string, V v) {
            Objects.requireNonNull(string);
            if (v == null) {
                this.removeAttribute(string);
            } else {
                this.setAttribute(string, v);
            }
            return null;
        }

        @Override
        public final V remove(Object object) {
            Objects.requireNonNull(object);
            this.removeAttribute((String)object);
            return null;
        }

        private class ScopeEntry
        implements Map.Entry<String, V> {
            private final String key;

            ScopeEntry(String string) {
                this.key = string;
            }

            @Override
            public String getKey() {
                return this.key;
            }

            @Override
            public V getValue() {
                return ScopeMap.this.getAttribute(this.key);
            }

            @Override
            public V setValue(Object object) {
                if (object == null) {
                    ScopeMap.this.removeAttribute(this.key);
                } else {
                    ScopeMap.this.setAttribute(this.key, object);
                }
                return null;
            }

            @Override
            public boolean equals(Object object) {
                return object != null && this.hashCode() == object.hashCode();
            }

            @Override
            public int hashCode() {
                return this.key.hashCode();
            }
        }
    }

    private static class ScopeManager {
        private static final String MNGR_KEY = ScopeManager.class.getName();
        private final PageContext page;
        private Map<String, Object> applicationScope;
        private Map<String, Cookie> cookie;
        private Map<String, String> header;
        private Map<String, String[]> headerValues;
        private Map<String, String> initParam;
        private Map<String, Object> pageScope;
        private Map<String, String> param;
        private Map<String, String[]> paramValues;
        private Map<String, Object> requestScope;
        private Map<String, Object> sessionScope;

        ScopeManager(PageContext pageContext) {
            this.page = pageContext;
        }

        public static ScopeManager get(PageContext pageContext) {
            ScopeManager scopeManager = (ScopeManager)pageContext.getAttribute(MNGR_KEY);
            if (scopeManager == null) {
                scopeManager = new ScopeManager(pageContext);
                pageContext.setAttribute(MNGR_KEY, scopeManager);
            }
            return scopeManager;
        }

        public Map<String, Object> getApplicationScope() {
            if (this.applicationScope == null) {
                this.applicationScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        page.getServletContext().setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        page.getServletContext().removeAttribute(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getServletContext().getAttributeNames();
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        return page.getServletContext().getAttribute(string);
                    }
                };
            }
            return this.applicationScope;
        }

        public Map<String, Cookie> getCookie() {
            if (this.cookie == null) {
                this.cookie = new ScopeMap<Cookie>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        Cookie[] cookieArray = ((HttpServletRequest)page.getRequest()).getCookies();
                        if (cookieArray != null) {
                            ArrayList<String> arrayList = new ArrayList<String>(cookieArray.length);
                            for (Cookie cookie : cookieArray) {
                                arrayList.add(cookie.getName());
                            }
                            return Collections.enumeration(arrayList);
                        }
                        return null;
                    }

                    @Override
                    protected Cookie getAttribute(String string) {
                        Cookie[] cookieArray = ((HttpServletRequest)page.getRequest()).getCookies();
                        if (cookieArray != null) {
                            for (Cookie cookie : cookieArray) {
                                if (!string.equals(cookie.getName())) continue;
                                return cookie;
                            }
                        }
                        return null;
                    }
                };
            }
            return this.cookie;
        }

        public Map<String, String> getHeader() {
            if (this.header == null) {
                this.header = new ScopeMap<String>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return ((HttpServletRequest)page.getRequest()).getHeaderNames();
                    }

                    @Override
                    protected String getAttribute(String string) {
                        return ((HttpServletRequest)page.getRequest()).getHeader(string);
                    }
                };
            }
            return this.header;
        }

        public Map<String, String[]> getHeaderValues() {
            if (this.headerValues == null) {
                this.headerValues = new ScopeMap<String[]>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return ((HttpServletRequest)page.getRequest()).getHeaderNames();
                    }

                    @Override
                    protected String[] getAttribute(String string) {
                        Enumeration enumeration = ((HttpServletRequest)page.getRequest()).getHeaders(string);
                        if (enumeration != null) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            while (enumeration.hasMoreElements()) {
                                arrayList.add((String)enumeration.nextElement());
                            }
                            return arrayList.toArray(new String[0]);
                        }
                        return null;
                    }
                };
            }
            return this.headerValues;
        }

        public Map<String, String> getInitParam() {
            if (this.initParam == null) {
                this.initParam = new ScopeMap<String>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getServletContext().getInitParameterNames();
                    }

                    @Override
                    protected String getAttribute(String string) {
                        return page.getServletContext().getInitParameter(string);
                    }
                };
            }
            return this.initParam;
        }

        public PageContext getPageContext() {
            return this.page;
        }

        public Map<String, Object> getPageScope() {
            if (this.pageScope == null) {
                this.pageScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        page.setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        page.removeAttribute(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getAttributeNamesInScope(1);
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        return page.getAttribute(string);
                    }
                };
            }
            return this.pageScope;
        }

        public Map<String, String> getParam() {
            if (this.param == null) {
                this.param = new ScopeMap<String>(){

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getRequest().getParameterNames();
                    }

                    @Override
                    protected String getAttribute(String string) {
                        return page.getRequest().getParameter(string);
                    }
                };
            }
            return this.param;
        }

        public Map<String, String[]> getParamValues() {
            if (this.paramValues == null) {
                this.paramValues = new ScopeMap<String[]>(){

                    @Override
                    protected String[] getAttribute(String string) {
                        return page.getRequest().getParameterValues(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getRequest().getParameterNames();
                    }
                };
            }
            return this.paramValues;
        }

        public Map<String, Object> getRequestScope() {
            if (this.requestScope == null) {
                this.requestScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        page.getRequest().setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        page.getRequest().removeAttribute(string);
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        return page.getRequest().getAttributeNames();
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        return page.getRequest().getAttribute(string);
                    }
                };
            }
            return this.requestScope;
        }

        public Map<String, Object> getSessionScope() {
            if (this.sessionScope == null) {
                this.sessionScope = new ScopeMap<Object>(){

                    @Override
                    protected void setAttribute(String string, Object object) {
                        ((HttpServletRequest)page.getRequest()).getSession().setAttribute(string, object);
                    }

                    @Override
                    protected void removeAttribute(String string) {
                        HttpSession httpSession = page.getSession();
                        if (httpSession != null) {
                            httpSession.removeAttribute(string);
                        }
                    }

                    @Override
                    protected Enumeration<String> getAttributeNames() {
                        HttpSession httpSession = page.getSession();
                        if (httpSession != null) {
                            return httpSession.getAttributeNames();
                        }
                        return null;
                    }

                    @Override
                    protected Object getAttribute(String string) {
                        HttpSession httpSession = page.getSession();
                        if (httpSession != null) {
                            return httpSession.getAttribute(string);
                        }
                        return null;
                    }
                };
            }
            return this.sessionScope;
        }
    }
}

