// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::{Dialog, DialogPresentationMode, ffi};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{SignalHandlerId, connect_raw},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "AdwAboutDialog")]
    pub struct AboutDialog(Object<ffi::AdwAboutDialog, ffi::AdwAboutDialogClass>) @extends Dialog, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget, gtk::ShortcutManager;

    match fn {
        type_ => || ffi::adw_about_dialog_get_type(),
    }
}

impl AboutDialog {
    #[doc(alias = "adw_about_dialog_new")]
    pub fn new() -> AboutDialog {
        assert_initialized_main_thread!();
        unsafe { Dialog::from_glib_none(ffi::adw_about_dialog_new()).unsafe_cast() }
    }

    #[cfg(not(target_env = "msvc"))]
    #[cfg_attr(docsrs, doc(cfg(not(target_env = "msvc"))))]
    #[doc(alias = "adw_about_dialog_new_from_appdata")]
    #[doc(alias = "new_from_appdata")]
    pub fn from_appdata(resource_path: &str, release_notes_version: Option<&str>) -> AboutDialog {
        assert_initialized_main_thread!();
        unsafe {
            Dialog::from_glib_none(ffi::adw_about_dialog_new_from_appdata(
                resource_path.to_glib_none().0,
                release_notes_version.to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`AboutDialog`] objects.
    ///
    /// This method returns an instance of [`AboutDialogBuilder`](crate::builders::AboutDialogBuilder) which can be used to create [`AboutDialog`] objects.
    pub fn builder() -> AboutDialogBuilder {
        AboutDialogBuilder::new()
    }

    #[doc(alias = "adw_about_dialog_add_acknowledgement_section")]
    pub fn add_acknowledgement_section(&self, name: Option<&str>, people: &[&str]) {
        unsafe {
            ffi::adw_about_dialog_add_acknowledgement_section(
                self.to_glib_none().0,
                name.to_glib_none().0,
                people.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_add_credit_section")]
    pub fn add_credit_section(&self, name: Option<&str>, people: &[&str]) {
        unsafe {
            ffi::adw_about_dialog_add_credit_section(
                self.to_glib_none().0,
                name.to_glib_none().0,
                people.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_add_legal_section")]
    pub fn add_legal_section(
        &self,
        title: &str,
        copyright: Option<&str>,
        license_type: gtk::License,
        license: Option<&str>,
    ) {
        unsafe {
            ffi::adw_about_dialog_add_legal_section(
                self.to_glib_none().0,
                title.to_glib_none().0,
                copyright.to_glib_none().0,
                license_type.into_glib(),
                license.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_add_link")]
    pub fn add_link(&self, title: &str, url: &str) {
        unsafe {
            ffi::adw_about_dialog_add_link(
                self.to_glib_none().0,
                title.to_glib_none().0,
                url.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_7")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_7")))]
    #[doc(alias = "adw_about_dialog_add_other_app")]
    pub fn add_other_app(&self, appid: &str, name: &str, summary: &str) {
        unsafe {
            ffi::adw_about_dialog_add_other_app(
                self.to_glib_none().0,
                appid.to_glib_none().0,
                name.to_glib_none().0,
                summary.to_glib_none().0,
            );
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    #[doc(alias = "adw_about_dialog_get_appdata_resource_path")]
    #[doc(alias = "get_appdata_resource_path")]
    #[doc(alias = "appdata-resource-path")]
    pub fn appdata_resource_path(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_appdata_resource_path(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_application_icon")]
    #[doc(alias = "get_application_icon")]
    #[doc(alias = "application-icon")]
    pub fn application_icon(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_application_icon(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_application_name")]
    #[doc(alias = "get_application_name")]
    #[doc(alias = "application-name")]
    pub fn application_name(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_application_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_artists")]
    #[doc(alias = "get_artists")]
    pub fn artists(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_dialog_get_artists(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_comments")]
    #[doc(alias = "get_comments")]
    pub fn comments(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_comments(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_copyright")]
    #[doc(alias = "get_copyright")]
    pub fn copyright(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_copyright(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_debug_info")]
    #[doc(alias = "get_debug_info")]
    #[doc(alias = "debug-info")]
    pub fn debug_info(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_debug_info(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_debug_info_filename")]
    #[doc(alias = "get_debug_info_filename")]
    #[doc(alias = "debug-info-filename")]
    pub fn debug_info_filename(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_debug_info_filename(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_designers")]
    #[doc(alias = "get_designers")]
    pub fn designers(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_dialog_get_designers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_developer_name")]
    #[doc(alias = "get_developer_name")]
    #[doc(alias = "developer-name")]
    pub fn developer_name(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_developer_name(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_developers")]
    #[doc(alias = "get_developers")]
    pub fn developers(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_dialog_get_developers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_documenters")]
    #[doc(alias = "get_documenters")]
    pub fn documenters(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::adw_about_dialog_get_documenters(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_issue_url")]
    #[doc(alias = "get_issue_url")]
    #[doc(alias = "issue-url")]
    pub fn issue_url(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_issue_url(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_license")]
    #[doc(alias = "get_license")]
    pub fn license(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_license(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_license_type")]
    #[doc(alias = "get_license_type")]
    #[doc(alias = "license-type")]
    pub fn license_type(&self) -> gtk::License {
        unsafe {
            from_glib(ffi::adw_about_dialog_get_license_type(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_release_notes")]
    #[doc(alias = "get_release_notes")]
    #[doc(alias = "release-notes")]
    pub fn release_notes(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_release_notes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_release_notes_version")]
    #[doc(alias = "get_release_notes_version")]
    #[doc(alias = "release-notes-version")]
    pub fn release_notes_version(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_release_notes_version(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_support_url")]
    #[doc(alias = "get_support_url")]
    #[doc(alias = "support-url")]
    pub fn support_url(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_support_url(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_translator_credits")]
    #[doc(alias = "get_translator_credits")]
    #[doc(alias = "translator-credits")]
    pub fn translator_credits(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::adw_about_dialog_get_translator_credits(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "adw_about_dialog_get_version")]
    #[doc(alias = "get_version")]
    pub fn version(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_version(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_get_website")]
    #[doc(alias = "get_website")]
    pub fn website(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::adw_about_dialog_get_website(self.to_glib_none().0)) }
    }

    #[doc(alias = "adw_about_dialog_set_application_icon")]
    #[doc(alias = "application-icon")]
    pub fn set_application_icon(&self, application_icon: &str) {
        unsafe {
            ffi::adw_about_dialog_set_application_icon(
                self.to_glib_none().0,
                application_icon.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_application_name")]
    #[doc(alias = "application-name")]
    pub fn set_application_name(&self, application_name: &str) {
        unsafe {
            ffi::adw_about_dialog_set_application_name(
                self.to_glib_none().0,
                application_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_artists")]
    #[doc(alias = "artists")]
    pub fn set_artists(&self, artists: &[&str]) {
        unsafe {
            ffi::adw_about_dialog_set_artists(self.to_glib_none().0, artists.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_comments")]
    #[doc(alias = "comments")]
    pub fn set_comments(&self, comments: &str) {
        unsafe {
            ffi::adw_about_dialog_set_comments(self.to_glib_none().0, comments.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_copyright")]
    #[doc(alias = "copyright")]
    pub fn set_copyright(&self, copyright: &str) {
        unsafe {
            ffi::adw_about_dialog_set_copyright(self.to_glib_none().0, copyright.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_debug_info")]
    #[doc(alias = "debug-info")]
    pub fn set_debug_info(&self, debug_info: &str) {
        unsafe {
            ffi::adw_about_dialog_set_debug_info(
                self.to_glib_none().0,
                debug_info.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_debug_info_filename")]
    #[doc(alias = "debug-info-filename")]
    pub fn set_debug_info_filename(&self, filename: &str) {
        unsafe {
            ffi::adw_about_dialog_set_debug_info_filename(
                self.to_glib_none().0,
                filename.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_designers")]
    #[doc(alias = "designers")]
    pub fn set_designers(&self, designers: &[&str]) {
        unsafe {
            ffi::adw_about_dialog_set_designers(self.to_glib_none().0, designers.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_developer_name")]
    #[doc(alias = "developer-name")]
    pub fn set_developer_name(&self, developer_name: &str) {
        unsafe {
            ffi::adw_about_dialog_set_developer_name(
                self.to_glib_none().0,
                developer_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_developers")]
    #[doc(alias = "developers")]
    pub fn set_developers(&self, developers: &[&str]) {
        unsafe {
            ffi::adw_about_dialog_set_developers(
                self.to_glib_none().0,
                developers.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_documenters")]
    #[doc(alias = "documenters")]
    pub fn set_documenters(&self, documenters: &[&str]) {
        unsafe {
            ffi::adw_about_dialog_set_documenters(
                self.to_glib_none().0,
                documenters.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_issue_url")]
    #[doc(alias = "issue-url")]
    pub fn set_issue_url(&self, issue_url: &str) {
        unsafe {
            ffi::adw_about_dialog_set_issue_url(self.to_glib_none().0, issue_url.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_license")]
    #[doc(alias = "license")]
    pub fn set_license(&self, license: &str) {
        unsafe {
            ffi::adw_about_dialog_set_license(self.to_glib_none().0, license.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_license_type")]
    #[doc(alias = "license-type")]
    pub fn set_license_type(&self, license_type: gtk::License) {
        unsafe {
            ffi::adw_about_dialog_set_license_type(self.to_glib_none().0, license_type.into_glib());
        }
    }

    #[doc(alias = "adw_about_dialog_set_release_notes")]
    #[doc(alias = "release-notes")]
    pub fn set_release_notes(&self, release_notes: &str) {
        unsafe {
            ffi::adw_about_dialog_set_release_notes(
                self.to_glib_none().0,
                release_notes.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_release_notes_version")]
    #[doc(alias = "release-notes-version")]
    pub fn set_release_notes_version(&self, version: &str) {
        unsafe {
            ffi::adw_about_dialog_set_release_notes_version(
                self.to_glib_none().0,
                version.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_support_url")]
    #[doc(alias = "support-url")]
    pub fn set_support_url(&self, support_url: &str) {
        unsafe {
            ffi::adw_about_dialog_set_support_url(
                self.to_glib_none().0,
                support_url.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_translator_credits")]
    #[doc(alias = "translator-credits")]
    pub fn set_translator_credits(&self, translator_credits: &str) {
        unsafe {
            ffi::adw_about_dialog_set_translator_credits(
                self.to_glib_none().0,
                translator_credits.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "adw_about_dialog_set_version")]
    #[doc(alias = "version")]
    pub fn set_version(&self, version: &str) {
        unsafe {
            ffi::adw_about_dialog_set_version(self.to_glib_none().0, version.to_glib_none().0);
        }
    }

    #[doc(alias = "adw_about_dialog_set_website")]
    #[doc(alias = "website")]
    pub fn set_website(&self, website: &str) {
        unsafe {
            ffi::adw_about_dialog_set_website(self.to_glib_none().0, website.to_glib_none().0);
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "activate-link")]
    pub fn connect_activate_link<F: Fn(&Self, &str) -> bool + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn activate_link_trampoline<
            F: Fn(&AboutDialog, &str) -> bool + 'static,
        >(
            this: *mut ffi::AdwAboutDialog,
            uri: *mut std::ffi::c_char,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            unsafe {
                let f: &F = &*(f as *const F);
                f(
                    &from_glib_borrow(this),
                    &glib::GString::from_glib_borrow(uri),
                )
                .into_glib()
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"activate-link".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    activate_link_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "application-icon")]
    pub fn connect_application_icon_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_icon_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::application-icon".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_application_icon_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "application-name")]
    pub fn connect_application_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_application_name_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::application-name".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_application_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "artists")]
    pub fn connect_artists_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_artists_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::artists".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_artists_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "comments")]
    pub fn connect_comments_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_comments_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::comments".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_comments_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "copyright")]
    pub fn connect_copyright_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_copyright_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::copyright".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_copyright_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "debug-info")]
    pub fn connect_debug_info_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_debug_info_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::debug-info".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_debug_info_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "debug-info-filename")]
    pub fn connect_debug_info_filename_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_debug_info_filename_trampoline<
            F: Fn(&AboutDialog) + 'static,
        >(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::debug-info-filename".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_debug_info_filename_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "designers")]
    pub fn connect_designers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_designers_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::designers".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_designers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "developer-name")]
    pub fn connect_developer_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_developer_name_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::developer-name".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_developer_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "developers")]
    pub fn connect_developers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_developers_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::developers".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_developers_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "documenters")]
    pub fn connect_documenters_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_documenters_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::documenters".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_documenters_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "issue-url")]
    pub fn connect_issue_url_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_issue_url_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::issue-url".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_issue_url_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "license")]
    pub fn connect_license_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::license".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_license_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "license-type")]
    pub fn connect_license_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_license_type_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::license-type".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_license_type_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "release-notes")]
    pub fn connect_release_notes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_release_notes_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::release-notes".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_release_notes_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "release-notes-version")]
    pub fn connect_release_notes_version_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_release_notes_version_trampoline<
            F: Fn(&AboutDialog) + 'static,
        >(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::release-notes-version".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_release_notes_version_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "support-url")]
    pub fn connect_support_url_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_support_url_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::support-url".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_support_url_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "translator-credits")]
    pub fn connect_translator_credits_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_translator_credits_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::translator-credits".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_translator_credits_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "version")]
    pub fn connect_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_version_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::version".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_version_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    #[doc(alias = "website")]
    pub fn connect_website_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_website_trampoline<F: Fn(&AboutDialog) + 'static>(
            this: *mut ffi::AdwAboutDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            unsafe {
                let f: &F = &*(f as *const F);
                f(&from_glib_borrow(this))
            }
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::website".as_ptr(),
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_website_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v1_5")]
#[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
impl Default for AboutDialog {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`AboutDialog`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct AboutDialogBuilder {
    builder: glib::object::ObjectBuilder<'static, AboutDialog>,
}

impl AboutDialogBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v1_9")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_9")))]
    pub fn appdata_resource_path(self, appdata_resource_path: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("appdata-resource-path", appdata_resource_path.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn application_icon(self, application_icon: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("application-icon", application_icon.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn application_name(self, application_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("application-name", application_name.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn artists(self, artists: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("artists", artists.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn comments(self, comments: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("comments", comments.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn copyright(self, copyright: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("copyright", copyright.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn debug_info(self, debug_info: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("debug-info", debug_info.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn debug_info_filename(self, debug_info_filename: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("debug-info-filename", debug_info_filename.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn designers(self, designers: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("designers", designers.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn developer_name(self, developer_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("developer-name", developer_name.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn developers(self, developers: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("developers", developers.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn documenters(self, documenters: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("documenters", documenters.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn issue_url(self, issue_url: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("issue-url", issue_url.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn license(self, license: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("license", license.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn license_type(self, license_type: gtk::License) -> Self {
        Self {
            builder: self.builder.property("license-type", license_type),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn release_notes(self, release_notes: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("release-notes", release_notes.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn release_notes_version(self, release_notes_version: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("release-notes-version", release_notes_version.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn support_url(self, support_url: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("support-url", support_url.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn translator_credits(self, translator_credits: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("translator-credits", translator_credits.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn version(self, version: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("version", version.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn website(self, website: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("website", website.into()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn can_close(self, can_close: bool) -> Self {
        Self {
            builder: self.builder.property("can-close", can_close),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn child(self, child: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn content_height(self, content_height: i32) -> Self {
        Self {
            builder: self.builder.property("content-height", content_height),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn content_width(self, content_width: i32) -> Self {
        Self {
            builder: self.builder.property("content-width", content_width),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn default_widget(self, default_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("default-widget", default_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn focus_widget(self, focus_widget: &impl IsA<gtk::Widget>) -> Self {
        Self {
            builder: self
                .builder
                .property("focus-widget", focus_widget.clone().upcast()),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn follows_content_size(self, follows_content_size: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("follows-content-size", follows_content_size),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn presentation_mode(self, presentation_mode: DialogPresentationMode) -> Self {
        Self {
            builder: self
                .builder
                .property("presentation-mode", presentation_mode),
        }
    }

    #[cfg(feature = "v1_5")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v1_5")))]
    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn can_target(self, can_target: bool) -> Self {
        Self {
            builder: self.builder.property("can-target", can_target),
        }
    }

    pub fn css_classes(self, css_classes: impl Into<glib::StrV>) -> Self {
        Self {
            builder: self.builder.property("css-classes", css_classes.into()),
        }
    }

    pub fn css_name(self, css_name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("css-name", css_name.into()),
        }
    }

    pub fn cursor(self, cursor: &gdk::Cursor) -> Self {
        Self {
            builder: self.builder.property("cursor", cursor.clone()),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn focusable(self, focusable: bool) -> Self {
        Self {
            builder: self.builder.property("focusable", focusable),
        }
    }

    pub fn halign(self, halign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn layout_manager(self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        Self {
            builder: self
                .builder
                .property("layout-manager", layout_manager.clone().upcast()),
        }
    }

    #[cfg(feature = "gtk_v4_18")]
    #[cfg_attr(docsrs, doc(cfg(feature = "gtk_v4_18")))]
    pub fn limit_events(self, limit_events: bool) -> Self {
        Self {
            builder: self.builder.property("limit-events", limit_events),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn overflow(self, overflow: gtk::Overflow) -> Self {
        Self {
            builder: self.builder.property("overflow", overflow),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: gtk::Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn accessible_role(self, accessible_role: gtk::AccessibleRole) -> Self {
        Self {
            builder: self.builder.property("accessible-role", accessible_role),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`AboutDialog`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> AboutDialog {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
