/* -*- mode: C; c-file-style: "gnu"; indent-tabs-mode: nil; -*-
 *
 * Copyright 2025 GNOME Foundation, Inc.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *  - Philip Withnall <pwithnall@gnome.org>
 */

#include "config.h"

#include <glib.h>
#include <glib/gi18n.h>
#include <libgsystemservice/service.h>
#include <libmalcontent-timer/extension-agent-service.h>
#include <signal.h>


int
main (int   argc,
      char *argv[])
{
  g_autoptr(GError) error = NULL;
  g_autoptr(MctExtensionAgentService) service = NULL;

  /* Set up a D-Bus service and run until we are killed. */
  service = mct_extension_agent_service_new ();
  gss_service_run (GSS_SERVICE (service), argc, argv, &error);

  if (error != NULL)
    {
      if (g_error_matches (error,
                           GSS_SERVICE_ERROR, GSS_SERVICE_ERROR_SIGNALLED))
        raise (gss_service_get_exit_signal (GSS_SERVICE (service)));
      else if (g_error_matches (error,
                                GSS_SERVICE_ERROR, GSS_SERVICE_ERROR_TIMEOUT))
        {
          g_message (_("Exiting due to reaching inactivity timeout"));
          return 0;
        }

      g_printerr ("%s: %s\n", argv[0], error->message);

      return gss_service_error_to_exit_status (error->code);
    }

  return 0;
}

