// media/mojo/mojom/video_decoder.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/video_decoder.mojom-shared-internal.h"
#include "gpu/ipc/common/sync_token.mojom-shared.h"
#include "media/mojo/mojom/media_log.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace media::mojom {
class SupportedVideoDecoderConfigDataView;

class CommandBufferIdDataView;

using OverlayInfoDataView = mojo::native::NativeStructDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::SupportedVideoDecoderConfigDataView> {
  using Data = ::media::mojom::internal::SupportedVideoDecoderConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::CommandBufferIdDataView> {
  using Data = ::media::mojom::internal::CommandBufferId_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class VideoFrameHandleReleaserInterfaceBase {};

using VideoFrameHandleReleaserPtrDataView =
    mojo::InterfacePtrDataView<VideoFrameHandleReleaserInterfaceBase>;
using VideoFrameHandleReleaserRequestDataView =
    mojo::InterfaceRequestDataView<VideoFrameHandleReleaserInterfaceBase>;
using VideoFrameHandleReleaserAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoFrameHandleReleaserInterfaceBase>;
using VideoFrameHandleReleaserAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoFrameHandleReleaserInterfaceBase>;
class VideoDecoderInterfaceBase {};

using VideoDecoderPtrDataView =
    mojo::InterfacePtrDataView<VideoDecoderInterfaceBase>;
using VideoDecoderRequestDataView =
    mojo::InterfaceRequestDataView<VideoDecoderInterfaceBase>;
using VideoDecoderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoDecoderInterfaceBase>;
using VideoDecoderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoDecoderInterfaceBase>;
class VideoDecoderClientInterfaceBase {};

using VideoDecoderClientPtrDataView =
    mojo::InterfacePtrDataView<VideoDecoderClientInterfaceBase>;
using VideoDecoderClientRequestDataView =
    mojo::InterfaceRequestDataView<VideoDecoderClientInterfaceBase>;
using VideoDecoderClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<VideoDecoderClientInterfaceBase>;
using VideoDecoderClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<VideoDecoderClientInterfaceBase>;


class SupportedVideoDecoderConfigDataView {
 public:
  SupportedVideoDecoderConfigDataView() = default;

  SupportedVideoDecoderConfigDataView(
      internal::SupportedVideoDecoderConfig_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProfileMin(UserType* output) const {
    auto data_value = data_->profile_min;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile_min() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile_min));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadProfileMax(UserType* output) const {
    auto data_value = data_->profile_max;
    return mojo::internal::Deserialize<::media::mojom::VideoCodecProfile>(
        data_value, output);
  }
  ::media::mojom::VideoCodecProfile profile_max() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media::mojom::VideoCodecProfile>(data_->profile_max));
  }
  inline void GetCodedSizeMinDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSizeMin(UserType* output) {
    
    auto* pointer = data_->coded_size_min.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetCodedSizeMaxDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCodedSizeMax(UserType* output) {
    
    auto* pointer = data_->coded_size_max.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool allow_encrypted() const {
    return data_->allow_encrypted;
  }
  bool require_encrypted() const {
    return data_->require_encrypted;
  }
 private:
  internal::SupportedVideoDecoderConfig_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CommandBufferIdDataView {
 public:
  CommandBufferIdDataView() = default;

  CommandBufferIdDataView(
      internal::CommandBufferId_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChannelTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChannelToken(UserType* output) {
    
    auto* pointer = data_->channel_token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  int32_t route_id() const {
    return data_->route_id;
  }
 private:
  internal::CommandBufferId_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::SupportedVideoDecoderConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::SupportedVideoDecoderConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::SupportedVideoDecoderConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile_min(input), &fragment->profile_min);
    mojo::internal::Serialize<::media::mojom::VideoCodecProfile>(
        Traits::profile_max(input), &fragment->profile_max);
    decltype(Traits::coded_size_min(input)) in_coded_size_min = Traits::coded_size_min(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size_min)::BaseType> coded_size_min_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size_min, coded_size_min_fragment);
    fragment->coded_size_min.Set(
        coded_size_min_fragment.is_null() ? nullptr : coded_size_min_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size_min.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size_min in SupportedVideoDecoderConfig struct");
    decltype(Traits::coded_size_max(input)) in_coded_size_max = Traits::coded_size_max(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->coded_size_max)::BaseType> coded_size_max_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_coded_size_max, coded_size_max_fragment);
    fragment->coded_size_max.Set(
        coded_size_max_fragment.is_null() ? nullptr : coded_size_max_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->coded_size_max.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null coded_size_max in SupportedVideoDecoderConfig struct");
    fragment->allow_encrypted = Traits::allow_encrypted(input);
    fragment->require_encrypted = Traits::require_encrypted(input);
  }

  static bool Deserialize(::media::mojom::internal::SupportedVideoDecoderConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::SupportedVideoDecoderConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::CommandBufferIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::CommandBufferIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::CommandBufferId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::channel_token(input)) in_channel_token = Traits::channel_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->channel_token)::BaseType> channel_token_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_channel_token, channel_token_fragment);
    fragment->channel_token.Set(
        channel_token_fragment.is_null() ? nullptr : channel_token_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->channel_token.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null channel_token in CommandBufferId struct");
    fragment->route_id = Traits::route_id(input);
  }

  static bool Deserialize(::media::mojom::internal::CommandBufferId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::CommandBufferIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void SupportedVideoDecoderConfigDataView::GetCodedSizeMinDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size_min.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}
inline void SupportedVideoDecoderConfigDataView::GetCodedSizeMaxDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->coded_size_max.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, message_);
}


inline void CommandBufferIdDataView::GetChannelTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->channel_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_VIDEO_DECODER_MOJOM_SHARED_H_