// services/media_session/public/mojom/audio_focus.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_SHARED_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/media_session/public/mojom/audio_focus.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media_session::mojom {
class AudioFocusRequestStateDataView;



}  // media_session::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media_session::mojom::AudioFocusRequestStateDataView> {
  using Data = ::media_session::mojom::internal::AudioFocusRequestState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media_session::mojom {


enum class EnforcementMode : int32_t {
  
  kDefault = 0,
  
  kNone = 1,
  
  kSingleGroup = 2,
  
  kSingleSession = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, EnforcementMode value);
inline bool IsKnownEnumValue(EnforcementMode value) {
  return internal::EnforcementMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AudioFocusType : int32_t {
  
  kGain = 0,
  
  kGainTransientMayDuck = 1,
  
  kGainTransient = 2,
  
  kAmbient = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AudioFocusType value);
inline bool IsKnownEnumValue(AudioFocusType value) {
  return internal::AudioFocusType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AudioFocusObserverInterfaceBase {};

using AudioFocusObserverPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusObserverInterfaceBase>;
using AudioFocusObserverRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusObserverInterfaceBase>;
using AudioFocusObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusObserverInterfaceBase>;
using AudioFocusObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusObserverInterfaceBase>;
class AudioFocusRequestClientInterfaceBase {};

using AudioFocusRequestClientPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusRequestClientInterfaceBase>;
using AudioFocusRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusRequestClientInterfaceBase>;
using AudioFocusRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusRequestClientInterfaceBase>;
using AudioFocusRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusRequestClientInterfaceBase>;
class AudioFocusManagerInterfaceBase {};

using AudioFocusManagerPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusManagerInterfaceBase>;
using AudioFocusManagerRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusManagerInterfaceBase>;
using AudioFocusManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusManagerInterfaceBase>;
using AudioFocusManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusManagerInterfaceBase>;
class AudioFocusManagerDebugInterfaceBase {};

using AudioFocusManagerDebugPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusManagerDebugInterfaceBase>;
using AudioFocusManagerDebugRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusManagerDebugInterfaceBase>;
using AudioFocusManagerDebugAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusManagerDebugInterfaceBase>;
using AudioFocusManagerDebugAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusManagerDebugInterfaceBase>;


class AudioFocusRequestStateDataView {
 public:
  AudioFocusRequestStateDataView() = default;

  AudioFocusRequestStateDataView(
      internal::AudioFocusRequestState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionInfoDataView(
      ::media_session::mojom::MediaSessionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionInfo(UserType* output) {
    
    auto* pointer = data_->session_info.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAudioFocusType(UserType* output) const {
    auto data_value = data_->audio_focus_type;
    return mojo::internal::Deserialize<::media_session::mojom::AudioFocusType>(
        data_value, output);
  }
  AudioFocusType audio_focus_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::AudioFocusType>(data_->audio_focus_type));
  }
  inline void GetSourceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `source_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceName` instead "
    "of `ReadSourceName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->source_name.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestId` instead "
    "of `ReadRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->request_id.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetSourceIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `source_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceId` instead "
    "of `ReadSourceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 9
                    ? data_->source_id.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioFocusRequestState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media_session::mojom

namespace std {

template <>
struct hash<::media_session::mojom::EnforcementMode>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::EnforcementMode> {};

template <>
struct hash<::media_session::mojom::AudioFocusType>
    : public mojo::internal::EnumHashImpl<::media_session::mojom::AudioFocusType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::EnforcementMode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::EnforcementMode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::EnforcementMode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::AudioFocusType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_session::mojom::AudioFocusType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_session::mojom::AudioFocusType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_session::mojom::AudioFocusRequestStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::AudioFocusRequestStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::AudioFocusRequestState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::session_info(input)) in_session_info = Traits::session_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_info)::BaseType> session_info_fragment(
            fragment.message());
    mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView>(
        in_session_info, session_info_fragment);
    fragment->session_info.Set(
        session_info_fragment.is_null() ? nullptr : session_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_info in AudioFocusRequestState struct");
    mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
        Traits::audio_focus_type(input), &fragment->audio_focus_type);
    decltype(Traits::source_name(input)) in_source_name = Traits::source_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_name)::BaseType> source_name_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_source_name, source_name_fragment);
    fragment->source_name.Set(
        source_name_fragment.is_null() ? nullptr : source_name_fragment.data());
    decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->request_id)::BaseType> request_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_request_id, request_id_fragment);
    fragment->request_id.Set(
        request_id_fragment.is_null() ? nullptr : request_id_fragment.data());
    decltype(Traits::source_id(input)) in_source_id = Traits::source_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_id)::BaseType> source_id_fragment(
            fragment.message());
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
        in_source_id, source_id_fragment);
    fragment->source_id.Set(
        source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  }

  static bool Deserialize(::media_session::mojom::internal::AudioFocusRequestState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_session::mojom::AudioFocusRequestStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media_session::mojom {

inline void AudioFocusRequestStateDataView::GetSessionInfoDataView(
    ::media_session::mojom::MediaSessionInfoDataView* output) {
  auto pointer = data_->session_info.Get();
  *output = ::media_session::mojom::MediaSessionInfoDataView(pointer, message_);
}
inline void AudioFocusRequestStateDataView::GetSourceNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_.version >= 2
                 ? data_->source_name.Get() : nullptr;
  *output = mojo::StringDataView(pointer, message_);
}
inline void AudioFocusRequestStateDataView::GetRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->header_.version >= 3
                 ? data_->request_id.Get() : nullptr;
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}
inline void AudioFocusRequestStateDataView::GetSourceIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->header_.version >= 9
                 ? data_->source_id.Get() : nullptr;
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // media_session::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::EnforcementMode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::EnforcementMode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_session::mojom::AudioFocusType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_session::mojom::AudioFocusType value);
};

} // namespace perfetto

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_SHARED_H_