// services/network/public/mojom/network_param.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_param.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_param.mojom-params-data.h"
#include "services/network/public/mojom/network_param.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_param.mojom-blink-import-headers.h"
#include "services/network/public/mojom/network_param.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
AuthChallengeInfo::AuthChallengeInfo()
    : is_proxy(),
      challenger(),
      scheme(),
      realm(),
      challenge(),
      path() {}

AuthChallengeInfo::AuthChallengeInfo(
    bool is_proxy_in,
    const ::url::SchemeHostPort& challenger_in,
    const WTF::String& scheme_in,
    const WTF::String& realm_in,
    const WTF::String& challenge_in,
    const WTF::String& path_in)
    : is_proxy(std::move(is_proxy_in)),
      challenger(std::move(challenger_in)),
      scheme(std::move(scheme_in)),
      realm(std::move(realm_in)),
      challenge(std::move(challenge_in)),
      path(std::move(path_in)) {}

AuthChallengeInfo::~AuthChallengeInfo() = default;

void AuthChallengeInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_proxy"), this->is_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenger"), this->challenger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::SchemeHostPort&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "realm"), this->realm,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "path"), this->path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthChallengeInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpVersion::HttpVersion()
    : major_value(),
      minor_value() {}

HttpVersion::HttpVersion(
    uint16_t major_value_in,
    uint16_t minor_value_in)
    : major_value(std::move(major_value_in)),
      minor_value(std::move(minor_value_in)) {}

HttpVersion::~HttpVersion() = default;
size_t HttpVersion::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->major_value);
  seed = mojo::internal::WTFHash(seed, this->minor_value);
  return seed;
}

void HttpVersion::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "major_value"), this->major_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "minor_value"), this->minor_value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HttpVersion::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HostPortPair::HostPortPair()
    : host(),
      port() {}

HostPortPair::HostPortPair(
    const WTF::String& host_in,
    uint16_t port_in)
    : host(std::move(host_in)),
      port(std::move(port_in)) {}

HostPortPair::~HostPortPair() = default;

void HostPortPair::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host"), this->host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HostPortPair::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyServer::ProxyServer()
    : scheme(),
      host_and_port() {}

ProxyServer::ProxyServer(
    ProxyScheme scheme_in,
    const std::optional<::net::HostPortPair>& host_and_port_in)
    : scheme(std::move(scheme_in)),
      host_and_port(std::move(host_and_port_in)) {}

ProxyServer::~ProxyServer() = default;

void ProxyServer::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scheme"), this->scheme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProxyScheme>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_and_port"), this->host_and_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::net::HostPortPair>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyServer::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ProxyChain::ProxyChain()
    : proxy_servers(),
      ip_protection_chain_id() {}

ProxyChain::ProxyChain(
    std::optional<WTF::Vector<ProxyServerPtr>> proxy_servers_in,
    int32_t ip_protection_chain_id_in)
    : proxy_servers(std::move(proxy_servers_in)),
      ip_protection_chain_id(std::move(ip_protection_chain_id_in)) {}

ProxyChain::~ProxyChain() = default;

void ProxyChain::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "proxy_servers"), this->proxy_servers,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<ProxyServerPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip_protection_chain_id"), this->ip_protection_chain_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyChain::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResolveErrorInfo::ResolveErrorInfo()
    : error(),
      is_secure_network_error(false) {}

ResolveErrorInfo::ResolveErrorInfo(
    int32_t error_in,
    bool is_secure_network_error_in)
    : error(std::move(error_in)),
      is_secure_network_error(std::move(is_secure_network_error_in)) {}

ResolveErrorInfo::~ResolveErrorInfo() = default;
size_t ResolveErrorInfo::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->error);
  seed = mojo::internal::WTFHash(seed, this->is_secure_network_error);
  return seed;
}

void ResolveErrorInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error"), this->error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_secure_network_error"), this->is_secure_network_error,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResolveErrorInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SSLCertRequestInfo::SSLCertRequestInfo()
    : host_and_port(),
      is_proxy(false),
      cert_authorities(),
      signature_algorithms() {}

SSLCertRequestInfo::SSLCertRequestInfo(
    const ::net::HostPortPair& host_and_port_in,
    bool is_proxy_in,
    WTF::Vector<WTF::String> cert_authorities_in,
    WTF::Vector<uint16_t> signature_algorithms_in)
    : host_and_port(std::move(host_and_port_in)),
      is_proxy(std::move(is_proxy_in)),
      cert_authorities(std::move(cert_authorities_in)),
      signature_algorithms(std::move(signature_algorithms_in)) {}

SSLCertRequestInfo::~SSLCertRequestInfo() = default;

void SSLCertRequestInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "host_and_port"), this->host_and_port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::HostPortPair&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_proxy"), this->is_proxy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cert_authorities"), this->cert_authorities,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature_algorithms"), this->signature_algorithms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint16_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SSLCertRequestInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetLogSource::NetLogSource()
    : source_type(),
      source_id(),
      start_time() {}

NetLogSource::NetLogSource(
    uint32_t source_type_in,
    uint32_t source_id_in,
    ::base::TimeTicks start_time_in)
    : source_type(std::move(source_type_in)),
      source_id(std::move(source_id_in)),
      start_time(std::move(start_time_in)) {}

NetLogSource::~NetLogSource() = default;

void NetLogSource::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_type"), this->source_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_id"), this->source_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "start_time"), this->start_time,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NetLogSource::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::AuthChallengeInfo::DataView, ::network::mojom::blink::AuthChallengeInfoPtr>::Read(
    ::network::mojom::blink::AuthChallengeInfo::DataView input,
    ::network::mojom::blink::AuthChallengeInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::AuthChallengeInfoPtr result(::network::mojom::blink::AuthChallengeInfo::New());
  
      if (success)
        result->is_proxy = input.is_proxy();
      if (success && !input.ReadChallenger(&result->challenger))
        success = false;
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadRealm(&result->realm))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadPath(&result->path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::HttpVersion::DataView, ::network::mojom::blink::HttpVersionPtr>::Read(
    ::network::mojom::blink::HttpVersion::DataView input,
    ::network::mojom::blink::HttpVersionPtr* output) {
  bool success = true;
  ::network::mojom::blink::HttpVersionPtr result(::network::mojom::blink::HttpVersion::New());
  
      if (success)
        result->major_value = input.major_value();
      if (success)
        result->minor_value = input.minor_value();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::HostPortPair::DataView, ::network::mojom::blink::HostPortPairPtr>::Read(
    ::network::mojom::blink::HostPortPair::DataView input,
    ::network::mojom::blink::HostPortPairPtr* output) {
  bool success = true;
  ::network::mojom::blink::HostPortPairPtr result(::network::mojom::blink::HostPortPair::New());
  
      if (success && !input.ReadHost(&result->host))
        success = false;
      if (success)
        result->port = input.port();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyServer::DataView, ::network::mojom::blink::ProxyServerPtr>::Read(
    ::network::mojom::blink::ProxyServer::DataView input,
    ::network::mojom::blink::ProxyServerPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyServerPtr result(::network::mojom::blink::ProxyServer::New());
  
      if (success && !input.ReadScheme(&result->scheme))
        success = false;
      if (success && !input.ReadHostAndPort(&result->host_and_port))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ProxyChain::DataView, ::network::mojom::blink::ProxyChainPtr>::Read(
    ::network::mojom::blink::ProxyChain::DataView input,
    ::network::mojom::blink::ProxyChainPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyChainPtr result(::network::mojom::blink::ProxyChain::New());
  
      if (success && !input.ReadProxyServers(&result->proxy_servers))
        success = false;
      if (success)
        result->ip_protection_chain_id = input.ip_protection_chain_id();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::ResolveErrorInfo::DataView, ::network::mojom::blink::ResolveErrorInfoPtr>::Read(
    ::network::mojom::blink::ResolveErrorInfo::DataView input,
    ::network::mojom::blink::ResolveErrorInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::ResolveErrorInfoPtr result(::network::mojom::blink::ResolveErrorInfo::New());
  
      if (success)
        result->error = input.error();
      if (success)
        result->is_secure_network_error = input.is_secure_network_error();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::SSLCertRequestInfo::DataView, ::network::mojom::blink::SSLCertRequestInfoPtr>::Read(
    ::network::mojom::blink::SSLCertRequestInfo::DataView input,
    ::network::mojom::blink::SSLCertRequestInfoPtr* output) {
  bool success = true;
  ::network::mojom::blink::SSLCertRequestInfoPtr result(::network::mojom::blink::SSLCertRequestInfo::New());
  
      if (success && !input.ReadHostAndPort(&result->host_and_port))
        success = false;
      if (success)
        result->is_proxy = input.is_proxy();
      if (success && !input.ReadCertAuthorities(&result->cert_authorities))
        success = false;
      if (success && !input.ReadSignatureAlgorithms(&result->signature_algorithms))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::NetLogSource::DataView, ::network::mojom::blink::NetLogSourcePtr>::Read(
    ::network::mojom::blink::NetLogSource::DataView input,
    ::network::mojom::blink::NetLogSourcePtr* output) {
  bool success = true;
  ::network::mojom::blink::NetLogSourcePtr result(::network::mojom::blink::NetLogSource::New());
  
      if (success)
        result->source_type = input.source_type();
      if (success)
        result->source_id = input.source_id();
      if (success && !input.ReadStartTime(&result->start_time))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif